/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

public class MathUtils {
    public static float PI = (float)Math.PI;
    public static float PI_HALF = 1.5707964f;
    public static float PI2 = PI * 2.0f;

    public static float abs(float value) {
        return Math.abs(value);
    }

    public static float rad(float angle) {
        return angle * PI / 180.0f;
    }

    public static float deg(float angle) {
        return angle * 180.0f / PI;
    }

    public static float sqrt(float value) {
        return (float)Math.sqrt(value);
    }

    public static float cos(float value) {
        return (float)Math.cos(value);
    }

    public static float sin(float value) {
        return (float)Math.sin(value);
    }

    public static float acos(float value) {
        return (float)Math.acos(value);
    }

    public static float atan2(float y, float x) {
        return (float)Math.atan2(y, x);
    }

    public static float asin(float a) {
        return (float)Math.asin(a);
    }

    public static float lerp(float a, float b, float t) {
        return (1.0f - t) * a + t * b;
    }

    public static double lerp(double a, double b, double t) {
        return (1.0 - t) * a + t * b;
    }

    public static float lerpRot(float a, float b, float t) {
        float wrap = MathUtils.rad(MathUtils.wrapDegrees(MathUtils.deg(b) - MathUtils.deg(a)));
        return a + t * wrap;
    }

    public static float floatSafe(float f) {
        if (Float.isNaN(f)) {
            return 0.0f;
        }
        return f;
    }

    public static float wrapDegrees(float angle) {
        float f = angle % 360.0f;
        if (f >= 180.0f) {
            f -= 360.0f;
        }
        if (f < -180.0f) {
            f += 360.0f;
        }
        return f;
    }

    public static float clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    public static boolean equalsApprox(float a, float b) {
        float tolerance;
        float diff = Math.abs(b - a);
        return diff < (tolerance = 0.001f * b);
    }

    public static float catmullrom(float previous, float current, float next, float nextNext, float f) {
        return 0.5f * (2.0f * current + (next - previous) * f + (2.0f * previous - 5.0f * current + 4.0f * next - nextNext) * f * f + (3.0f * current - previous - 3.0f * next + nextNext) * f * f * f);
    }

    public static float progressOfTime(float ticks, float value) {
        return ticks % value / value;
    }

    public static float arrange(float oldMin, float oldMax, float newMin, float newMax, float value) {
        float newValue;
        float oldRange = oldMax - oldMin;
        if (oldRange == 0.0f) {
            newValue = newMin;
        } else {
            float newRange = newMax - newMin;
            newValue = (value - oldMin) * newRange / oldRange + newMin;
        }
        return newValue;
    }
}

