/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.animal.horse.AbstractHorse;
import net.minecraft.world.entity.decoration.ArmorStand;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.common.util.ITeleporter;
import ru.blatfan.blatapi.common.core.BlockPosDim;
import ru.blatfan.blatapi.utils.DimensionTransit;
import ru.blatfan.blatapi.utils.ItemHelper;

public class PlayerUtil {
    public static void swapArmorStand(ArmorStand stand, Player player, InteractionHand hand) {
        ItemStack heldPlayer = player.m_21120_(hand).m_41777_();
        ItemStack heldStand = stand.m_21120_(hand).m_41777_();
        EquipmentSlot slot = hand == InteractionHand.MAIN_HAND ? EquipmentSlot.MAINHAND : EquipmentSlot.OFFHAND;
        stand.m_8061_(slot, heldPlayer);
        player.m_8061_(slot, heldStand);
    }

    public static boolean isTamedByPlayer(AbstractHorse horse, Player dmgOwner) {
        return horse.m_30614_() && horse.m_21805_() != null && horse.m_21805_().equals(dmgOwner.m_20148_());
    }

    public static boolean isTamedByPlayer(TamableAnimal horse, Player dmgOwner) {
        return horse.m_21824_() && horse.m_21805_() != null && horse.m_21805_().equals(dmgOwner.m_20148_());
    }

    public static void clearAllExp(Player player) {
        player.f_36080_ = 0.0f;
        player.f_36078_ = 0;
        player.f_36079_ = 0;
    }

    public static double getExpTotal(Player player) {
        int level = player.f_36078_;
        double totalExp = PlayerUtil.getXpForLevel(level);
        double progress = Math.round((float)player.m_36323_() * player.f_36080_);
        return totalExp += (double)((int)progress);
    }

    public static boolean isPlayerCrouching(Entity entity) {
        return entity instanceof Player && ((Player)entity).m_6047_();
    }

    public static int getXpForLevel(int level) {
        int totalExp = 0;
        totalExp = level <= 15 ? level * level + 6 * level : (level <= 30 ? (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0) : (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0));
        return totalExp;
    }

    public static ItemStack getPlayerItemIfHeld(Player player) {
        ItemStack wand = player.m_21205_();
        if (wand.m_41619_()) {
            wand = player.m_21206_();
        }
        return wand;
    }

    public static int getFirstSlotWithBlock(Player player, BlockState targetState) {
        int ret = -1;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_()) continue;
            stack.m_41720_();
            if (Block.m_49814_((Item)stack.m_41720_()) != targetState.m_60734_()) continue;
            return i;
        }
        return ret;
    }

    public static BlockState getBlockstateFromSlot(Player player, int slot) {
        ItemStack stack = player.m_150109_().m_8020_(slot);
        if (!stack.m_41619_()) {
            stack.m_41720_();
            Block.m_49814_((Item)stack.m_41720_());
            Block b = Block.m_49814_((Item)stack.m_41720_());
            return b.m_49966_();
        }
        return null;
    }

    public static void decrStackSize(Player player, int slot) {
        if (!player.m_7500_() && slot >= 0) {
            player.m_150109_().m_7407_(slot, 1);
        }
    }

    public static Item getItemArmorSlot(Player player, EquipmentSlot slot) {
        ItemStack inslot = (ItemStack)player.m_150109_().f_35975_.get(slot.m_20749_());
        Item item = inslot.m_41619_() ? null : inslot.m_41720_();
        return item;
    }

    public static Optional<Vec3> getPlayerHome(ServerPlayer player) {
        BlockPos respawnPos = player.m_8961_();
        Optional optional = Optional.empty();
        if (respawnPos != null) {
            optional = Player.m_36130_((ServerLevel)((ServerLevel)player.m_9236_()), (BlockPos)respawnPos, (float)0.0f, (boolean)true, (boolean)true);
        }
        return optional;
    }

    public static boolean hasFreeSlot(Player player) {
        return PlayerUtil.getFreeSlot(player) > -1;
    }

    public static int getFreeSlot(Player player) {
        return player.m_150109_().m_36062_();
    }

    public static void addItem(Player player, ItemStack stack) {
        if (!player.m_150109_().m_36054_(stack)) {
            Level level = player.m_9236_();
            ItemEntity entityItem = new ItemEntity(level, player.m_20185_(), player.m_20186_() + 0.5, player.m_20189_(), stack);
            entityItem.m_32010_(0);
            level.m_7967_((Entity)entityItem);
        }
    }

    public static boolean hasItem(Player player, ItemStack stack) {
        return PlayerUtil.itemCount(player, stack) > 0;
    }

    public static int removeItem(Player player, ItemStack stack, int count) {
        int remaining = count;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack slotStack = player.m_150109_().m_8020_(i);
            if (!ItemHelper.areStacksEqual(slotStack, stack)) continue;
            int toRemove = Math.min(slotStack.m_41613_(), remaining);
            slotStack.m_41774_(toRemove);
            if ((remaining -= toRemove) <= 0) break;
        }
        return count - remaining;
    }

    public static int removeItem(Player player, ItemStack stack) {
        return PlayerUtil.removeItem(player, stack, 1);
    }

    public static int itemCount(Player player, ItemStack stack) {
        int count = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack slotStack = player.m_150109_().m_8020_(i);
            if (!ItemHelper.areStacksEqual(slotStack, stack)) continue;
            count += slotStack.m_41613_();
        }
        return count;
    }

    public static int itemCount(Player player, Item item) {
        int count = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack slotStack = player.m_150109_().m_8020_(i);
            if (!slotStack.m_150930_(item)) continue;
            count += slotStack.m_41613_();
        }
        return count;
    }

    public static boolean hasEnoughItems(Player player, ItemStack stack, int requiredCount) {
        return PlayerUtil.itemCount(player, stack) >= requiredCount;
    }

    public static NonNullList<ItemStack> copyInventory(Player player) {
        NonNullList copy = NonNullList.m_122780_((int)player.m_150109_().m_6643_(), (Object)ItemStack.f_41583_);
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            copy.set(i, (Object)stack.m_41777_());
        }
        return copy;
    }

    public static int clearItem(Player player, ItemStack stack) {
        int removed = 0;
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack slotStack = player.m_150109_().m_8020_(i);
            if (!ItemHelper.areStacksEqual(slotStack, stack)) continue;
            removed += slotStack.m_41613_();
            player.m_150109_().m_6836_(i, ItemStack.f_41583_);
        }
        return removed;
    }

    public static CompoundTag serializeInventory(Player player) {
        CompoundTag nbt = new CompoundTag();
        ListTag inventoryList = new ListTag();
        for (int i = 0; i < player.m_150109_().m_6643_(); ++i) {
            ItemStack stack = player.m_150109_().m_8020_(i);
            if (stack.m_41619_()) continue;
            CompoundTag itemTag = new CompoundTag();
            itemTag.m_128344_("Slot", (byte)i);
            stack.m_41739_(itemTag);
            inventoryList.add((Object)itemTag);
        }
        nbt.m_128365_("Inventory", (Tag)inventoryList);
        return nbt;
    }

    public static void deserializeInventory(Player player, CompoundTag nbt) {
        if (nbt.m_128425_("Inventory", 9)) {
            ListTag inventoryList = nbt.m_128437_("Inventory", 10);
            for (int i = 0; i < inventoryList.size(); ++i) {
                CompoundTag itemTag = inventoryList.m_128728_(i);
                int slot = itemTag.m_128445_("Slot") & 0xFF;
                if (slot < 0 || slot >= player.m_150109_().m_6643_()) continue;
                ItemStack stack = ItemStack.m_41712_((CompoundTag)itemTag);
                player.m_150109_().m_6836_(slot, stack);
            }
        }
    }

    public static void setCooldownItem(Player player, Item item, int cooldown) {
        player.m_36335_().m_41524_(item, cooldown);
    }

    public static void dimensionTeleport(ServerPlayer player, ServerLevel world, BlockPosDim loc) {
        if (player instanceof FakePlayer) {
            return;
        }
        if (!player.m_6072_()) {
            return;
        }
        if (!world.f_46443_) {
            DimensionTransit transit = new DimensionTransit(world, loc);
            transit.teleport((Player)player);
            player.changeDimension(transit.getTargetLevel(), (ITeleporter)transit);
        }
    }

    public static CompoundTag getPersistedDataSubcompound(Player player, String subCompoundKey) {
        CompoundTag persistedData;
        CompoundTag forgeData = player.getPersistentData();
        if (!forgeData.m_128441_("PlayerPersisted")) {
            forgeData.m_128365_("PlayerPersisted", (Tag)new CompoundTag());
        }
        if (!(persistedData = forgeData.m_128469_("PlayerPersisted")).m_128441_(subCompoundKey)) {
            persistedData.m_128365_(subCompoundKey, (Tag)new CompoundTag());
        }
        return persistedData.m_128469_(subCompoundKey);
    }
}

