/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import com.google.common.base.Stopwatch;
import com.google.common.collect.ImmutableMap;
import it.unimi.dsi.fastutil.objects.Object2ObjectLinkedOpenHashMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraftforge.client.event.RecipesUpdatedEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.crafting.conditions.ICondition;
import net.minecraftforge.event.AddReloadListenerEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import ru.blatfan.blatapi.common.events.RecipeManagerLoadingEvent;

public final class RecipeHelper {
    private static RecipeManager recipeManager;
    private static final Logger LOGGER;

    public static RecipeManager getRecipeManager() {
        if (recipeManager == null) {
            return new RecipeManager(ICondition.IContext.EMPTY);
        }
        return recipeManager;
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onAddReloadListeners(AddReloadListenerEvent event) {
        recipeManager = event.getServerResources().m_206887_();
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onRecipesUpdated(RecipesUpdatedEvent event) {
        recipeManager = event.getRecipeManager();
    }

    public static Map<RecipeType<?>, Map<ResourceLocation, Recipe<?>>> getRecipes() {
        return RecipeHelper.getRecipeManager().f_44007_;
    }

    public static Recipe<?> getRecipe(ResourceLocation id) {
        for (Recipe recipe : RecipeHelper.getRecipeManager().m_44051_()) {
            if (!recipe.m_6423_().equals((Object)id)) continue;
            return recipe;
        }
        return null;
    }

    public static <C extends Container, T extends Recipe<C>> List<T> getRecipes(RecipeType<T> type) {
        return RecipeHelper.getRecipeManager().m_44013_(type);
    }

    public static void addRecipe(Recipe<?> recipe) {
        if (RecipeHelper.recipeManager.f_44007_ instanceof ImmutableMap) {
            RecipeHelper.recipeManager.f_44007_ = new HashMap(RecipeHelper.recipeManager.f_44007_);
            RecipeHelper.recipeManager.f_44007_.replaceAll((t, v) -> new HashMap((Map)RecipeHelper.recipeManager.f_44007_.get(t)));
        }
        if (RecipeHelper.recipeManager.f_199900_ instanceof ImmutableMap) {
            RecipeHelper.recipeManager.f_199900_ = new HashMap(RecipeHelper.recipeManager.f_199900_);
        }
        RecipeHelper.getRecipeManager().f_44007_.computeIfAbsent(recipe.m_6671_(), t -> new HashMap()).put(recipe.m_6423_(), recipe);
        RecipeHelper.getRecipeManager().f_199900_.put(recipe.m_6423_(), recipe);
    }

    public static void fireRecipeManagerLoadedEvent(RecipeManager manager, Map<RecipeType<?>, Object> map, ImmutableMap.Builder<ResourceLocation, Recipe<?>> builder) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList recipes = new ArrayList();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new RecipeManagerLoadingEvent(manager, recipes));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while firing RecipeManagerLoadingEvent", (Throwable)e);
        }
        for (Recipe recipe : recipes) {
            RecipeType recipeType = recipe.m_6671_();
            ResourceLocation recipeId = recipe.m_6423_();
            Object recipeMap = map.get(recipeType);
            if (recipeMap instanceof Object2ObjectLinkedOpenHashMap) {
                Object2ObjectLinkedOpenHashMap o2oRecipeMap = (Object2ObjectLinkedOpenHashMap)recipeMap;
                o2oRecipeMap.put((Object)recipeId, (Object)recipe);
            } else if (recipeMap instanceof ImmutableMap.Builder) {
                recipeMapBuilder = (ImmutableMap.Builder)recipeMap;
                recipeMapBuilder.put((Object)recipeId, (Object)recipe);
            } else if (recipeMap == null) {
                recipeMapBuilder = ImmutableMap.builder();
                recipeMapBuilder.put((Object)recipeId, (Object)recipe);
                map.put(recipeType, recipeMapBuilder);
            } else {
                LOGGER.error("Failed to register recipe {} to map of type {}", (Object)recipeId, recipeMap.getClass());
            }
            builder.put((Object)recipeId, (Object)recipe);
        }
        LOGGER.info("Registered {} recipes in {} ms", (Object)recipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    public static void fireRecipeManagerLoadedEventKubeJSEdition(RecipeManager manager, Map<ResourceLocation, Recipe<?>> recipesByName) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        ArrayList recipes = new ArrayList();
        try {
            MinecraftForge.EVENT_BUS.post((Event)new RecipeManagerLoadingEvent(manager, recipes));
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while firing RecipeManagerLoadingEvent", (Throwable)e);
        }
        for (Recipe recipe : recipes) {
            recipesByName.put(recipe.m_6423_(), recipe);
        }
        LOGGER.info("Registered {} recipes in {} ms (KubeJS mode)", (Object)recipes.size(), (Object)stopwatch.stop().elapsed(TimeUnit.MILLISECONDS));
    }

    static {
        LOGGER = LogManager.getLogger((String)"BA | Recipe Helper");
    }
}

