/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils;

import com.mojang.blaze3d.platform.Lighting;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import java.awt.Color;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.ShaderInstance;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.client.extensions.common.IClientFluidTypeExtensions;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidType;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector4f;
import ru.blatfan.blatapi.fluffy_fur.client.render.FluffyFurRenderType;
import ru.blatfan.blatapi.fluffy_fur.client.render.RenderBuilder;
import ru.blatfan.blatapi.fluffy_fur.client.render.item.CustomItemRenderer;
import ru.blatfan.blatapi.fluffy_fur.registry.client.FluffyFurRenderTypes;
import ru.blatfan.blatapi.utils.ColorHelper;

public class RenderUtil {
    public static CustomItemRenderer customItemRenderer;
    public static float blitOffset;
    public static int FULL_BRIGHT;
    public static Function<Float, Float> FULL_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_IN_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_OUT_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_IN_ROUND_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_OUT_ROUND_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_IN_SEMI_ROUND_WIDTH_FUNCTION;
    public static Function<Float, Float> LINEAR_OUT_SEMI_ROUND_WIDTH_FUNCTION;

    public static ShaderInstance getShader(RenderType type) {
        if (type instanceof FluffyFurRenderType) {
            FluffyFurRenderType renderType = (FluffyFurRenderType)type;
            Optional shader = renderType.state.f_173274_.f_173136_;
            if (shader.isPresent()) {
                return (ShaderInstance)((Supplier)shader.get()).get();
            }
        }
        return null;
    }

    public static CustomItemRenderer getCustomItemRenderer() {
        Minecraft minecraft = Minecraft.m_91087_();
        if (customItemRenderer == null) {
            customItemRenderer = new CustomItemRenderer(minecraft, minecraft.m_91097_(), minecraft.m_91304_(), minecraft.getItemColors(), minecraft.m_91291_().getBlockEntityRenderer());
        }
        return customItemRenderer;
    }

    public static void renderItemModelInGui(ItemStack stack, float x, float y, float xSize, float ySize, float zSize) {
        RenderUtil.renderItemModelInGui(stack, x, y, xSize, ySize, zSize, 0.0f, 0.0f, 0.0f);
    }

    public static void renderItemModelInGui(ItemStack stack, float x, float y, float xSize, float ySize, float zSize, float xRot, float yRot, float zRot) {
        boolean flag;
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
        CustomItemRenderer customItemRenderer = RenderUtil.getCustomItemRenderer();
        PoseStack poseStack = RenderSystem.getModelViewStack();
        poseStack.m_85836_();
        poseStack.m_252880_(x, y, 100.0f + blitOffset);
        poseStack.m_85837_((double)xSize / 2.0, (double)ySize / 2.0, 0.0);
        poseStack.m_85841_(1.0f, -1.0f, 1.0f);
        poseStack.m_85841_(xSize, ySize, zSize);
        poseStack.m_252781_(Axis.f_252529_.m_252977_(xRot));
        poseStack.m_252781_(Axis.f_252436_.m_252977_(yRot));
        poseStack.m_252781_(Axis.f_252403_.m_252977_(zRot));
        RenderSystem.applyModelViewMatrix();
        PoseStack posestack1 = new PoseStack();
        MultiBufferSource.BufferSource multibuffersource$buffersource = Minecraft.m_91087_().m_91269_().m_110104_();
        boolean bl = flag = !bakedmodel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        customItemRenderer.m_115143_(stack, ItemDisplayContext.GUI, false, posestack1, (MultiBufferSource)multibuffersource$buffersource, 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        RenderSystem.disableDepthTest();
        multibuffersource$buffersource.m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
    }

    public static void renderFloatingItemModelIntoGUI(GuiGraphics gui, ItemStack stack, float x, float y, float ticks, float ticksUp) {
        boolean flag;
        Minecraft minecraft = Minecraft.m_91087_();
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_174264_(stack, (Level)minecraft.f_91073_, (LivingEntity)minecraft.f_91074_, 0);
        CustomItemRenderer customItemRenderer = RenderUtil.getCustomItemRenderer();
        float old = bakedmodel.m_7442_().f_111792_.f_111755_.y;
        PoseStack poseStack = gui.m_280168_();
        poseStack.m_85836_();
        poseStack.m_252880_(x + 8.0f, y + 8.0f, 100.0f + (blitOffset += 50.0f));
        poseStack.m_252931_(new Matrix4f().scaling(1.0f, -1.0f, 1.0f));
        poseStack.m_85841_(16.0f, 16.0f, 16.0f);
        poseStack.m_85837_(0.0, Math.sin(Math.toRadians(ticksUp)) * 0.03125, 0.0);
        if (bakedmodel.m_7547_()) {
            bakedmodel.m_7442_().f_111792_.f_111755_.y = ticks;
        } else {
            poseStack.m_252781_(Axis.f_252436_.m_252977_(ticks));
        }
        boolean bl = flag = !bakedmodel.m_7547_();
        if (flag) {
            Lighting.m_84930_();
        }
        customItemRenderer.renderItem(stack, ItemDisplayContext.GUI, false, poseStack, (MultiBufferSource)Minecraft.m_91087_().m_91269_().m_110104_(), 0xF000F0, OverlayTexture.f_118083_, bakedmodel);
        RenderSystem.disableDepthTest();
        Minecraft.m_91087_().m_91269_().m_110104_().m_109911_();
        RenderSystem.enableDepthTest();
        if (flag) {
            Lighting.m_84931_();
        }
        poseStack.m_85849_();
        RenderSystem.applyModelViewMatrix();
        bakedmodel.m_7442_().f_111792_.f_111755_.y = old;
        blitOffset -= 50.0f;
    }

    public static void renderCustomModel(ModelResourceLocation model, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BakedModel bakedmodel = Minecraft.m_91087_().m_91291_().m_115103_().m_109393_().m_119422_(model);
        Minecraft.m_91087_().m_91291_().m_115143_(new ItemStack((ItemLike)Items.f_42329_), displayContext, leftHand, poseStack, buffer, combinedLight, combinedOverlay, bakedmodel);
    }

    public static void renderBlockModel(ModelResourceLocation model, ItemDisplayContext displayContext, boolean leftHand, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        BakedModel bakedmodel = Minecraft.m_91087_().m_91304_().m_119422_(model);
        Minecraft.m_91087_().m_91291_().m_115143_(new ItemStack((ItemLike)Items.f_42329_), displayContext, leftHand, poseStack, buffer, combinedLight, combinedOverlay, bakedmodel);
    }

    public static TextureAtlasSprite getSprite(ResourceLocation resourceLocation) {
        return (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(resourceLocation);
    }

    public static TextureAtlasSprite getSprite(String modId, String sprite) {
        return RenderUtil.getSprite(new ResourceLocation(modId, sprite));
    }

    public static void renderFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, boolean flowing, int light) {
        RenderUtil.renderFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, flowing, light);
    }

    public static void renderFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, Color color, boolean flowing, int light) {
        RenderUtil.renderFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, color, flowing, light);
    }

    public static void renderFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, boolean flowing, int light) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = RenderUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.renderCube(stack, width, height, length);
        }
    }

    public static void renderFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, Color color, boolean flowing, int light) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = RenderUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.setColor(color).renderCube(stack, width, height, length);
        }
    }

    public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, boolean flowing, int light) {
        RenderUtil.renderCenteredFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, flowing, light);
    }

    public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, Color color, boolean flowing, int light) {
        RenderUtil.renderCenteredFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, color, flowing, light);
    }

    public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, boolean flowing, int light) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = RenderUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.renderCenteredCube(stack, width, height, length);
        }
    }

    public static void renderCenteredFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, Color color, boolean flowing, int light) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = RenderUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.setColor(color).renderCenteredCube(stack, width, height, length);
        }
    }

    public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, boolean flowing, int light, float strength, float time) {
        RenderUtil.renderWavyFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, flowing, light, strength, time);
    }

    public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float size, float texSize, Color color, boolean flowing, int light, float strength, float time) {
        RenderUtil.renderWavyFluid(stack, fluidStack, size, size, size, texSize, texSize, texSize, color, flowing, light, strength, time);
    }

    public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, boolean flowing, int light, float strength, float time) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = RenderUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.renderWavyCube(stack, width, height, length, strength, time);
        }
    }

    public static void renderWavyFluid(PoseStack stack, FluidStack fluidStack, float width, float height, float length, float texWidth, float texHeight, float texLength, Color color, boolean flowing, int light, float strength, float time) {
        if (!fluidStack.isEmpty()) {
            RenderBuilder builder = RenderUtil.getFluidRenderBuilder(fluidStack, texWidth, texHeight, texLength, flowing, light);
            builder.setColor(color).renderWavyCube(stack, width, height, length, strength, time);
        }
    }

    public static RenderBuilder getFluidRenderBuilder(FluidStack fluidStack, float texWidth, float texHeight, float texLength, boolean flowing, int light) {
        RenderBuilder builder = RenderBuilder.create().setRenderType(FluffyFurRenderTypes.TRANSLUCENT_TEXTURE);
        if (!fluidStack.isEmpty()) {
            FluidType type = fluidStack.getFluid().getFluidType();
            IClientFluidTypeExtensions clientType = IClientFluidTypeExtensions.of((FluidType)type);
            TextureAtlasSprite sprite = RenderUtil.getSprite(clientType.getStillTexture(fluidStack));
            if (flowing) {
                sprite = RenderUtil.getSprite(clientType.getFlowingTexture(fluidStack));
            }
            builder.setFirstUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * texLength, sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * texWidth).setSecondUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * texWidth, sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * texHeight).setThirdUV(sprite.m_118409_(), sprite.m_118411_(), sprite.m_118409_() + (sprite.m_118410_() - sprite.m_118409_()) * texLength, sprite.m_118411_() + (sprite.m_118412_() - sprite.m_118411_()) * texHeight).setColor(ColorHelper.getColor(clientType.getTintColor(fluidStack))).setLight(Math.max(type.getLightLevel(fluidStack) << 4, light));
        }
        return builder;
    }

    public static void renderConnectLine(PoseStack stack, Vec3 from, Vec3 to, Color color, float alpha) {
        double dX = to.m_7096_() - from.m_7096_();
        double dY = to.m_7098_() - from.m_7098_();
        double dZ = to.m_7094_() - from.m_7094_();
        double yaw = Math.atan2(dZ, dX);
        double pitch = Math.atan2(Math.sqrt(dZ * dZ + dX * dX), dY) + Math.PI;
        stack.m_85836_();
        stack.m_252781_(Axis.f_252436_.m_252977_((float)Math.toDegrees(-yaw)));
        stack.m_252781_(Axis.f_252403_.m_252977_((float)Math.toDegrees(-pitch) - 180.0f));
        RenderBuilder.create().setRenderType(FluffyFurRenderTypes.ADDITIVE).setColor(color).setAlpha(alpha).renderRay(stack, 0.01f, (float)from.m_82554_(to) + 0.01f);
        stack.m_85849_();
    }

    public static void renderConnectLine(PoseStack stack, BlockPos posFrom, BlockPos posTo, Color color, float alpha) {
        RenderUtil.renderConnectLine(stack, posFrom.m_252807_(), posTo.m_252807_(), color, alpha);
    }

    public static void renderConnectLineOffset(PoseStack stack, Vec3 from, Vec3 to, Color color, float alpha) {
        stack.m_85836_();
        stack.m_85837_(from.m_7096_(), from.m_7098_(), from.m_7094_());
        RenderUtil.renderConnectLine(stack, from, to, color, alpha);
        stack.m_85849_();
    }

    public static void renderConnectBoxLines(PoseStack stack, Vec3 size, Color color, float alpha) {
        RenderUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, 0.0), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, size.m_7094_()), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, size.m_7094_()), new Vec3(0.0, 0.0, size.m_7094_()), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, size.m_7094_()), new Vec3(0.0, 0.0, 0.0), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, 0.0), new Vec3(0.0, size.m_7098_(), 0.0), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, 0.0), new Vec3(size.m_7096_(), size.m_7098_(), 0.0), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, size.m_7094_()), new Vec3(size.m_7096_(), size.m_7098_(), size.m_7094_()), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, size.m_7094_()), new Vec3(0.0, size.m_7098_(), size.m_7094_()), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(0.0, size.m_7098_(), 0.0), new Vec3(size.m_7096_(), size.m_7098_(), 0.0), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), size.m_7098_(), 0.0), new Vec3(size.m_7096_(), size.m_7098_(), size.m_7094_()), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), size.m_7098_(), size.m_7094_()), new Vec3(0.0, size.m_7098_(), size.m_7094_()), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(0.0, size.m_7098_(), size.m_7094_()), new Vec3(0.0, size.m_7098_(), 0.0), color, alpha);
        stack.m_85836_();
        stack.m_252880_(0.01f, 0.01f, 0.01f);
        RenderBuilder.create().setRenderType(FluffyFurRenderTypes.ADDITIVE).setColor(color).setAlpha(alpha / 8.0f).enableSided().renderCube(stack, (float)size.m_7096_() - 0.02f, (float)size.m_7098_() - 0.02f, (float)size.m_7094_() - 0.02f);
        stack.m_85849_();
    }

    public static void renderConnectSideLines(PoseStack stack, Vec3 size, Color color, float alpha) {
        RenderUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, 0.0), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, 0.0), new Vec3(size.m_7096_(), 0.0, size.m_7094_()), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(size.m_7096_(), 0.0, size.m_7094_()), new Vec3(0.0, 0.0, size.m_7094_()), color, alpha);
        RenderUtil.renderConnectLineOffset(stack, new Vec3(0.0, 0.0, size.m_7094_()), new Vec3(0.0, 0.0, 0.0), color, alpha);
        stack.m_85836_();
        stack.m_252781_(Axis.f_252529_.m_252977_(90.0f));
        RenderBuilder.create().setRenderType(FluffyFurRenderTypes.ADDITIVE).setColor(color).setAlpha(alpha / 8.0f).enableSided().renderQuad(stack, (float)size.m_7096_(), (float)size.m_7098_());
        stack.m_85849_();
    }

    public static void renderConnectSide(PoseStack stack, Direction side, Color color, float alpha) {
        Vec3 size = new Vec3(1.0, 1.0, 1.0);
        stack.m_85836_();
        stack.m_252880_(0.5f, 0.5f, 0.5f);
        stack.m_252781_(side.m_122424_().m_253075_());
        stack.m_252880_(0.0f, -0.001f, 0.0f);
        stack.m_85837_(-size.m_7096_() / 2.0, -size.m_7098_() / 2.0, -size.m_7094_() / 2.0);
        RenderUtil.renderConnectSideLines(stack, size, color, alpha);
        stack.m_85849_();
    }

    public static boolean boykisserPos(float x, float y, float lineSize, float smallLineSize, float eyebrowsLineSize, float mouthLineSize, float blushLineSize) {
        if (RenderUtil.boykisserBodyPos(x, y, lineSize, smallLineSize)) {
            return true;
        }
        if (RenderUtil.boykisserFacePos(x, y, eyebrowsLineSize, mouthLineSize)) {
            return true;
        }
        return RenderUtil.boykisserBlushPos(x, y, blushLineSize);
    }

    public static boolean boykisserBlushlessPos(float x, float y, float lineSize, float smallLineSize, float eyebrowsLineSize, float mouthLineSize) {
        if (RenderUtil.boykisserBodyPos(x, y, lineSize, smallLineSize)) {
            return true;
        }
        return RenderUtil.boykisserFacePos(x, y, eyebrowsLineSize, mouthLineSize);
    }

    public static boolean boykisserBodyPos(float x, float y, float l, float sl) {
        float c = 25.0f;
        float X = (x - 0.5f) * c;
        float Y = (y - 0.5f) * c;
        if (RenderUtil.isFormulaLine(Math.pow(X - 2.1f, 2.0) + Math.pow(Y - 6.3f, 2.0), Math.pow(11.0, 2.0), Y < 10.8f && Y > 1.1f && X < 0.0f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(X + 2.1f, 2.0) + Math.pow(Y - 6.3f, 2.0), Math.pow(11.0, 2.0), Y < 10.8f && Y > 0.7f && X > 0.0f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(X + 12.0f, 2.0) + Math.pow(Y - 0.6f, 2.0), Math.pow(11.0, 2.0), Y < 10.8f && Y > 7.3f && X > -10.0f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(X - 12.0f, 2.0) + Math.pow(Y - 0.6f, 2.0), Math.pow(11.0, 2.0), Y < 10.8f && Y > 6.0f && X < 10.0f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(1.2f * X + 1.8f, 2.0) + Math.pow(Y - 0.5f, 2.0), Math.pow(7.0, 2.0), X > -3.6f && X < 2.5f && Y > 2.0f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(X + 3.8f, 2.0) + Math.pow(0.9f * Y - 5.7f, 2.0), 0.5, X > -3.6f && Y > 6.0f, sl)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(1.2f * X + 3.0f, 2.0) + Math.pow(Y + 2.0f, 2.0), Math.pow(8.0, 2.0), X > -3.8f && X < 0.0f && Y > 2.0f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(X + 10.0f, 2.0) + Math.pow(Y + 4.5f, 2.0), Math.pow(12.0, 2.0), X > -3.8f && Y > 4.0f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine((double)(0.6f * X) + 5.6, Y, X > -11.0f && X < -7.6f, sl)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(X + 4.2f, 2.0) + Math.pow(Y - 7.5f, 2.0), Math.pow(11.0, 2.0), Y < -1.1f && X < -8.5f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(2.5f * X + 18.5f, Y, Y > -5.0f && Y < -1.5f, sl)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(X + 10.0f, 2.0) + Math.pow(Y - 7.0f, 2.0), Math.pow(12.0, 2.0), X < -5.8f && X > -9.4f && Y < 0.0f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(-0.25f * X + 2.5f, Y, X > 7.4f && X < 10.85f, sl)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(X - 2.6f, 2.0) + Math.pow(Y - 5.4f, 2.0), Math.pow(10.0, 2.0), Y < -0.24f && X > 8.8f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(-1.2f * X + 8.1f, Y, Y < -1.45f && Y > -4.0f, sl)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(Math.pow(1.6f * X - 12.0f, 2.0) + Math.pow(1.4f * Y - 3.5f, 2.0), Math.pow(10.0, 2.0), X < 10.0f && X > 5.8f && Y < 0.0f, l)) {
            return true;
        }
        return RenderUtil.isFormulaLine(Math.pow(X, 2.0) + Math.pow(3.5f * Y + 13.2f, 2.0), Math.pow(6.0, 2.0), Y < -4.3f, l);
    }

    public static boolean boykisserEyesPos(float x, float y) {
        float c = 25.0f;
        float X = (x - 0.5f) * c;
        float Y = (y - 0.5f) * c;
        if (Math.pow(1.5f * X + 5.2f, 2.0) + Math.pow(Y + 0.1f, 2.0) < Math.pow(2.0, 2.0)) {
            return true;
        }
        return Math.pow(1.5f * X - 5.0f, 2.0) + Math.pow(Y + 0.1f, 2.0) < Math.pow(2.0, 2.0);
    }

    public static boolean boykisserEyebrowsPos(float x, float y, float l) {
        float c = 25.0f;
        float X = (x - 0.5f) * c;
        float Y = (y - 0.5f) * c;
        if (RenderUtil.isFormulaLine(Math.pow(X + 3.8f, 2.0) + Math.pow(0.7f * Y + 0.1f, 2.0), 4.0, Y > -0.5f, l)) {
            return true;
        }
        return RenderUtil.isFormulaLine(Math.pow(X - 3.7f, 2.0) + Math.pow(0.7f * Y + 0.1f, 2.0), 4.0, Y > -0.5f, l);
    }

    public static boolean boykisserNosePos(float x, float y) {
        float c = 25.0f;
        float l = 3.0f;
        float X = (x - 0.5f) * c;
        float Y = (y - 0.5f) * c;
        return Math.pow(1.3f * X + 0.1f, 2.0) + Math.pow(2.3f * Y + 4.5f, 2.0) < 1.0;
    }

    public static boolean boykisserMouthPos(float x, float y, float l) {
        float c = 25.0f;
        float X = (x - 0.5f) * c;
        float Y = (y - 0.5f) * c;
        if (RenderUtil.isFormulaLine(Math.pow(X - 0.7f, 2.0) + Math.pow(Y + 2.8f, 2.0), 1.0, X > 0.0f && X < 1.5f && Y < -2.5f, l)) {
            return true;
        }
        return RenderUtil.isFormulaLine(Math.pow(X + 0.7f, 2.0) + Math.pow(Y + 2.8f, 2.0), 1.0, X < 0.0f && X > -1.5f && Y < -2.5f, l);
    }

    public static boolean boykisserFacePos(float x, float y, float eyebrowsLineSize, float mouthLineSize) {
        if (RenderUtil.boykisserEyesPos(x, y)) {
            return true;
        }
        if (RenderUtil.boykisserEyebrowsPos(x, y, eyebrowsLineSize)) {
            return true;
        }
        if (RenderUtil.boykisserNosePos(x, y)) {
            return true;
        }
        return RenderUtil.boykisserMouthPos(x, y, mouthLineSize);
    }

    public static boolean boykisserBlushPos(float x, float y, float l) {
        float c = 25.0f;
        float X = (x - 0.5f) * c;
        float Y = (y - 0.5f) * c;
        if (RenderUtil.isFormulaLine(X + 2.6f, Y, Y > -3.5f && Y < -2.8f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(X + 1.6f, Y, Y > -3.3f && Y < -2.8f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(-1.2f * X - 9.3f, Y, Y < -2.8f && Y > -3.3f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(X - 8.6f, Y, Y > -3.5f && Y < -2.8f, l)) {
            return true;
        }
        if (RenderUtil.isFormulaLine(X - 9.7f, Y, Y > -3.3f && Y < -2.8f, l)) {
            return true;
        }
        return RenderUtil.isFormulaLine(-1.2f * X + 4.3f, Y, Y < -2.8f && Y > -3.3f, l);
    }

    public static boolean isFormulaLine(double f, double j, boolean limit, double l) {
        if (limit) {
            return f >= j - l && f <= j + l;
        }
        return false;
    }

    public static Vector3f parametricSphere(float u, float v, float r) {
        return new Vector3f(Mth.m_14089_((float)u) * Mth.m_14031_((float)v) * r, Mth.m_14089_((float)v) * r, Mth.m_14031_((float)u) * Mth.m_14031_((float)v) * r);
    }

    public static Vec2 perpendicularTrailPoints(Vector4f start, Vector4f end, float width) {
        float x = -start.x();
        float y = -start.y();
        if (Math.abs(start.z()) > 0.0f) {
            float ratio = end.z() / start.z();
            x = end.x() + x * ratio;
            y = end.y() + y * ratio;
        } else if (Math.abs(end.z()) <= 0.0f) {
            x += end.x();
            y += end.y();
        }
        if (start.z() > 0.0f) {
            x = -x;
            y = -y;
        }
        if (x * x + y * y > 0.0f) {
            float normalize = width * 0.5f / RenderUtil.distance(x, y);
            x *= normalize;
            y *= normalize;
        }
        return new Vec2(-y, x);
    }

    public static float distance(float ... a) {
        return Mth.m_14116_((float)RenderUtil.distSqr(a));
    }

    public static float distSqr(float ... a) {
        float d = 0.0f;
        for (float f : a) {
            d += f * f;
        }
        return d;
    }

    public static void applyWobble(Vector3f[] offsets, float strength, float gameTime) {
        float offset = 0.0f;
        for (Vector3f vector3f : offsets) {
            double time = (double)(gameTime / 40.0f) % Math.PI * 2.0;
            float sine = Mth.m_14031_((float)((float)(time + (double)offset * Math.PI * 2.0))) * strength;
            vector3f.add(sine, -sine, 0.0f);
            offset += 0.25f;
        }
    }

    static {
        blitOffset = 0.0f;
        FULL_BRIGHT = 0xF000F0;
        FULL_WIDTH_FUNCTION = f -> Float.valueOf(1.0f);
        LINEAR_IN_WIDTH_FUNCTION = f -> f;
        LINEAR_OUT_WIDTH_FUNCTION = f -> Float.valueOf(1.0f - f.floatValue());
        LINEAR_IN_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 1.0f ? 0.0f : f.floatValue());
        LINEAR_OUT_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 0.0f ? 0.0f : 1.0f - f.floatValue());
        LINEAR_IN_SEMI_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 1.0f ? 0.5f : f.floatValue());
        LINEAR_OUT_SEMI_ROUND_WIDTH_FUNCTION = f -> Float.valueOf(f.floatValue() == 0.0f ? 0.5f : 1.0f - f.floatValue());
    }
}

