/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils.random;

import java.util.List;
import java.util.Random;
import java.util.stream.Stream;
import net.minecraft.util.RandomSource;
import ru.blatfan.blatapi.utils.MathUtils;

public class RandomUtils {
    public static Random RANDOM = new Random();

    public static boolean doWithChance(float chance) {
        return RandomUtils.doWithChance(RANDOM, chance);
    }

    public static double random() {
        return Math.random();
    }

    public static int randomSign() {
        return RandomUtils.randomElement(-1, 1);
    }

    public static int randomInt(int min, int from, int to) {
        int res = RandomUtils.randomInt(from, to);
        return (int)MathUtils.clamp(res, -min, min);
    }

    public static float randomFloat(float min, float from, float to) {
        float res = RandomUtils.randomFloat(from, to);
        return MathUtils.clamp(res, -min, min);
    }

    public static int randomInt(int border) {
        return RandomUtils.randomInt(RANDOM, border);
    }

    public static int randomInt(int min, int max) {
        return RandomUtils.randomInt(RANDOM, min, max);
    }

    public static float randomFloat(float min, float max) {
        return RandomUtils.randomFloat(RANDOM, min, max);
    }

    public static boolean doWithChance(Random random, float chance) {
        double num = random.nextDouble() * 100.0;
        return num <= (double)chance;
    }

    public static int randomInt(Random random, int border) {
        return random.nextInt(border);
    }

    public static int randomInt(Random random, int min, int max) {
        return random.nextInt(max - min) + min;
    }

    public static float randomFloat(Random random, float min, float max) {
        return min + random.nextFloat() * (max - min);
    }

    public static boolean doWithChance(RandomSource random, float chance) {
        double num = random.m_188500_() * 100.0;
        return num <= (double)chance;
    }

    public static long randomLong() {
        return RANDOM.nextLong();
    }

    public static int randomInt(RandomSource random, int border) {
        return random.m_188503_(border);
    }

    public static int randomInt(RandomSource random, int min, int max) {
        return random.m_188503_(max - min) + min;
    }

    public static float randomFloat(RandomSource random, float min, float max) {
        return min + random.m_188501_() * (max - min);
    }

    public static <T> T randomElement(RandomSource random, T ... array) {
        return array[RandomUtils.randomInt(random, array.length)];
    }

    public static <T> T randomElement(RandomSource random, List<T> list) {
        return list.get(RandomUtils.randomInt(random, list.size()));
    }

    public static <T> T randomElement(RandomSource random, Stream<T> stream) {
        return RandomUtils.randomElement(random, stream.toList());
    }

    public static <T> T randomElement(Random random, T ... array) {
        return array[RandomUtils.randomInt(random, array.length)];
    }

    public static <T> T randomElement(Random random, List<T> list) {
        return list.get(RandomUtils.randomInt(random, list.size()));
    }

    public static <T> T randomElement(Random random, Stream<T> stream) {
        return RandomUtils.randomElement(random, stream.toList());
    }

    public static <T> T randomElement(T ... array) {
        return array[RandomUtils.randomInt(RANDOM, array.length)];
    }

    public static <T> T randomElement(List<T> list) {
        return list.get(RandomUtils.randomInt(RANDOM, list.size()));
    }

    public static <T> T randomElement(Stream<T> stream) {
        return RandomUtils.randomElement(RANDOM, stream.toList());
    }
}

