/*
 * Decompiled with CFR 0.152.
 */
package ru.blatfan.blatapi.utils.random;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import ru.blatfan.blatapi.utils.collection.Couple;
import ru.blatfan.blatapi.utils.random.IRandomImplifications;

public class WeightedRandom<T> {
    private final List<Couple<Double, T>> table = new ArrayList<Couple<Double, T>>();
    private final Random random;
    private double totalWeight;
    private boolean resultCanBeNull = false;

    public WeightedRandom() {
        this.random = new Random();
    }

    public WeightedRandom(Random random) {
        this.random = random;
    }

    public WeightedRandom add(double chance, T element) {
        this.table.add(new Couple<Double, T>(chance, element));
        return this;
    }

    public T getNullElement() {
        return null;
    }

    public WeightedRandom build() {
        if (this.resultCanBeNull) {
            double maxChance = this.maxCommonElement();
            this.add(100.0 - maxChance, this.getNullElement());
        }
        this.calculateTotalWeight();
        return this;
    }

    public void calculateTotalWeight() {
        this.totalWeight = 0.0;
        for (Couple<Double, T> pair : this.table) {
            this.totalWeight += pair.getKey().doubleValue();
        }
    }

    public WeightedRandom canHasNoResult() {
        this.resultCanBeNull = true;
        return this;
    }

    private double maxCommonElement() {
        double maxChance = 0.0;
        for (Couple<Double, T> drop : this.table) {
            if (!(drop.getKey() > maxChance)) continue;
            maxChance = drop.getKey();
        }
        return maxChance;
    }

    public <M extends IRandomImplifications<T>> T random(M m) {
        double num = this.random.nextDouble() * this.totalWeight;
        for (Couple<Double, T> pair : this.table) {
            double chance = pair.getKey();
            if (num <= chance) {
                if (m != null) {
                    m.imply(pair.getValue());
                }
                return pair.getValue();
            }
            num -= pair.getKey().doubleValue();
        }
        return null;
    }

    public <M extends IRandomImplifications<T>> T randomWithRemove(M m) {
        double num = this.random.nextDouble() * this.totalWeight;
        for (Couple<Double, T> pair : this.table) {
            double chance = pair.getKey();
            if (num <= chance) {
                T value = pair.getValue();
                if (m != null) {
                    m.imply(value);
                }
                this.table.remove(pair);
                return value;
            }
            num -= pair.getKey().doubleValue();
        }
        return null;
    }

    public T random() {
        return this.random(null);
    }

    public T randomWithRemove() {
        return this.randomWithRemove(null);
    }

    public List<Couple<Double, T>> getTable() {
        return this.table;
    }
}

