/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.voxelbridge.command.VoxelBridgeCommands;
import com.voxelbridge.export.ExportProgressTracker;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;

@EventBusSubscriber(modid="voxelbridge", value={Dist.CLIENT})
public class SelectionRenderer {
    @SubscribeEvent
    public static void onRenderLevel(RenderLevelStageEvent event) {
        if (event.getStage() != RenderLevelStageEvent.Stage.AFTER_TRANSLUCENT_BLOCKS) {
            return;
        }
        BlockPos pos1 = VoxelBridgeCommands.getPos1();
        BlockPos pos2 = VoxelBridgeCommands.getPos2();
        if (pos1 == null && pos2 == null) {
            return;
        }
        Minecraft mc = Minecraft.getInstance();
        Vec3 camPos = event.getCamera().getPosition();
        PoseStack poseStack = event.getPoseStack();
        MultiBufferSource.BufferSource bufferSource = mc.renderBuffers().bufferSource();
        VertexConsumer consumer = bufferSource.getBuffer(RenderType.lines());
        poseStack.pushPose();
        poseStack.translate(-camPos.x, -camPos.y, -camPos.z);
        if (pos1 != null) {
            SelectionRenderer.renderBox(poseStack, consumer, pos1, 1.0f, 0.2f, 0.2f, 0.6f);
        }
        if (pos2 != null) {
            SelectionRenderer.renderBox(poseStack, consumer, pos2, 0.2f, 0.2f, 1.0f, 0.6f);
        }
        if (pos1 != null && pos2 != null) {
            SelectionRenderer.renderSelectionBox(poseStack, consumer, pos1, pos2, 0.0f, 1.0f, 1.0f, 0.5f);
            SelectionRenderer.renderChunkStatus(poseStack, consumer, pos1, pos2);
            SelectionRenderer.renderProgressLabel(poseStack, mc, pos1, pos2, (MultiBufferSource)bufferSource);
        }
        poseStack.popPose();
        bufferSource.endBatch(RenderType.lines());
        bufferSource.endBatch();
    }

    private static void renderBox(PoseStack poseStack, VertexConsumer consumer, BlockPos pos, float r, float g, float b, float a) {
        AABB box = new AABB(pos).inflate(0.002);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)box, (float)r, (float)g, (float)b, (float)a);
    }

    private static void renderSelectionBox(PoseStack poseStack, VertexConsumer consumer, BlockPos pos1, BlockPos pos2, float r, float g, float b, float a) {
        int minX = Math.min(pos1.getX(), pos2.getX());
        int minY = Math.min(pos1.getY(), pos2.getY());
        int minZ = Math.min(pos1.getZ(), pos2.getZ());
        int maxX = Math.max(pos1.getX(), pos2.getX()) + 1;
        int maxY = Math.max(pos1.getY(), pos2.getY()) + 1;
        int maxZ = Math.max(pos1.getZ(), pos2.getZ()) + 1;
        AABB box = new AABB((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ);
        LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)box, (float)r, (float)g, (float)b, (float)a);
    }

    private static void renderChunkStatus(PoseStack poseStack, VertexConsumer consumer, BlockPos pos1, BlockPos pos2) {
        Map<Long, ExportProgressTracker.ChunkState> states = ExportProgressTracker.snapshot();
        if (states.isEmpty()) {
            return;
        }
        int selMinX = Math.min(pos1.getX(), pos2.getX());
        int selMinY = Math.min(pos1.getY(), pos2.getY());
        int selMinZ = Math.min(pos1.getZ(), pos2.getZ());
        int selMaxX = Math.max(pos1.getX(), pos2.getX()) + 1;
        int selMaxY = Math.max(pos1.getY(), pos2.getY()) + 1;
        int selMaxZ = Math.max(pos1.getZ(), pos2.getZ()) + 1;
        for (Map.Entry<Long, ExportProgressTracker.ChunkState> entry : states.entrySet()) {
            float b;
            float g;
            float r;
            long key = entry.getKey();
            int chunkX = ChunkPos.getX((long)key);
            int chunkZ = ChunkPos.getZ((long)key);
            int minX = chunkX << 4;
            int minZ = chunkZ << 4;
            int maxX = minX + 16;
            int maxZ = minZ + 16;
            int boxMinX = Math.max(minX, selMinX);
            int boxMinY = selMinY;
            int boxMinZ = Math.max(minZ, selMinZ);
            int boxMaxX = Math.min(maxX, selMaxX);
            int boxMaxY = selMaxY;
            int boxMaxZ = Math.min(maxZ, selMaxZ);
            if (boxMinX >= boxMaxX || boxMinY >= boxMaxY || boxMinZ >= boxMaxZ) continue;
            ExportProgressTracker.ChunkState state = entry.getValue();
            if (state == ExportProgressTracker.ChunkState.DONE) {
                r = 0.1f;
                g = 1.0f;
                b = 0.1f;
            } else if (state == ExportProgressTracker.ChunkState.RUNNING) {
                r = 1.0f;
                g = 0.8f;
                b = 0.1f;
            } else {
                r = 1.0f;
                g = 0.2f;
                b = 0.2f;
            }
            AABB chunkBox = new AABB((double)boxMinX, (double)boxMinY, (double)boxMinZ, (double)boxMaxX, (double)boxMaxY, (double)boxMaxZ);
            LevelRenderer.renderLineBox((PoseStack)poseStack, (VertexConsumer)consumer, (AABB)chunkBox, (float)r, (float)g, (float)b, (float)0.35f);
        }
    }

    private static void renderProgressLabel(PoseStack poseStack, Minecraft mc, BlockPos pos1, BlockPos pos2, MultiBufferSource bufferSource) {
        ExportProgressTracker.Progress p = ExportProgressTracker.progress();
        if (p.total() <= 0) {
            return;
        }
        String text = String.format("Export: %d/%d (%.1f%%)", p.done(), p.total(), Float.valueOf(p.percent()));
        double cx = (double)(pos1.getX() + pos2.getX() + 1) * 0.5;
        double cy = (double)(pos1.getY() + pos2.getY() + 1) * 0.5 + 1.5;
        double cz = (double)(pos1.getZ() + pos2.getZ() + 1) * 0.5;
        poseStack.pushPose();
        poseStack.translate(cx, cy, cz);
        poseStack.mulPose(mc.getEntityRenderDispatcher().cameraOrientation());
        poseStack.scale(-0.02f, -0.02f, 0.02f);
        float x = (float)(-mc.font.width(text)) / 2.0f;
        mc.font.drawInBatch(text, x, 0.0f, -1, false, poseStack.last().pose(), bufferSource, Font.DisplayMode.NORMAL, 0, 0xF000F0);
        poseStack.popPose();
    }
}

