/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export;

import com.voxelbridge.export.CoordinateMode;
import java.awt.image.BufferedImage;
import java.nio.file.Path;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.client.Minecraft;
import net.minecraft.client.color.block.BlockColors;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ExportContext {
    private final Minecraft mc;
    private final BlockColors blockColors;
    private final Map<String, TintAtlas> atlasBook = new ConcurrentHashMap<String, TintAtlas>();
    private final Map<String, String> materialNames = new ConcurrentHashMap<String, String>();
    private final Map<String, String> materialPaths = new ConcurrentHashMap<String, String>();
    private final Map<Integer, TexturePlacement> colorMap = new ConcurrentHashMap<Integer, TexturePlacement>();
    private final AtomicInteger nextColorSlot = new AtomicInteger(1);
    private final Set<Long> consumedBlocks = ConcurrentHashMap.newKeySet();
    private final Map<String, EntityTexture> entityTextures = new ConcurrentHashMap<String, EntityTexture>();
    private final Map<String, BufferedImage> generatedEntityTextures = new ConcurrentHashMap<String, BufferedImage>();
    private final Map<String, BlockEntityAtlasPlacement> blockEntityAtlasPlacements = new ConcurrentHashMap<String, BlockEntityAtlasPlacement>();
    private final Map<String, String> overlayMappings = new ConcurrentHashMap<String, String>();
    private boolean blockEntityExportEnabled = true;
    private CoordinateMode coordinateMode = CoordinateMode.CENTERED;

    public ExportContext(Minecraft mc) {
        this.mc = mc;
        this.blockColors = mc.getBlockColors();
    }

    public Minecraft getMc() {
        return this.mc;
    }

    public BlockColors getBlockColors() {
        return this.blockColors;
    }

    public Map<String, TintAtlas> getAtlasBook() {
        return this.atlasBook;
    }

    public Map<String, String> getMaterialNames() {
        return this.materialNames;
    }

    public Map<String, String> getMaterialPaths() {
        return this.materialPaths;
    }

    public Map<Integer, TexturePlacement> getColorMap() {
        return this.colorMap;
    }

    public AtomicInteger getNextColorSlot() {
        return this.nextColorSlot;
    }

    public TintAtlas getOrCreateTintAtlas(String spriteKey) {
        return this.atlasBook.computeIfAbsent(spriteKey, k -> new TintAtlas());
    }

    public String getMaterialNameForSprite(String spriteKey) {
        return this.materialNames.computeIfAbsent(spriteKey, k -> "mat_" + ExportContext.safe(k));
    }

    public boolean isBlockConsumed(BlockPos pos) {
        return this.consumedBlocks.contains(pos.asLong());
    }

    public void markBlockConsumed(BlockPos pos) {
        this.consumedBlocks.add(pos.asLong());
    }

    public void resetConsumedBlocks() {
        this.consumedBlocks.clear();
    }

    public Map<String, EntityTexture> getEntityTextures() {
        return this.entityTextures;
    }

    public Map<String, BlockEntityAtlasPlacement> getBlockEntityAtlasPlacements() {
        return this.blockEntityAtlasPlacements;
    }

    public Map<String, String> getOverlayMappings() {
        return this.overlayMappings;
    }

    public void clearEntityTextures() {
        this.entityTextures.clear();
        this.generatedEntityTextures.clear();
    }

    public Map<String, BufferedImage> getGeneratedEntityTextures() {
        return this.generatedEntityTextures;
    }

    public void registerGeneratedEntityTexture(String key, BufferedImage image) {
        this.generatedEntityTextures.put(key, image);
    }

    public boolean isBlockEntityExportEnabled() {
        return this.blockEntityExportEnabled;
    }

    public void setBlockEntityExportEnabled(boolean enabled) {
        this.blockEntityExportEnabled = enabled;
    }

    public CoordinateMode getCoordinateMode() {
        return this.coordinateMode;
    }

    public void setCoordinateMode(CoordinateMode mode) {
        this.coordinateMode = mode;
    }

    private static String safe(String s) {
        return s.replace(':', '_').replace('/', '_').replace(' ', '_');
    }

    public static final class TintAtlas {
        public final Map<Integer, Integer> tintToIndex = new ConcurrentHashMap<Integer, Integer>();
        public final Map<Integer, Integer> indexToTint = new ConcurrentHashMap<Integer, Integer>();
        public final Map<Integer, TexturePlacement> placements = new ConcurrentHashMap<Integer, TexturePlacement>();
        public final AtomicInteger nextIndex = new AtomicInteger();
        public volatile int cols = 0;
        public volatile Path atlasFile;
        public volatile int texW = 0;
        public volatile int texH = 0;
        public volatile boolean usesAtlas = true;
    }

    public record BlockEntityAtlasPlacement(int page, int udim, int x, int y, int width, int height, int atlasSize) {
        public float u0() {
            int tileU = this.page % 10;
            return (float)tileU + (float)this.x / (float)this.atlasSize;
        }

        public float v0() {
            int tileV = this.page / 10;
            return (float)(-tileV) + (float)this.y / (float)this.atlasSize;
        }

        public float u1() {
            int tileU = this.page % 10;
            return (float)tileU + (float)(this.x + this.width) / (float)this.atlasSize;
        }

        public float v1() {
            int tileV = this.page / 10;
            return (float)(-tileV) + (float)(this.y + this.height) / (float)this.atlasSize;
        }
    }

    public record EntityTexture(ResourceLocation location, int width, int height) {
    }

    public record TexturePlacement(int page, int tileU, int tileV, int x, int y, int w, int h, float u0, float v0, float u1, float v1, String path) {
    }
}

