/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export;

import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.ChunkPos;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ExportProgressTracker {
    private static final Map<Long, ChunkState> chunkStates = new ConcurrentHashMap<Long, ChunkState>();
    private static final AtomicInteger completed = new AtomicInteger();
    private static final AtomicInteger failed = new AtomicInteger();
    private static final AtomicInteger retrying = new AtomicInteger();
    private static volatile int total = 0;

    private ExportProgressTracker() {
    }

    public static void clear() {
        chunkStates.clear();
        completed.set(0);
        failed.set(0);
        retrying.set(0);
        total = 0;
    }

    public static void previewSelection(BlockPos pos1, BlockPos pos2) {
        ExportProgressTracker.clear();
        if (pos1 == null || pos2 == null) {
            return;
        }
        int minChunkX = Math.min(pos1.getX(), pos2.getX()) >> 4;
        int maxChunkX = Math.max(pos1.getX(), pos2.getX()) >> 4;
        int minChunkZ = Math.min(pos1.getZ(), pos2.getZ()) >> 4;
        int maxChunkZ = Math.max(pos1.getZ(), pos2.getZ()) >> 4;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                chunkStates.put(ChunkPos.asLong((int)cx, (int)cz), ChunkState.PENDING);
            }
        }
        total = chunkStates.size();
    }

    public static void initForExport(Set<Long> chunkKeys) {
        chunkStates.clear();
        completed.set(0);
        failed.set(0);
        retrying.set(0);
        for (Long key : chunkKeys) {
            chunkStates.put(key, ChunkState.PENDING);
        }
        total = chunkStates.size();
    }

    public static void markRunning(int cx, int cz) {
        long key = ChunkPos.asLong((int)cx, (int)cz);
        chunkStates.putIfAbsent(key, ChunkState.PENDING);
        chunkStates.replace(key, ChunkState.RUNNING);
    }

    public static void markDone(int cx, int cz) {
        long key = ChunkPos.asLong((int)cx, (int)cz);
        ChunkState prev = chunkStates.getOrDefault(key, ChunkState.PENDING);
        if (prev == ChunkState.DONE) {
            return;
        }
        chunkStates.put(key, ChunkState.DONE);
        if (prev == ChunkState.RETRY) {
            retrying.decrementAndGet();
        } else if (prev == ChunkState.FAILED) {
            failed.decrementAndGet();
        }
        completed.incrementAndGet();
    }

    public static void markFailed(int cx, int cz) {
        long key = ChunkPos.asLong((int)cx, (int)cz);
        ChunkState prev = chunkStates.getOrDefault(key, ChunkState.PENDING);
        if (prev == ChunkState.FAILED) {
            return;
        }
        chunkStates.put(key, ChunkState.FAILED);
        if (prev == ChunkState.RETRY) {
            retrying.decrementAndGet();
        } else if (prev == ChunkState.DONE) {
            completed.decrementAndGet();
        }
        failed.incrementAndGet();
    }

    public static void markRetry(int cx, int cz) {
        long key = ChunkPos.asLong((int)cx, (int)cz);
        ChunkState prev = chunkStates.getOrDefault(key, ChunkState.PENDING);
        if (prev == ChunkState.RETRY) {
            return;
        }
        chunkStates.put(key, ChunkState.RETRY);
        if (prev == ChunkState.DONE) {
            completed.decrementAndGet();
        } else if (prev == ChunkState.FAILED) {
            failed.decrementAndGet();
        }
        retrying.incrementAndGet();
    }

    public static void markPending(int cx, int cz) {
        long key = ChunkPos.asLong((int)cx, (int)cz);
        ChunkState prev = chunkStates.getOrDefault(key, ChunkState.PENDING);
        if (prev == ChunkState.PENDING) {
            return;
        }
        chunkStates.put(key, ChunkState.PENDING);
        if (prev == ChunkState.DONE) {
            completed.decrementAndGet();
        } else if (prev == ChunkState.FAILED) {
            failed.decrementAndGet();
        } else if (prev == ChunkState.RETRY) {
            retrying.decrementAndGet();
        }
    }

    public static Set<ChunkPos> getPendingChunks() {
        return chunkStates.entrySet().stream().filter(e -> e.getValue() == ChunkState.PENDING).map(e -> new ChunkPos(((Long)e.getKey()).longValue())).collect(Collectors.toSet());
    }

    public static Set<ChunkPos> getRetryChunks() {
        return chunkStates.entrySet().stream().filter(e -> e.getValue() == ChunkState.RETRY).map(e -> new ChunkPos(((Long)e.getKey()).longValue())).collect(Collectors.toSet());
    }

    public static Map<Long, ChunkState> snapshot() {
        return Collections.unmodifiableMap(chunkStates);
    }

    public static Progress progress() {
        return new Progress(completed.get(), failed.get(), retrying.get(), total);
    }

    public static enum ChunkState {
        PENDING,
        RUNNING,
        DONE,
        FAILED,
        RETRY;

    }

    public record Progress(int done, int failed, int retrying, int total) {
        public float percent() {
            return this.total == 0 ? 0.0f : (float)this.done * 100.0f / (float)this.total;
        }

        public int pending() {
            return this.total - this.done - this.failed - this.retrying;
        }

        public boolean isComplete() {
            return this.done + this.failed == this.total;
        }
    }
}

