/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export;

import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.scene.gltf.GltfExportService;
import com.voxelbridge.util.ExportLogger;
import java.io.IOException;
import java.nio.file.Path;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.chunk.LevelChunk;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class ExportService {
    private ExportService() {
    }

    public static Path exportRegion(Level level, BlockPos pos1, BlockPos pos2, Path outDir) throws IOException {
        return GltfExportService.exportRegion(level, pos1, pos2, outDir);
    }

    public static void collectTintVariants(Level level, BlockPos pos1, BlockPos pos2, ExportContext ctx) throws IOException {
        if (!(level instanceof ClientLevel)) {
            throw new IllegalStateException("[VoxelBridge] Must run on client side!");
        }
        ClientLevel clientLevel = (ClientLevel)level;
        ClientChunkCache chunkCache = clientLevel.getChunkSource();
        int minX = Math.min(pos1.getX(), pos2.getX());
        int minY = Math.min(pos1.getY(), pos2.getY());
        int minZ = Math.min(pos1.getZ(), pos2.getZ());
        int maxX = Math.max(pos1.getX(), pos2.getX());
        int maxY = Math.max(pos1.getY(), pos2.getY());
        int maxZ = Math.max(pos1.getZ(), pos2.getZ());
        int minChunkX = minX >> 4;
        int maxChunkX = maxX >> 4;
        int minChunkZ = minZ >> 4;
        int maxChunkZ = maxZ >> 4;
        System.out.println("[VoxelBridge] Pre-scanning region for tint variants...");
        ExportLogger.log("Pre-scanning region for tint variants...");
        int scanned = 0;
        for (int cx = minChunkX; cx <= maxChunkX; ++cx) {
            for (int cz = minChunkZ; cz <= maxChunkZ; ++cz) {
                LevelChunk chunk = chunkCache.getChunk(cx, cz, false);
                if (chunk == null || chunk.isEmpty()) {
                    System.err.printf("[VoxelBridge][WARN] Chunk (%d,%d) unavailable during tint scan%n", cx, cz);
                    continue;
                }
                ++scanned;
            }
        }
        ctx.resetConsumedBlocks();
        ExportLogger.log("Tint scan complete - scanned " + scanned + " chunks");
        System.out.println("[VoxelBridge] Tint scan complete");
    }
}

