/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter;

import com.voxelbridge.export.CoordinateMode;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.exporter.FluidExporter;
import com.voxelbridge.export.exporter.blockentity.BlockEntityExportResult;
import com.voxelbridge.export.exporter.blockentity.BlockEntityExporter;
import com.voxelbridge.export.scene.SceneSink;
import com.voxelbridge.export.texture.ColorMapManager;
import com.voxelbridge.export.texture.SpriteKeyResolver;
import com.voxelbridge.export.texture.TextureAtlasManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelManager;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.model.data.ModelData;

public final class BlockExporter {
    private final ExportContext ctx;
    private final SceneSink sceneSink;
    private final Level level;
    private final ClientChunkCache chunkCache;
    private BlockPos regionMin;
    private BlockPos regionMax;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double offsetZ = 0.0;
    private final Map<Long, OverlayQuadData> overlayCache = new HashMap<Long, OverlayQuadData>();
    private final Map<BlockPos, OverlayQuadData> overlayBlockPosCache = new HashMap<BlockPos, OverlayQuadData>();
    private volatile boolean missingNeighborDetected = false;

    public BlockExporter(ExportContext ctx, SceneSink sceneSink, Level level) {
        ClientChunkCache clientChunkCache;
        this.ctx = ctx;
        this.sceneSink = sceneSink;
        this.level = level;
        if (level instanceof ClientLevel) {
            ClientLevel cl = (ClientLevel)level;
            clientChunkCache = cl.getChunkSource();
        } else {
            clientChunkCache = null;
        }
        this.chunkCache = clientChunkCache;
    }

    public void setRegionBounds(BlockPos min, BlockPos max) {
        this.regionMin = min;
        this.regionMax = max;
        if (this.ctx.getCoordinateMode() == CoordinateMode.CENTERED) {
            this.offsetX = (double)(-(min.getX() + max.getX())) / 2.0;
            this.offsetY = (double)(-(min.getY() + max.getY())) / 2.0;
            this.offsetZ = (double)(-(min.getZ() + max.getZ())) / 2.0;
        } else {
            this.offsetX = 0.0;
            this.offsetY = 0.0;
            this.offsetZ = 0.0;
        }
    }

    public void sampleBlock(BlockState state, BlockPos pos) {
        List<BakedQuad> quads;
        boolean isTransparent;
        BlockEntityExportResult beResult;
        BlockEntity be;
        if (!this.isNeighborChunksLoadedForBlock(pos)) {
            this.missingNeighborDetected = true;
            return;
        }
        this.overlayCache.clear();
        if (state.isAir()) {
            return;
        }
        FluidState fluidState = state.getFluidState();
        if (fluidState != null && !fluidState.isEmpty()) {
            FluidExporter.sample(this.ctx, this.sceneSink, this.level, state, pos, fluidState, this.offsetX, this.offsetY, this.offsetZ, this.regionMin, this.regionMax);
        }
        if ((be = this.level.getBlockEntity(pos)) != null && this.ctx.isBlockEntityExportEnabled() && (beResult = BlockEntityExporter.export(this.ctx, this.level, state, be, pos, this.sceneSink, this.offsetX, this.offsetY, this.offsetZ)).replaceBlockModel()) {
            return;
        }
        RenderShape shape = state.getRenderShape();
        if (shape == RenderShape.INVISIBLE) {
            return;
        }
        BakedModel model = this.getModel(state);
        if (model == null) {
            return;
        }
        boolean bl = isTransparent = !state.isSolidRender((BlockGetter)this.level, pos);
        if (!isTransparent && this.isFullyOccluded(pos)) {
            return;
        }
        ModelData modelData = ModelData.EMPTY;
        if (be != null) {
            try {
                modelData = be.getModelData();
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if ((quads = this.getQuads(model, state, modelData, pos)).isEmpty()) {
            return;
        }
        for (BakedQuad quad : quads) {
            String spriteKey;
            TextureAtlasSprite sprite;
            if (quad == null || (sprite = quad.getSprite()) == null || !(spriteKey = SpriteKeyResolver.resolve(sprite)).contains("_overlay")) continue;
            this.cacheOverlayQuad(state, pos, quad);
        }
        HashSet<Long> quadKeys = new HashSet<Long>();
        for (BakedQuad quad : quads) {
            Direction dir;
            if (quad == null || !isTransparent && (dir = quad.getDirection()) != null && this.isFaceOccluded(pos, dir)) continue;
            this.processQuad(state, pos, quad, quadKeys);
        }
    }

    private void cacheOverlayQuad(BlockState state, BlockPos pos, BakedQuad quad) {
        int[] verts;
        TextureAtlasSprite sprite = quad.getSprite();
        if (sprite == null) {
            return;
        }
        String spriteKey = SpriteKeyResolver.resolve(sprite);
        float[] positions = new float[12];
        float[] uv0 = new float[8];
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        float du = u1 - u0;
        float dv = v1 - v0;
        if (du == 0.0f) {
            du = 1.0f;
        }
        if (dv == 0.0f) {
            dv = 1.0f;
        }
        try {
            verts = quad.getVertices();
        }
        catch (Throwable t) {
            return;
        }
        if (verts.length < 32) {
            return;
        }
        int stride = 8;
        int[] vertexColors = new int[4];
        for (int i = 0; i < 4; ++i) {
            int base = i * 8;
            float vx = Float.intBitsToFloat(verts[base]);
            float vy = Float.intBitsToFloat(verts[base + 1]);
            float vz = Float.intBitsToFloat(verts[base + 2]);
            int abgr = verts[base + 3];
            float uu = Float.intBitsToFloat(verts[base + 4]);
            float vv = Float.intBitsToFloat(verts[base + 5]);
            vertexColors[i] = abgr;
            positions[i * 3] = (float)((double)((float)pos.getX() + vx) + this.offsetX);
            positions[i * 3 + 1] = (float)((double)((float)pos.getY() + vy) + this.offsetY);
            positions[i * 3 + 2] = (float)((double)((float)pos.getZ() + vz) + this.offsetZ);
            float su = (uu - u0) / du;
            float sv = (vv - v0) / dv;
            su = this.clamp01(su - (float)Math.floor(su));
            sv = this.clamp01(sv - (float)Math.floor(sv));
            uv0[i * 2] = su;
            uv0[i * 2 + 1] = sv;
        }
        int overlayColor = this.extractOverlayColor(state, pos, quad, vertexColors);
        float[] overlayColorUv = new float[8];
        ExportContext.TexturePlacement placement = ColorMapManager.registerColor(this.ctx, overlayColor);
        overlayColorUv[0] = placement.u0();
        overlayColorUv[1] = placement.v0();
        overlayColorUv[2] = placement.u1();
        overlayColorUv[3] = placement.v0();
        overlayColorUv[4] = placement.u1();
        overlayColorUv[5] = placement.v1();
        overlayColorUv[6] = placement.u0();
        overlayColorUv[7] = placement.v1();
        long posHash = this.computePositionHash(positions);
        OverlayQuadData data = new OverlayQuadData((float[])uv0.clone(), overlayColorUv, spriteKey, overlayColor);
        this.overlayCache.put(posHash, data);
        this.overlayBlockPosCache.put(pos.immutable(), data);
    }

    private void processQuad(BlockState state, BlockPos pos, BakedQuad quad, Set<Long> quadKeys) {
        int[] verts;
        TextureAtlasSprite sprite = quad.getSprite();
        if (sprite == null) {
            return;
        }
        String spriteKey = SpriteKeyResolver.resolve(sprite);
        float[] positions = new float[12];
        float[] uv0 = new float[8];
        boolean doubleSided = state.getBlock() instanceof BushBlock;
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        float du = u1 - u0;
        float dv = v1 - v0;
        if (du == 0.0f) {
            du = 1.0f;
        }
        if (dv == 0.0f) {
            dv = 1.0f;
        }
        try {
            verts = quad.getVertices();
        }
        catch (Throwable t) {
            return;
        }
        if (verts.length < 32) {
            return;
        }
        int stride = 8;
        for (int i = 0; i < 4; ++i) {
            int base = i * 8;
            float vx = Float.intBitsToFloat(verts[base]);
            float vy = Float.intBitsToFloat(verts[base + 1]);
            float vz = Float.intBitsToFloat(verts[base + 2]);
            float uu = Float.intBitsToFloat(verts[base + 4]);
            float vv = Float.intBitsToFloat(verts[base + 5]);
            positions[i * 3] = (float)((double)((float)pos.getX() + vx) + this.offsetX);
            positions[i * 3 + 1] = (float)((double)((float)pos.getY() + vy) + this.offsetY);
            positions[i * 3 + 2] = (float)((double)((float)pos.getZ() + vz) + this.offsetZ);
            float su = (uu - u0) / du;
            float sv = (vv - v0) / dv;
            su = this.clamp01(su - (float)Math.floor(su));
            sv = this.clamp01(sv - (float)Math.floor(sv));
            uv0[i * 2] = su;
            uv0[i * 2 + 1] = sv;
        }
        float[] faceNormal = this.computeFaceNormal(positions);
        long quadKey = this.computeQuadKey(spriteKey, positions, faceNormal, doubleSided);
        if (!quadKeys.add(quadKey)) {
            return;
        }
        boolean isOverlay = spriteKey.contains("_overlay");
        int argb = this.computeTintColor(state, pos, quad);
        float[] uv1 = new float[8];
        ExportContext.TexturePlacement placement = ColorMapManager.registerColor(this.ctx, argb);
        uv1[0] = placement.u0();
        uv1[1] = placement.v0();
        uv1[2] = placement.u1();
        uv1[3] = placement.v0();
        uv1[4] = placement.u1();
        uv1[5] = placement.v1();
        uv1[6] = placement.u0();
        uv1[7] = placement.v1();
        float[] colors = this.whiteColor();
        float[] uv2 = null;
        float[] uv3 = null;
        if (!isOverlay) {
            long posHash = this.computePositionHash(positions);
            OverlayQuadData overlayData = this.overlayCache.get(posHash);
            if (overlayData == null) {
                overlayData = this.overlayBlockPosCache.get(pos);
            }
            if (overlayData != null) {
                uv2 = overlayData.uv;
                uv3 = overlayData.colorUv;
                TextureAtlasManager.registerTint(this.ctx, overlayData.spriteKey, 0xFFFFFF);
                this.ctx.getOverlayMappings().put(spriteKey, overlayData.spriteKey);
            } else {
                uv3 = new float[8];
                ExportContext.TexturePlacement fallbackPlacement = ColorMapManager.registerColor(this.ctx, argb);
                uv3[0] = fallbackPlacement.u0();
                uv3[1] = fallbackPlacement.v0();
                uv3[2] = fallbackPlacement.u1();
                uv3[3] = fallbackPlacement.v0();
                uv3[4] = fallbackPlacement.u1();
                uv3[5] = fallbackPlacement.v1();
                uv3[6] = fallbackPlacement.u0();
                uv3[7] = fallbackPlacement.v1();
            }
        }
        this.sceneSink.addQuad(spriteKey, positions, uv0, uv1, uv2, uv3, faceNormal, colors, doubleSided);
    }

    private boolean isFullyOccluded(BlockPos pos) {
        for (Direction dir : Direction.values()) {
            BlockPos neighbor = pos.relative(dir);
            if (this.isOutsideRegion(neighbor)) {
                return false;
            }
            if (this.isNeighborSolid(neighbor)) continue;
            return false;
        }
        return true;
    }

    private boolean isFaceOccluded(BlockPos pos, Direction face) {
        BlockPos neighbor = pos.relative(face);
        if (this.isOutsideRegion(neighbor)) {
            return false;
        }
        return this.isNeighborSolid(neighbor);
    }

    private boolean isOutsideRegion(BlockPos pos) {
        if (this.regionMin == null || this.regionMax == null) {
            return false;
        }
        return pos.getX() < this.regionMin.getX() || pos.getX() > this.regionMax.getX() || pos.getY() < this.regionMin.getY() || pos.getY() > this.regionMax.getY() || pos.getZ() < this.regionMin.getZ() || pos.getZ() > this.regionMax.getZ();
    }

    private boolean isNeighborSolid(BlockPos neighbor) {
        if (this.chunkCache != null) {
            int cz;
            int cx = neighbor.getX() >> 4;
            LevelChunk chunk = this.chunkCache.getChunk(cx, cz = neighbor.getZ() >> 4, false);
            if (chunk == null || chunk.isEmpty()) {
                return true;
            }
            BlockState state = chunk.getBlockState(neighbor);
            return state.isSolidRender((BlockGetter)this.level, neighbor);
        }
        BlockState neighborState = this.level.getBlockState(neighbor);
        return neighborState.isSolidRender((BlockGetter)this.level, neighbor);
    }

    private boolean isNeighborChunksLoadedForBlock(BlockPos pos) {
        if (this.chunkCache == null) {
            return true;
        }
        int localX = pos.getX() & 0xF;
        int localZ = pos.getZ() & 0xF;
        int cx = pos.getX() >> 4;
        int cz = pos.getZ() >> 4;
        if (localX == 0 && this.isChunkMissing(cx - 1, cz)) {
            return false;
        }
        if (localX == 15 && this.isChunkMissing(cx + 1, cz)) {
            return false;
        }
        if (localZ == 0 && this.isChunkMissing(cx, cz - 1)) {
            return false;
        }
        return localZ != 15 || !this.isChunkMissing(cx, cz + 1);
    }

    private boolean isChunkMissing(int cx, int cz) {
        LevelChunk chunk = this.chunkCache.getChunk(cx, cz, false);
        return chunk == null || chunk.isEmpty();
    }

    public boolean hadMissingNeighborAndReset() {
        boolean result = this.missingNeighborDetected;
        this.missingNeighborDetected = false;
        return result;
    }

    private BakedModel getModel(BlockState state) {
        try {
            ModelManager mm = this.ctx.getMc().getModelManager();
            return mm.getBlockModelShaper().getBlockModel(state);
        }
        catch (Throwable ignored) {
            return null;
        }
    }

    private List<BakedQuad> getQuads(BakedModel model, BlockState state, ModelData data, BlockPos pos) {
        ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
        RandomSource rand = RandomSource.create((long)(state.is(Blocks.LILY_PAD) ? this.computeBushSeed(pos) : 42L));
        try {
            for (Direction dir : Direction.values()) {
                List q = model.getQuads(state, dir, rand, data, null);
                if (q == null) continue;
                quads.addAll(q);
            }
            List q2 = model.getQuads(state, null, rand, data, null);
            if (q2 != null) {
                quads.addAll(q2);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return quads;
    }

    private long computeBushSeed(BlockPos pos) {
        long seed = (long)pos.getX() * 3129871L ^ (long)pos.getZ() * 116129781L ^ (long)pos.getY();
        return seed * seed * 42317861L + seed * 11L;
    }

    private float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private int extractOverlayColor(BlockState state, BlockPos pos, BakedQuad quad, int[] vertexColors) {
        for (int i = 0; i < 4; ++i) {
            int abgr = vertexColors[i];
            int rgb = abgr & 0xFFFFFF;
            if (rgb == 0xFFFFFF) continue;
            return 0xFF000000 | rgb;
        }
        if (quad.getTintIndex() >= 0) {
            int argb = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)this.level, pos, quad.getTintIndex());
            return argb == -1 ? -1 : argb;
        }
        return -1;
    }

    private float[] computeFaceNormal(float[] positions) {
        float ay = positions[4] - positions[1];
        float bz = positions[8] - positions[2];
        float az = positions[5] - positions[2];
        float by = positions[7] - positions[1];
        float nx = ay * bz - az * by;
        float bx = positions[6] - positions[0];
        float ax = positions[3] - positions[0];
        float ny = az * bx - ax * bz;
        float nz = ax * by - ay * bx;
        float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (len == 0.0f) {
            return new float[]{0.0f, 1.0f, 0.0f};
        }
        return new float[]{nx / len, ny / len, nz / len};
    }

    private int computeTintColor(BlockState state, BlockPos pos, BakedQuad quad) {
        if (quad.getTintIndex() < 0) {
            return -1;
        }
        int argb = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)this.level, pos, quad.getTintIndex());
        return argb == -1 ? -1 : argb;
    }

    private float[] whiteColor() {
        return new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    }

    private long computePositionHash(float[] positions) {
        Integer[] order = new Integer[]{0, 1, 2, 3};
        Arrays.sort(order, (a, b) -> {
            int ib;
            int ia = a * 3;
            int cmpX = Float.compare(positions[ia], positions[ib = b * 3]);
            if (cmpX != 0) {
                return cmpX;
            }
            int cmpY = Float.compare(positions[ia + 1], positions[ib + 1]);
            if (cmpY != 0) {
                return cmpY;
            }
            return Float.compare(positions[ia + 2], positions[ib + 2]);
        });
        long hash = 1125899906842597L;
        Integer[] integerArray = order;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int idx = integerArray[i];
            int pi = idx * 3;
            hash = 31L * hash + (long)Math.round(positions[pi] * 100.0f);
            hash = 31L * hash + (long)Math.round(positions[pi + 1] * 100.0f);
            hash = 31L * hash + (long)Math.round(positions[pi + 2] * 100.0f);
        }
        return hash;
    }

    private long computeQuadKey(String spriteKey, float[] positions, float[] normal, boolean doubleSided) {
        Integer[] order = new Integer[]{0, 1, 2, 3};
        Arrays.sort(order, (a, b) -> {
            int ib;
            int ia = a * 3;
            int cmpX = Float.compare(positions[ia], positions[ib = b * 3]);
            if (cmpX != 0) {
                return cmpX;
            }
            int cmpY = Float.compare(positions[ia + 1], positions[ib + 1]);
            if (cmpY != 0) {
                return cmpY;
            }
            return Float.compare(positions[ia + 2], positions[ib + 2]);
        });
        long hash = 1125899906842597L;
        hash = 31L * hash + (long)spriteKey.hashCode();
        if (!doubleSided) {
            hash = 31L * hash + (long)Math.round(normal[0] * 1000.0f);
            hash = 31L * hash + (long)Math.round(normal[1] * 1000.0f);
            hash = 31L * hash + (long)Math.round(normal[2] * 1000.0f);
        }
        Integer[] integerArray = order;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int idx = integerArray[i];
            int pi = idx * 3;
            hash = 31L * hash + (long)Math.round(positions[pi] * 1000.0f);
            hash = 31L * hash + (long)Math.round(positions[pi + 1] * 1000.0f);
            hash = 31L * hash + (long)Math.round(positions[pi + 2] * 1000.0f);
        }
        return hash;
    }

    private static class OverlayQuadData {
        final float[] uv;
        final float[] colorUv;
        final String spriteKey;
        final int color;

        OverlayQuadData(float[] uv, float[] colorUv, String spriteKey, int color) {
            this.uv = uv;
            this.colorUv = colorUv;
            this.spriteKey = spriteKey;
            this.color = color;
        }
    }
}

