/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.exporter.QuadCollector;
import com.voxelbridge.export.scene.SceneSink;
import com.voxelbridge.export.texture.SpriteKeyResolver;
import java.lang.reflect.Method;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.neoforge.client.textures.FluidSpriteCache;

@OnlyIn(value=Dist.CLIENT)
public final class FluidExporter {
    private FluidExporter() {
    }

    public static void sample(ExportContext ctx, SceneSink sceneSink, Level level, BlockState state, BlockPos pos, FluidState fluidState, double offsetX, double offsetY, double offsetZ, BlockPos regionMin, BlockPos regionMax) {
        FluidState fs;
        FluidState fluidState2 = fs = fluidState != null ? fluidState : level.getFluidState(pos);
        if (fs == null || fs.isEmpty()) {
            return;
        }
        TextureAtlasSprite[] sprites = FluidExporter.getFluidSprites(ctx, (BlockAndTintGetter)level, pos, fs);
        if (sprites == null || sprites.length < 1) {
            return;
        }
        BlockRenderDispatcher dispatcher = ctx.getMc().getBlockRenderer();
        QuadCollector collector = new QuadCollector(sceneSink, ctx, pos, sprites, offsetX, offsetY, offsetZ, regionMin, regionMax);
        try {
            Method m = dispatcher.getClass().getMethod("renderLiquid", BlockPos.class, BlockAndTintGetter.class, VertexConsumer.class, FluidState.class);
            m.invoke((Object)dispatcher, pos, level, collector, fs);
            collector.flush();
            return;
        }
        catch (NoSuchMethodException m) {
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
        try {
            Method m2 = dispatcher.getClass().getMethod("renderLiquid", BlockPos.class, BlockAndTintGetter.class, VertexConsumer.class, BlockState.class, FluidState.class);
            m2.invoke((Object)dispatcher, pos, level, collector, state, fs);
            collector.flush();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }

    private static TextureAtlasSprite[] getFluidSprites(ExportContext ctx, BlockAndTintGetter level, BlockPos pos, FluidState fs) {
        TextureAtlas atlas3;
        try {
            TextureAtlasSprite[] sprites = FluidSpriteCache.getFluidSprites((BlockAndTintGetter)level, (BlockPos)pos, (FluidState)fs);
            if (sprites != null && sprites.length >= 2) {
                TextureAtlasSprite still = sprites[0];
                TextureAtlasSprite flow = sprites[1];
                TextureAtlas atlas2 = ctx.getMc().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS);
                TextureAtlasSprite missing = atlas2.getSprite(MissingTextureAtlasSprite.getLocation());
                if (still == null) {
                    still = missing;
                }
                if (flow == null) {
                    flow = missing;
                }
                return new TextureAtlasSprite[]{still, flow};
            }
        }
        catch (Throwable sprites) {
            // empty catch block
        }
        try {
            String[][] pairs;
            atlas3 = ctx.getMc().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS);
            String fluidName = fs.getType().toString();
            if (fluidName.startsWith("flowing_")) {
                fluidName = fluidName.substring("flowing_".length());
            }
            String namespace = "minecraft";
            String path = fluidName;
            if (fluidName.contains(":")) {
                String[] parts = fluidName.split(":", 2);
                namespace = parts[0];
                path = parts[1];
            }
            if (path.startsWith("flowing_")) {
                path = path.substring("flowing_".length());
            }
            for (String[] pair : pairs = new String[][]{{"block/" + path + "_still", "block/" + path + "_flow"}, {"block/" + path + "_still", "block/" + path + "_flowing"}, {"block/" + path, "block/" + path + "_flow"}, {"block/" + path, "block/" + path + "_flowing"}}) {
                ResourceLocation stillLoc = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)pair[0]);
                ResourceLocation flowLoc = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)pair[1]);
                TextureAtlasSprite still = atlas3.getSprite(stillLoc);
                TextureAtlasSprite flow = atlas3.getSprite(flowLoc);
                String stillKey = SpriteKeyResolver.resolve(still);
                String flowKey = SpriteKeyResolver.resolve(flow);
                if (stillKey.contains("missingno") || flowKey.contains("missingno")) continue;
                return new TextureAtlasSprite[]{still, flow};
            }
        }
        catch (Throwable atlas3) {
            // empty catch block
        }
        try {
            atlas3 = ctx.getMc().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS);
            TextureAtlasSprite missing = atlas3.getSprite(MissingTextureAtlasSprite.getLocation());
            return new TextureAtlasSprite[]{missing, missing};
        }
        catch (Throwable ignored) {
            return new TextureAtlasSprite[0];
        }
    }
}

