/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.scene.SceneSink;
import com.voxelbridge.export.texture.ColorMapManager;
import com.voxelbridge.export.texture.SpriteKeyResolver;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;

final class QuadCollector
implements VertexConsumer {
    private final SceneSink sink;
    private final ExportContext ctx;
    private final BlockPos pos;
    private final TextureAtlasSprite[] sprites;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final double regionMinX;
    private final double regionMaxX;
    private final double regionMinZ;
    private final double regionMaxZ;
    private final boolean hasRegionBounds;
    private final float[] rawPositions = new float[12];
    private int rawCount = 0;
    private boolean decided = false;
    private boolean needsOffset = false;
    private boolean useChunkOffset = false;
    private int chunkOffsetX = 0;
    private int chunkOffsetY = 0;
    private int chunkOffsetZ = 0;
    private final float[] positions = new float[12];
    private final float[] uvs = new float[8];
    private final float[] colors = new float[16];
    private int quadArgb = -1;
    private boolean quadColorCaptured = false;
    private int vertexIndex = 0;

    QuadCollector(SceneSink sink, ExportContext ctx, BlockPos pos, TextureAtlasSprite[] sprites, double offsetX, double offsetY, double offsetZ, BlockPos regionMin, BlockPos regionMax) {
        this.sink = sink;
        this.ctx = ctx;
        this.pos = pos;
        this.sprites = sprites;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        if (regionMin != null && regionMax != null) {
            this.regionMinX = (double)regionMin.getX() + offsetX;
            this.regionMaxX = (double)regionMax.getX() + offsetX + 1.0;
            this.regionMinZ = (double)regionMin.getZ() + offsetZ;
            this.regionMaxZ = (double)regionMax.getZ() + offsetZ + 1.0;
            this.hasRegionBounds = true;
        } else {
            this.regionMaxZ = 0.0;
            this.regionMinZ = 0.0;
            this.regionMaxX = 0.0;
            this.regionMinX = 0.0;
            this.hasRegionBounds = false;
        }
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        if (this.rawCount < this.rawPositions.length) {
            this.rawPositions[this.rawCount * 3] = x;
            this.rawPositions[this.rawCount * 3 + 1] = y;
            this.rawPositions[this.rawCount * 3 + 2] = z;
            ++this.rawCount;
        }
        if (!this.decided && this.rawCount >= 4) {
            this.decideCoordinateSystem();
            this.decided = true;
            this.recomputePositions();
        }
        float[] adjusted = this.applyOffsets(x, y, z);
        this.positions[this.vertexIndex * 3] = adjusted[0];
        this.positions[this.vertexIndex * 3 + 1] = adjusted[1];
        this.positions[this.vertexIndex * 3 + 2] = adjusted[2];
        return this;
    }

    public VertexConsumer setColor(int r, int g, int b, int a) {
        this.colors[this.vertexIndex * 4] = (float)r / 255.0f;
        this.colors[this.vertexIndex * 4 + 1] = (float)g / 255.0f;
        this.colors[this.vertexIndex * 4 + 2] = (float)b / 255.0f;
        this.colors[this.vertexIndex * 4 + 3] = (float)a / 255.0f;
        if (!this.quadColorCaptured) {
            this.quadArgb = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
            this.quadColorCaptured = true;
        }
        return this;
    }

    public VertexConsumer setUv(float u, float v) {
        this.uvs[this.vertexIndex * 2] = u;
        this.uvs[this.vertexIndex * 2 + 1] = v;
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        return this;
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        ++this.vertexIndex;
        if (this.vertexIndex == 4) {
            this.emitQuad();
            this.vertexIndex = 0;
        }
        return this;
    }

    public void endVertex() {
    }

    public void defaultColor(int r, int g, int b, int a) {
    }

    public void unsetDefaultColor() {
    }

    private void emitQuad() {
        TextureAtlasSprite sprite = this.chooseSpriteForQuad();
        if (sprite == null) {
            return;
        }
        if (this.hasRegionBounds && this.isBoundarySideQuad()) {
            this.resetQuadState();
            return;
        }
        String spriteKey = SpriteKeyResolver.resolve(sprite);
        float[] normalizedUVs = new float[8];
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        float du = u1 - u0;
        float dv = v1 - v0;
        if (du == 0.0f) {
            du = 1.0f;
        }
        if (dv == 0.0f) {
            dv = 1.0f;
        }
        for (int i = 0; i < 4; ++i) {
            float u = this.uvs[i * 2];
            float v = this.uvs[i * 2 + 1];
            float su = (u - u0) / du;
            float sv = (v - v0) / dv;
            su = this.clamp01(su);
            sv = this.clamp01(sv);
            normalizedUVs[i * 2] = su;
            normalizedUVs[i * 2 + 1] = sv;
        }
        float[] normal = this.computeFaceNormal(this.positions);
        float[] lut = ColorMapManager.remapColorUV(this.ctx, this.quadArgb);
        u0 = lut[0];
        v0 = lut[1];
        u1 = lut[2];
        v1 = lut[3];
        du = u1 - u0;
        dv = v1 - v0;
        float[] uv1 = new float[8];
        for (int i = 0; i < 4; ++i) {
            uv1[i * 2] = u0 + normalizedUVs[i * 2] * du;
            uv1[i * 2 + 1] = v0 + normalizedUVs[i * 2 + 1] * dv;
        }
        float[] linearColors = this.whiteColor();
        this.sink.addQuad(spriteKey, (float[])this.positions.clone(), normalizedUVs, uv1, null, null, normal, linearColors, true);
        this.rawCount = 0;
        this.decided = false;
        this.needsOffset = false;
        this.useChunkOffset = false;
        this.quadColorCaptured = false;
        this.quadArgb = -1;
    }

    private void resetQuadState() {
        this.rawCount = 0;
        this.decided = false;
        this.needsOffset = false;
        this.useChunkOffset = false;
        this.quadColorCaptured = false;
        this.quadArgb = -1;
    }

    private boolean isBoundarySideQuad() {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 4; ++i) {
            double x = this.positions[i * 3];
            double z = this.positions[i * 3 + 2];
            if (x < minX) {
                minX = x;
            }
            if (x > maxX) {
                maxX = x;
            }
            if (z < minZ) {
                minZ = z;
            }
            if (!(z > maxZ)) continue;
            maxZ = z;
        }
        double eps = 0.001;
        boolean onMinX = Math.abs(minX - this.regionMinX) < eps && Math.abs(maxX - this.regionMinX) < eps;
        boolean onMaxX = Math.abs(minX - this.regionMaxX) < eps && Math.abs(maxX - this.regionMaxX) < eps;
        boolean onMinZ = Math.abs(minZ - this.regionMinZ) < eps && Math.abs(maxZ - this.regionMinZ) < eps;
        boolean onMaxZ = Math.abs(minZ - this.regionMaxZ) < eps && Math.abs(maxZ - this.regionMaxZ) < eps;
        return onMinX || onMaxX || onMinZ || onMaxZ;
    }

    private float[] computeFaceNormal(float[] pos) {
        float ay = pos[4] - pos[1];
        float bz = pos[8] - pos[2];
        float az = pos[5] - pos[2];
        float by = pos[7] - pos[1];
        float nx = ay * bz - az * by;
        float bx = pos[6] - pos[0];
        float ax = pos[3] - pos[0];
        float ny = az * bx - ax * bz;
        float nz = ax * by - ay * bx;
        float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (len == 0.0f) {
            return new float[]{0.0f, 1.0f, 0.0f};
        }
        return new float[]{nx / len, ny / len, nz / len};
    }

    private float[] whiteColor() {
        return new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    }

    private float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private TextureAtlasSprite chooseSpriteForQuad() {
        float distFlow;
        if (this.sprites.length == 0) {
            return null;
        }
        if (this.sprites.length == 1) {
            return this.sprites[0];
        }
        TextureAtlasSprite still = this.sprites[0];
        TextureAtlasSprite flowing = this.sprites[1];
        float centerU = 0.0f;
        float centerV = 0.0f;
        int count = 0;
        for (int i = 0; i < 4; ++i) {
            centerU += this.uvs[i * 2];
            centerV += this.uvs[i * 2 + 1];
            ++count;
        }
        if (count == 0) {
            return still;
        }
        if (this.isPointInSprite(centerU /= (float)count, centerV /= (float)count, still, 0.02f)) {
            return still;
        }
        if (this.isPointInSprite(centerU, centerV, flowing, 0.02f)) {
            return flowing;
        }
        float distStill = this.distanceToSpriteCenter(still, centerU, centerV);
        return distStill <= (distFlow = this.distanceToSpriteCenter(flowing, centerU, centerV)) ? still : flowing;
    }

    private boolean isPointInSprite(float u, float v, TextureAtlasSprite sprite, float eps) {
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        return u >= u0 - eps && u <= u1 + eps && v >= v0 - eps && v <= v1 + eps;
    }

    private float distanceToSpriteCenter(TextureAtlasSprite sprite, float u, float v) {
        float centerU = (sprite.getU0() + sprite.getU1()) * 0.5f;
        float centerV = (sprite.getV0() + sprite.getV1()) * 0.5f;
        float du = u - centerU;
        float dv = v - centerV;
        return (float)Math.sqrt(du * du + dv * dv);
    }

    private void decideCoordinateSystem() {
        boolean looksLikeChunkCoords;
        boolean inUnitRange;
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < Math.min(this.rawCount, 4); ++i) {
            float vx = this.rawPositions[i * 3];
            float vy = this.rawPositions[i * 3 + 1];
            float vz = this.rawPositions[i * 3 + 2];
            minX = Math.min(minX, vx);
            maxX = Math.max(maxX, vx);
            minY = Math.min(minY, vy);
            maxY = Math.max(maxY, vy);
            minZ = Math.min(minZ, vz);
            maxZ = Math.max(maxZ, vz);
        }
        int chunkX = Math.floorDiv(this.pos.getX(), 16);
        int chunkY = Math.floorDiv(this.pos.getY(), 16);
        int chunkZ = Math.floorDiv(this.pos.getZ(), 16);
        int chunkBaseX = chunkX * 16;
        int chunkBaseY = chunkY * 16;
        int chunkBaseZ = chunkZ * 16;
        int localX = Math.floorMod(this.pos.getX(), 16);
        int localY = Math.floorMod(this.pos.getY(), 16);
        int localZ = Math.floorMod(this.pos.getZ(), 16);
        boolean bl = inUnitRange = minX >= -0.001f && maxX <= 1.001f && minY >= -0.001f && maxY <= 1.001f && minZ >= -0.001f && maxZ <= 1.001f;
        if (inUnitRange) {
            this.needsOffset = true;
            this.useChunkOffset = false;
            return;
        }
        boolean xInChunkRange = minX >= -0.1f && maxX <= 16.1f;
        boolean yInChunkRange = minY >= -0.1f && maxY <= 16.1f;
        boolean zInChunkRange = minZ >= -0.1f && maxZ <= 16.1f;
        boolean xMatchesLocal = Math.abs(minX - (float)localX) < 1.5f;
        boolean yMatchesLocal = Math.abs(minY - (float)localY) < 1.5f;
        boolean zMatchesLocal = Math.abs(minZ - (float)localZ) < 1.5f;
        boolean bl2 = looksLikeChunkCoords = xInChunkRange && yInChunkRange && zInChunkRange && xMatchesLocal && yMatchesLocal && zMatchesLocal;
        if (looksLikeChunkCoords) {
            this.needsOffset = true;
            this.useChunkOffset = true;
            this.chunkOffsetX = chunkBaseX;
            this.chunkOffsetY = chunkBaseY;
            this.chunkOffsetZ = chunkBaseZ;
            return;
        }
        this.needsOffset = false;
        this.useChunkOffset = false;
    }

    private float[] applyOffsets(float x, float y, float z) {
        float wz;
        float wy;
        float wx;
        if (!this.needsOffset) {
            wx = x;
            wy = y;
            wz = z;
        } else if (this.useChunkOffset) {
            wx = (float)this.chunkOffsetX + x;
            wy = (float)this.chunkOffsetY + y;
            wz = (float)this.chunkOffsetZ + z;
        } else {
            wx = (float)this.pos.getX() + x;
            wy = (float)this.pos.getY() + y;
            wz = (float)this.pos.getZ() + z;
        }
        return new float[]{(float)((double)wx + this.offsetX), (float)((double)wy + this.offsetY), (float)((double)wz + this.offsetZ)};
    }

    private void recomputePositions() {
        int verts = Math.min(this.rawCount, 4);
        for (int i = 0; i < verts; ++i) {
            float x = this.rawPositions[i * 3];
            float y = this.rawPositions[i * 3 + 1];
            float z = this.rawPositions[i * 3 + 2];
            float[] adjusted = this.applyOffsets(x, y, z);
            this.positions[i * 3] = adjusted[0];
            this.positions[i * 3 + 1] = adjusted[1];
            this.positions[i * 3 + 2] = adjusted[2];
        }
    }

    public void flush() {
        this.rawCount = 0;
        this.decided = false;
        this.needsOffset = false;
        this.useChunkOffset = false;
    }
}

