/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter.blockentity;

import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.exporter.blockentity.BannerTextureBaker;
import com.voxelbridge.export.exporter.blockentity.BlockEntityExportResult;
import com.voxelbridge.export.exporter.blockentity.BlockEntityHandler;
import com.voxelbridge.export.exporter.blockentity.BlockEntityRenderer;
import com.voxelbridge.export.exporter.blockentity.TextureOverrideMap;
import com.voxelbridge.export.scene.SceneSink;
import com.voxelbridge.export.texture.BlockEntityTextureManager;
import com.voxelbridge.export.texture.EntityTextureManager;
import com.voxelbridge.util.ExportLogger;
import java.awt.image.BufferedImage;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BannerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class BannerBlockEntityHandler
implements BlockEntityHandler {
    BannerBlockEntityHandler() {
    }

    @Override
    public BlockEntityExportResult export(ExportContext ctx, Level level, BlockState state, BlockEntity blockEntity, BlockPos pos, SceneSink sceneSink, double offsetX, double offsetY, double offsetZ) {
        boolean rendered;
        if (!(blockEntity instanceof BannerBlockEntity)) {
            return BlockEntityExportResult.NOT_HANDLED;
        }
        BannerBlockEntity banner = (BannerBlockEntity)blockEntity;
        BannerTextureBaker.BannerTextures textures = BannerTextureBaker.bake(ctx, banner);
        BufferedImage baked = ctx.getGeneratedEntityTextures().get(textures.bakedHandle().spriteKey());
        String beSpriteKey = null;
        EntityTextureManager.TextureHandle blockEntityHandle = null;
        if (baked != null) {
            beSpriteKey = BlockEntityTextureManager.registerGenerated(ctx, textures.bakedHandle(), baked);
            blockEntityHandle = new EntityTextureManager.TextureHandle(beSpriteKey, textures.bakedHandle().materialName(), textures.bakedHandle().relativePath(), textures.bakedHandle().textureLocation());
        } else {
            ExportLogger.log("[BannerBlockEntityHandler][WARN] Missing baked image for " + textures.bakedHandle().spriteKey());
        }
        TextureOverrideMap overrideWrapper = textures.overrides();
        if (blockEntityHandle != null) {
            final EntityTextureManager.TextureHandle finalHandle = blockEntityHandle;
            final TextureOverrideMap delegate = textures.overrides();
            overrideWrapper = new TextureOverrideMap(){

                @Override
                public EntityTextureManager.TextureHandle resolve(ResourceLocation spriteName) {
                    return delegate.resolve(spriteName) != null ? finalHandle : null;
                }

                @Override
                public boolean skipQuad(ResourceLocation spriteName, float[] localU, float[] localV) {
                    return delegate.skipQuad(spriteName, localU, localV);
                }
            };
        }
        return (rendered = BlockEntityRenderer.render(ctx, blockEntity, sceneSink, (double)pos.getX() + offsetX, (double)pos.getY() + offsetY, (double)pos.getZ() + offsetZ, overrideWrapper)) ? BlockEntityExportResult.RENDERED_KEEP_BLOCK : BlockEntityExportResult.NOT_HANDLED;
    }
}

