/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter.blockentity;

import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.exporter.blockentity.BannerBlockEntityHandler;
import com.voxelbridge.export.exporter.blockentity.BlockEntityExportResult;
import com.voxelbridge.export.exporter.blockentity.BlockEntityHandler;
import com.voxelbridge.export.exporter.blockentity.GenericBlockEntityHandler;
import com.voxelbridge.export.scene.SceneSink;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BlockEntityExporter {
    private static final List<BlockEntityHandler> HANDLERS = List.of(new BannerBlockEntityHandler(), new GenericBlockEntityHandler());

    private BlockEntityExporter() {
    }

    public static BlockEntityExportResult export(ExportContext ctx, Level level, BlockState state, BlockEntity blockEntity, BlockPos pos, SceneSink sceneSink, double offsetX, double offsetY, double offsetZ) {
        if (blockEntity == null || !ctx.isBlockEntityExportEnabled()) {
            return BlockEntityExportResult.NOT_HANDLED;
        }
        for (BlockEntityHandler handler : HANDLERS) {
            BlockEntityExportResult result = handler.export(ctx, level, state, blockEntity, pos, sceneSink, offsetX, offsetY, offsetZ);
            if (!result.rendered()) continue;
            return result;
        }
        return BlockEntityExportResult.NOT_HANDLED;
    }
}

