/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter.blockentity;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.exporter.blockentity.BlockEntityAtlasLocator;
import com.voxelbridge.export.exporter.blockentity.BlockEntityTextureResolver;
import com.voxelbridge.export.exporter.blockentity.RenderTypeTextureResolver;
import com.voxelbridge.export.exporter.blockentity.TextureOverrideMap;
import com.voxelbridge.export.scene.SceneSink;
import com.voxelbridge.export.texture.BlockEntityTextureManager;
import com.voxelbridge.export.texture.EntityTextureManager;
import com.voxelbridge.util.BlockEntityDebugLogger;
import com.voxelbridge.util.ExportLogger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderDispatcher;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BlockEntityRenderer {
    private static final float[] EMPTY_UV = new float[8];
    private static final float[] NORMAL_UP = new float[]{0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f};
    private static final BlockEntityAtlasLocator ATLAS_LOCATOR = new BlockEntityAtlasLocator(Minecraft.getInstance());
    private static final ThreadLocal<TextureOverrideMap> OVERRIDES = new ThreadLocal();

    private BlockEntityRenderer() {
    }

    public static boolean render(ExportContext ctx, BlockEntity blockEntity, SceneSink sceneSink, double offsetX, double offsetY, double offsetZ) {
        return BlockEntityRenderer.render(ctx, blockEntity, sceneSink, offsetX, offsetY, offsetZ, null);
    }

    public static boolean render(ExportContext ctx, BlockEntity blockEntity, SceneSink sceneSink, double offsetX, double offsetY, double offsetZ, TextureOverrideMap overrides) {
        ExportLogger.log("[BlockEntityRenderer] Attempting to render BlockEntity: " + blockEntity.getClass().getSimpleName() + " at " + String.valueOf(blockEntity.getBlockPos()));
        BlockEntityRenderDispatcher dispatcher = ctx.getMc().getBlockEntityRenderDispatcher();
        net.minecraft.client.renderer.blockentity.BlockEntityRenderer renderer = dispatcher.getRenderer(blockEntity);
        if (renderer == null) {
            ExportLogger.log("[BlockEntityRenderer] No renderer found for: " + blockEntity.getClass().getSimpleName());
            return false;
        }
        ExportLogger.log("[BlockEntityRenderer] Found renderer: " + renderer.getClass().getSimpleName());
        AtomicBoolean success = new AtomicBoolean(false);
        Minecraft.getInstance().executeBlocking(() -> {
            try {
                if (overrides != null) {
                    OVERRIDES.set(overrides);
                }
                PoseStack poseStack = new PoseStack();
                poseStack.translate(offsetX, offsetY, offsetZ);
                CaptureBuffer captureBuffer = new CaptureBuffer(ctx, sceneSink, offsetX, offsetY, offsetZ, blockEntity);
                renderer.render(blockEntity, 0.0f, poseStack, (MultiBufferSource)captureBuffer, 0xF000F0, OverlayTexture.NO_OVERLAY);
                captureBuffer.flush();
                boolean hadGeometry = captureBuffer.hadGeometry();
                success.set(hadGeometry);
                ExportLogger.log("[BlockEntityRenderer] Render complete: hadGeometry=" + hadGeometry);
            }
            catch (Exception e) {
                ExportLogger.log("[BlockEntityRenderer] Render error: " + e.getMessage());
                e.printStackTrace();
            }
            finally {
                OVERRIDES.remove();
            }
        });
        boolean result = success.get();
        ExportLogger.log("[BlockEntityRenderer] Final result: " + result);
        return result;
    }

    private static class CaptureBuffer
    implements MultiBufferSource {
        private final ExportContext ctx;
        private final SceneSink sceneSink;
        private final double offsetX;
        private final double offsetY;
        private final double offsetZ;
        private final BlockEntity blockEntity;
        private final Map<RenderType, VertexCollector> collectors = new HashMap<RenderType, VertexCollector>();
        private boolean hadGeometry = false;
        private final TextureOverrideMap overrides;

        CaptureBuffer(ExportContext ctx, SceneSink sceneSink, double offsetX, double offsetY, double offsetZ, BlockEntity blockEntity) {
            this.ctx = ctx;
            this.sceneSink = sceneSink;
            this.offsetX = offsetX;
            this.offsetY = offsetY;
            this.offsetZ = offsetZ;
            this.blockEntity = blockEntity;
            this.overrides = OVERRIDES.get();
        }

        public VertexConsumer getBuffer(RenderType renderType) {
            return this.collectors.computeIfAbsent(renderType, rt -> new VertexCollector(this, (RenderType)rt));
        }

        void flush() {
            for (VertexCollector collector : this.collectors.values()) {
                collector.flush();
            }
        }

        boolean hadGeometry() {
            return this.hadGeometry;
        }

        void recordGeometry() {
            this.hadGeometry = true;
        }

        TextureOverrideMap overrides() {
            return this.overrides;
        }

        private static class VertexCollector
        implements VertexConsumer {
            private final CaptureBuffer parent;
            private final RenderType renderType;
            private final List<Vertex> vertices = new ArrayList<Vertex>(4);

            VertexCollector(CaptureBuffer parent, RenderType renderType) {
                this.parent = parent;
                this.renderType = renderType;
            }

            public VertexConsumer addVertex(float x, float y, float z) {
                if (this.vertices.size() < 4) {
                    this.vertices.add(new Vertex(x, y, z));
                    ExportLogger.log("[VertexCollector] addVertex: (" + x + "," + y + "," + z + ") - now have " + this.vertices.size() + " vertices");
                }
                return this;
            }

            public VertexConsumer setColor(int r, int g, int b, int a) {
                if (!this.vertices.isEmpty()) {
                    Vertex last = this.vertices.get(this.vertices.size() - 1);
                    last.color = a << 24 | r << 16 | g << 8 | b;
                }
                return this;
            }

            public VertexConsumer setUv(float u, float v) {
                if (!this.vertices.isEmpty()) {
                    Vertex last = this.vertices.get(this.vertices.size() - 1);
                    last.u = u;
                    last.v = v;
                    ExportLogger.log("[VertexCollector] setUv called: u=" + u + ", v=" + v + " for vertex " + (this.vertices.size() - 1));
                }
                return this;
            }

            public VertexConsumer setUv1(int u, int v) {
                return this;
            }

            public VertexConsumer setUv2(int u, int v) {
                return this;
            }

            public VertexConsumer setNormal(float nx, float ny, float nz) {
                BlockEntityDebugLogger.log("[VertexCollector] setNormal called, vertices.size=" + this.vertices.size());
                if (this.vertices.size() >= 4) {
                    BlockEntityDebugLogger.log("[VertexCollector] All 4 vertices complete, emitting quad");
                    this.emitQuad();
                }
                return this;
            }

            private void emitQuad() {
                if (this.vertices.size() >= 4) {
                    this.outputQuad();
                    this.vertices.clear();
                } else {
                    BlockEntityDebugLogger.log("[VertexCollector][WARN] emitQuad called but only " + this.vertices.size() + " vertices collected!");
                }
            }

            void flush() {
                if (this.vertices.size() >= 3) {
                    this.outputQuad();
                    this.vertices.clear();
                }
            }

            private void outputQuad() {
                String spriteKey;
                float area;
                if (this.vertices.size() < 3) {
                    return;
                }
                BlockEntityDebugLogger.log("[VertexCollector] ========== OUTPUT QUAD START ==========");
                BlockEntityDebugLogger.log("[VertexCollector] Vertices count: " + this.vertices.size());
                for (int i = 0; i < this.vertices.size(); ++i) {
                    Vertex v = this.vertices.get(i);
                    BlockEntityDebugLogger.log("[VertexCollector]   V" + i + ": pos=(" + v.x + "," + v.y + "," + v.z + ") uv=(" + v.u + "," + v.v + ")");
                }
                if (this.vertices.size() >= 3 && (area = this.computeQuadArea(this.vertices)) < 1.0E-4f) {
                    BlockEntityDebugLogger.log("[VertexCollector] Skipping degenerate quad (area=" + area + ")");
                    return;
                }
                this.parent.recordGeometry();
                float[] positions = new float[12];
                float[] uv0 = new float[8];
                float[] colors = new float[16];
                for (int i = 0; i < Math.min(4, this.vertices.size()); ++i) {
                    Vertex v = this.vertices.get(i);
                    positions[i * 3] = v.x;
                    positions[i * 3 + 1] = v.y;
                    positions[i * 3 + 2] = v.z;
                    colors[i * 4] = (float)(v.color >> 16 & 0xFF) / 255.0f;
                    colors[i * 4 + 1] = (float)(v.color >> 8 & 0xFF) / 255.0f;
                    colors[i * 4 + 2] = (float)(v.color & 0xFF) / 255.0f;
                    colors[i * 4 + 3] = (float)(v.color >> 24 & 0xFF) / 255.0f;
                }
                BlockEntityTextureResolver.ResolvedTexture textureRes = BlockEntityTextureResolver.resolve(this.parent.blockEntity, this.renderType);
                TextureOverrideMap overrides = this.parent.overrides();
                boolean isAtlasTexture = false;
                float u0 = 0.0f;
                float u1 = 1.0f;
                float v0 = 0.0f;
                float v1 = 1.0f;
                ResourceLocation atlasLocation = textureRes != null ? textureRes.atlasLocation() : null;
                int vertCount = Math.min(4, this.vertices.size());
                float[] rawU = new float[vertCount];
                float[] rawV = new float[vertCount];
                for (int i = 0; i < vertCount; ++i) {
                    rawU[i] = this.vertices.get((int)i).u;
                    rawV[i] = this.vertices.get((int)i).v;
                }
                float[] wrappedU = new float[vertCount];
                float[] wrappedV = new float[vertCount];
                for (int i = 0; i < vertCount; ++i) {
                    wrappedU[i] = this.wrap01(rawU[i]);
                    wrappedV[i] = this.wrap01(rawV[i]);
                }
                BlockEntityDebugLogger.log("[VertexCollector] RenderType=" + String.valueOf(this.renderType) + " blockEntity=" + this.parent.blockEntity.getClass().getSimpleName() + " pos=" + String.valueOf(this.parent.blockEntity.getBlockPos()) + " rawUV=" + Arrays.toString(rawU) + "," + Arrays.toString(rawV) + " wrappedUV=" + Arrays.toString(wrappedU) + "," + Arrays.toString(wrappedV) + " overrides=" + (overrides != null));
                if (textureRes != null && textureRes.isAtlasTexture() && textureRes.sprite() == null) {
                    float centerV;
                    float centerU;
                    ResourceLocation atlas = atlasLocation != null ? atlasLocation : textureRes.texture();
                    TextureAtlasSprite located = ATLAS_LOCATOR.find(atlas, centerU = this.average(wrappedU), centerV = this.average(wrappedV));
                    if (located != null) {
                        BlockEntityDebugLogger.log("[VertexCollector] Atlas locate by UV center=(" + centerU + "," + centerV + ") -> " + String.valueOf(located.contents().name()));
                        textureRes = new BlockEntityTextureResolver.ResolvedTexture(located.contents().name(), located.getU0(), located.getU1(), located.getV0(), located.getV1(), true, located, atlas);
                        atlasLocation = atlas;
                    } else {
                        BlockEntityDebugLogger.log("[VertexCollector][WARN] Atlas locate failed for center=(" + centerU + "," + centerV + ") atlas=" + String.valueOf(atlas));
                    }
                }
                if (textureRes != null && overrides != null) {
                    if (overrides.skipQuad(textureRes.texture(), rawU, rawV)) {
                        ExportLogger.log("[VertexCollector] Quad skipped by override for texture " + String.valueOf(textureRes.texture()));
                        return;
                    }
                    EntityTextureManager.TextureHandle mappedHandle = overrides.resolve(textureRes.texture());
                    if (mappedHandle != null) {
                        String spriteKey2 = mappedHandle.spriteKey();
                        isAtlasTexture = textureRes.isAtlasTexture();
                        u0 = textureRes.u0();
                        u1 = textureRes.u1();
                        v0 = textureRes.v0();
                        v1 = textureRes.v1();
                        BlockEntityDebugLogger.log("[VertexCollector] Override mapped " + String.valueOf(textureRes.texture()) + " -> " + spriteKey2 + " atlas=" + isAtlasTexture + " uvBounds=[" + u0 + "," + u1 + "]x[" + v0 + "," + v1 + "]");
                        this.fillUvs(this.vertices, uv0, isAtlasTexture, u0, u1, v0, v1);
                        this.parent.sceneSink.addQuad(spriteKey2, positions, uv0, EMPTY_UV, null, null, NORMAL_UP, colors, RenderTypeTextureResolver.isDoubleSided(this.renderType));
                        return;
                    }
                }
                if (textureRes != null && textureRes.texture() != null) {
                    spriteKey = BlockEntityTextureManager.registerTexture(this.parent.ctx, textureRes);
                    isAtlasTexture = textureRes.isAtlasTexture();
                    u0 = textureRes.u0();
                    u1 = textureRes.u1();
                    v0 = textureRes.v0();
                    v1 = textureRes.v1();
                    BlockEntityDebugLogger.log("[VertexCollector] Using texture: " + spriteKey + " from " + String.valueOf(textureRes.texture()) + " (atlas=" + isAtlasTexture + ") UV bounds: [" + u0 + "," + u1 + "] x [" + v0 + "," + v1 + "]");
                } else {
                    spriteKey = "blockentity:minecraft/block/white";
                    BlockEntityDebugLogger.log("[VertexCollector] No texture extracted, using default: " + spriteKey);
                }
                this.fillUvs(this.vertices, uv0, isAtlasTexture, u0, u1, v0, v1);
                BlockEntityDebugLogger.log("[VertexCollector] Final UV0=" + Arrays.toString(uv0) + " spriteKey=" + spriteKey + " atlas=" + isAtlasTexture + " uvBounds=[" + u0 + "," + u1 + "]x[" + v0 + "," + v1 + "]");
                this.parent.sceneSink.addQuad(spriteKey, positions, uv0, EMPTY_UV, null, null, NORMAL_UP, colors, RenderTypeTextureResolver.isDoubleSided(this.renderType));
            }

            private void fillUvs(List<Vertex> verts, float[] uv0, boolean isAtlas, float u0, float u1, float v0, float v1) {
                int count = Math.min(4, verts.size());
                if (isAtlas) {
                    float du = u1 - u0;
                    float dv = v1 - v0;
                    ExportLogger.log("[VertexCollector] fillUvs atlas mode du=" + du + " dv=" + dv);
                    for (int i = 0; i < count; ++i) {
                        Vertex v = verts.get(i);
                        float su = du == 0.0f ? 0.0f : (v.u - u0) / du;
                        float sv = dv == 0.0f ? 0.0f : (v.v - v0) / dv;
                        su = Math.max(0.0f, Math.min(1.0f, su));
                        sv = Math.max(0.0f, Math.min(1.0f, sv));
                        uv0[i * 2] = su;
                        uv0[i * 2 + 1] = sv;
                        ExportLogger.log("[VertexCollector] V" + i + " atlas UV: (" + v.u + "," + v.v + ") -> sprite UV: (" + su + "," + sv + ") [bounds: u(" + u0 + "-" + u1 + ") v(" + v0 + "-" + v1 + ")]");
                    }
                } else {
                    for (int i = 0; i < count; ++i) {
                        Vertex v = verts.get(i);
                        float su = Math.max(0.0f, Math.min(1.0f, v.u));
                        float sv = Math.max(0.0f, Math.min(1.0f, v.v));
                        uv0[i * 2] = su;
                        uv0[i * 2 + 1] = sv;
                        ExportLogger.log("[VertexCollector] V" + i + " standalone UV: (" + v.u + "," + v.v + ") -> (" + su + "," + sv + ")");
                    }
                }
            }

            private float average(float[] arr) {
                if (arr == null || arr.length == 0) {
                    return 0.0f;
                }
                float sum = 0.0f;
                for (float v : arr) {
                    sum += v;
                }
                return sum / (float)arr.length;
            }

            private float clamp01(float v) {
                return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
            }

            private float wrap01(float v) {
                float wrapped = v % 1.0f;
                if (wrapped < 0.0f) {
                    wrapped += 1.0f;
                }
                return wrapped;
            }

            private float computeQuadArea(List<Vertex> verts) {
                if (verts.size() < 3) {
                    return 0.0f;
                }
                Vertex v0 = verts.get(0);
                Vertex v1 = verts.get(1);
                Vertex v2 = verts.get(2);
                float ax = v1.x - v0.x;
                float ay = v1.y - v0.y;
                float az = v1.z - v0.z;
                float bx = v2.x - v0.x;
                float by = v2.y - v0.y;
                float bz = v2.z - v0.z;
                float cx = ay * bz - az * by;
                float cy = az * bx - ax * bz;
                float cz = ax * by - ay * bx;
                float area = (float)Math.sqrt(cx * cx + cy * cy + cz * cz);
                return area;
            }

            private float[] computeNormal(float[] positions) {
                float ay = positions[4] - positions[1];
                float bz = positions[8] - positions[2];
                float az = positions[5] - positions[2];
                float by = positions[7] - positions[1];
                float nx = ay * bz - az * by;
                float bx = positions[6] - positions[0];
                float ax = positions[3] - positions[0];
                float ny = az * bx - ax * bz;
                float nz = ax * by - ay * bx;
                float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
                if (len == 0.0f) {
                    return new float[]{0.0f, 1.0f, 0.0f};
                }
                return new float[]{nx / len, ny / len, nz / len};
            }

            private static class Vertex {
                float x;
                float y;
                float z;
                float u;
                float v;
                int color = -1;

                Vertex(float x, float y, float z) {
                    this.x = x;
                    this.y = y;
                    this.z = z;
                }
            }
        }
    }
}

