/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter.blockentity;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Optional;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class RenderTypeTextureResolver {
    private RenderTypeTextureResolver() {
    }

    public static ResourceLocation resolve(RenderType renderType) {
        if (renderType == null) {
            return null;
        }
        ResourceLocation fromState = RenderTypeTextureResolver.extractFromState(renderType);
        if (fromState != null) {
            return fromState;
        }
        try {
            return RenderTypeTextureResolver.extractTextureViaReflection(renderType);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static boolean isDoubleSided(RenderType renderType) {
        try {
            RenderType.CompositeState state = RenderTypeTextureResolver.compositeState(renderType);
            if (state == null) {
                return false;
            }
            Field cullField = RenderType.CompositeState.class.getDeclaredField("cullState");
            cullField.setAccessible(true);
            Object cullState = cullField.get(state);
            if (cullState == null) {
                return false;
            }
            Class<?> booleanShard = cullState.getClass().getSuperclass();
            Field enabled = booleanShard.getDeclaredField("enabled");
            enabled.setAccessible(true);
            boolean cullEnabled = enabled.getBoolean(cullState);
            return !cullEnabled;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static ResourceLocation extractFromState(RenderType renderType) {
        try {
            Object t;
            Optional opt;
            RenderType.CompositeState state = RenderTypeTextureResolver.compositeState(renderType);
            if (state == null) {
                return null;
            }
            Field textureField = RenderType.CompositeState.class.getDeclaredField("textureState");
            textureField.setAccessible(true);
            Object textureState = textureField.get(state);
            if (textureState == null) {
                return null;
            }
            Method cutoutMethod = textureState.getClass().getDeclaredMethod("cutoutTexture", new Class[0]);
            cutoutMethod.setAccessible(true);
            Object result = cutoutMethod.invoke(textureState, new Object[0]);
            if (result instanceof Optional && (opt = (Optional)result).isPresent() && (t = opt.get()) instanceof ResourceLocation) {
                ResourceLocation loc = (ResourceLocation)t;
                return loc;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static RenderType.CompositeState compositeState(RenderType renderType) {
        try {
            Class<?> compositeRenderTypeClass = Class.forName("net.minecraft.client.renderer.RenderType$CompositeRenderType");
            if (!compositeRenderTypeClass.isInstance(renderType)) {
                return null;
            }
            Method stateMethod = compositeRenderTypeClass.getDeclaredMethod("state", new Class[0]);
            stateMethod.setAccessible(true);
            Object state = stateMethod.invoke((Object)renderType, new Object[0]);
            if (state instanceof RenderType.CompositeState) {
                RenderType.CompositeState compositeState = (RenderType.CompositeState)state;
                return compositeState;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    private static ResourceLocation extractTextureViaReflection(RenderType renderType) {
        try {
            int texIdx;
            String name = renderType.toString();
            if (name.contains("RenderType[") && (texIdx = name.indexOf("texture=")) >= 0) {
                int start = texIdx + 8;
                int end = name.indexOf(",", start);
                if (end < 0) {
                    end = name.indexOf("]", start);
                }
                if (end > start) {
                    String texStr = name.substring(start, end).trim();
                    return ResourceLocation.parse((String)texStr);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }
}

