/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.scene.gltf;

import com.voxelbridge.config.ExportRuntimeConfig;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.StreamingRegionSampler;
import com.voxelbridge.export.scene.SceneWriteRequest;
import com.voxelbridge.export.scene.gltf.GltfSceneBuilder;
import com.voxelbridge.export.texture.BlockEntityTextureManager;
import com.voxelbridge.export.texture.TextureAtlasManager;
import com.voxelbridge.util.BlockEntityDebugLogger;
import com.voxelbridge.util.ExportLogger;
import com.voxelbridge.util.UV3DebugLogger;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class GltfExportService {
    private GltfExportService() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Path exportRegion(Level level, BlockPos pos1, BlockPos pos2, Path outDir) throws IOException {
        String banner = "============================================================";
        System.out.println(banner);
        System.out.println("[VoxelBridge][GLTF] *** GLTF EXPORT STARTED ***");
        System.out.println(banner);
        if (!Files.exists(outDir, new LinkOption[0])) {
            Files.createDirectories(outDir, new FileAttribute[0]);
        }
        int minX = Math.min(pos1.getX(), pos2.getX());
        int minY = Math.min(pos1.getY(), pos2.getY());
        int minZ = Math.min(pos1.getZ(), pos2.getZ());
        int maxX = Math.max(pos1.getX(), pos2.getX());
        int maxY = Math.max(pos1.getY(), pos2.getY());
        int maxZ = Math.max(pos1.getZ(), pos2.getZ());
        String baseName = String.format("region_%d_%d_%d__%d_%d_%d", minX, minY, minZ, maxX, maxY, maxZ);
        Path gltfDir = outDir.resolve("gltf");
        if (!Files.exists(gltfDir, new LinkOption[0])) {
            Files.createDirectories(gltfDir, new FileAttribute[0]);
        }
        System.out.println("[VoxelBridge][GLTF] Output directory: " + String.valueOf(gltfDir));
        System.out.printf("[VoxelBridge][GLTF] Region: X[%d to %d], Y[%d to %d], Z[%d to %d]%n", minX, maxX, minY, maxY, minZ, maxZ);
        Minecraft mc = Minecraft.getInstance();
        ExportContext ctx = new ExportContext(mc);
        ctx.resetConsumedBlocks();
        ctx.setBlockEntityExportEnabled(true);
        ctx.setCoordinateMode(ExportRuntimeConfig.getCoordinateMode());
        ExportLogger.initialize(outDir);
        ExportLogger.log("[GLTF] Starting glTF export with format-agnostic sampler");
        BlockEntityDebugLogger.initialize(outDir);
        UV3DebugLogger.initialize(outDir);
        BlockEntityTextureManager.clear();
        GltfSceneBuilder sceneSink = new GltfSceneBuilder(ctx, gltfDir);
        StreamingRegionSampler.sampleRegion(level, pos1, pos2, sceneSink, ctx);
        SceneWriteRequest request = new SceneWriteRequest(baseName, gltfDir);
        if (ExportRuntimeConfig.getAtlasMode() == ExportRuntimeConfig.AtlasMode.ATLAS) {
            TextureAtlasManager.generateAllAtlases(ctx, gltfDir);
        }
        BlockEntityTextureManager.exportTextures(ctx, gltfDir);
        if (ExportRuntimeConfig.getAtlasMode() == ExportRuntimeConfig.AtlasMode.ATLAS) {
            ExportLogger.log("[GLTF] Packing BlockEntity textures into atlas");
            BlockEntityTextureManager.packIntoAtlas(ctx, gltfDir);
        }
        try {
            Path output = sceneSink.write(request);
            ExportLogger.log("[GLTF] Export complete: " + String.valueOf(output));
            System.out.println(banner);
            System.out.println("[VoxelBridge][GLTF] *** EXPORT COMPLETED SUCCESSFULLY ***");
            System.out.println("[VoxelBridge][GLTF] Output: " + String.valueOf(output));
            System.out.println(banner);
            Path path = output;
            return path;
        }
        finally {
            UV3DebugLogger.close();
            BlockEntityDebugLogger.close();
            ExportLogger.close();
        }
    }
}

