/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.texture;

import com.voxelbridge.config.ExportRuntimeConfig;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.exporter.blockentity.BlockEntityTextureResolver;
import com.voxelbridge.export.scene.gltf.BlockEntityAtlasPacker;
import com.voxelbridge.export.texture.EntityTextureManager;
import com.voxelbridge.export.texture.TextureLoader;
import com.voxelbridge.util.ExportLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BlockEntityTextureManager {
    private static final Map<ResourceLocation, BufferedImage> textureCache = new ConcurrentHashMap<ResourceLocation, BufferedImage>();
    private static final Map<String, ResourceLocation> registeredTextures = new ConcurrentHashMap<String, ResourceLocation>();

    private BlockEntityTextureManager() {
    }

    public static String registerGenerated(ExportContext ctx, EntityTextureManager.TextureHandle handle, BufferedImage image) {
        Object spriteKey = handle.spriteKey().startsWith("blockentity:") ? handle.spriteKey() : "blockentity:" + handle.spriteKey();
        ResourceLocation loc = handle.textureLocation();
        textureCache.put(loc, image);
        registeredTextures.put((String)spriteKey, loc);
        ctx.getGeneratedEntityTextures().put((String)spriteKey, image);
        ctx.getMaterialPaths().putIfAbsent((String)spriteKey, handle.relativePath());
        ctx.getEntityTextures().putIfAbsent((String)spriteKey, new ExportContext.EntityTexture(loc, image.getWidth(), image.getHeight()));
        ExportLogger.log("[BlockEntityTex] Registered generated texture: " + (String)spriteKey + " -> " + String.valueOf(loc));
        return spriteKey;
    }

    public static String registerTexture(ExportContext ctx, BlockEntityTextureResolver.ResolvedTexture textureRes) {
        ResourceLocation textureLoc = textureRes.texture();
        String spriteKey = "entity:" + textureLoc.getNamespace() + "/" + textureLoc.getPath();
        ExportLogger.log("[BlockEntityTex] Registering texture: " + spriteKey + " from " + String.valueOf(textureLoc));
        ResourceLocation pngLocation = BlockEntityTextureManager.ensurePngLocation(textureLoc);
        BufferedImage texture = textureCache.computeIfAbsent(pngLocation, loc -> {
            BufferedImage img = BlockEntityTextureManager.loadTextureFromResolved(textureRes, loc);
            if (img != null) {
                ExportLogger.log("[BlockEntityTex] Loaded texture: " + String.valueOf(loc) + " (" + img.getWidth() + "x" + img.getHeight() + ")");
            } else {
                ExportLogger.log("[BlockEntityTex] Failed to load texture: " + String.valueOf(loc));
            }
            return img;
        });
        if (texture != null) {
            registeredTextures.put(spriteKey, pngLocation);
            String relativePath = ctx.getMaterialPaths().computeIfAbsent(spriteKey, k -> "entity_textures/" + BlockEntityTextureManager.safe(textureLoc.toString()) + ".png");
            ctx.getEntityTextures().computeIfAbsent(spriteKey, k -> new ExportContext.EntityTexture(pngLocation, texture.getWidth(), texture.getHeight()));
            ExportLogger.log("[BlockEntityTex] Registered: " + spriteKey + " -> " + relativePath);
        }
        return spriteKey;
    }

    public static BufferedImage getTexture(ResourceLocation location) {
        return textureCache.get(location);
    }

    public static boolean hasTexture(ResourceLocation location) {
        return textureCache.containsKey(location);
    }

    public static ResourceLocation getRegisteredLocation(String spriteKey) {
        return registeredTextures.get(spriteKey);
    }

    public static String getTextureFilename(String spriteKey) {
        return "textures/blockentity/" + BlockEntityTextureManager.safe(spriteKey) + ".png";
    }

    public static void exportTextures(ExportContext ctx, Path outDir) throws IOException {
        if (registeredTextures.isEmpty()) {
            return;
        }
        ExportLogger.log("[BlockEntityTex] Exporting " + registeredTextures.size() + " textures");
        for (Map.Entry<String, ResourceLocation> entry : registeredTextures.entrySet()) {
            String spriteKey = entry.getKey();
            ResourceLocation pngLocation = entry.getValue();
            String relativePath = ctx.getMaterialPaths().get(spriteKey);
            if (relativePath == null) {
                ExportLogger.log("[BlockEntityTex][WARN] No relative path for: " + spriteKey);
                continue;
            }
            Path target = outDir.resolve(relativePath);
            if (Files.exists(target, new LinkOption[0])) {
                ExportLogger.log("[BlockEntityTex] Already exists: " + String.valueOf(target));
                continue;
            }
            BufferedImage img = textureCache.get(pngLocation);
            if (img != null) {
                Files.createDirectories(target.getParent(), new FileAttribute[0]);
                ImageIO.write((RenderedImage)img, "png", target.toFile());
                ExportLogger.log("[BlockEntityTex] Exported: " + String.valueOf(target));
                continue;
            }
            try {
                Optional resource = Minecraft.getInstance().getResourceManager().getResource(pngLocation);
                if (resource.isPresent()) {
                    Files.createDirectories(target.getParent(), new FileAttribute[0]);
                    try (InputStream in = ((Resource)resource.get()).open();){
                        Files.copy(in, target, new CopyOption[0]);
                    }
                    ExportLogger.log("[BlockEntityTex] Copied from resources: " + String.valueOf(target));
                    continue;
                }
                ExportLogger.log("[BlockEntityTex][WARN] Texture not found: " + String.valueOf(pngLocation));
            }
            catch (Exception e) {
                ExportLogger.log("[BlockEntityTex][ERROR] Failed to export " + spriteKey + ": " + e.getMessage());
            }
        }
    }

    private static BufferedImage loadTextureFromResource(ResourceLocation location) {
        try {
            ExportLogger.log("[BlockEntityTex] Trying to load: " + String.valueOf(location));
            return TextureLoader.readTexture(location);
        }
        catch (Exception e) {
            ExportLogger.log("[BlockEntityTex] Error loading texture " + String.valueOf(location) + ": " + e.getMessage());
            return null;
        }
    }

    private static BufferedImage loadTextureFromResolved(BlockEntityTextureResolver.ResolvedTexture textureRes, ResourceLocation location) {
        TextureAtlasSprite sprite;
        if (textureRes.isAtlasTexture() && (sprite = textureRes.sprite()) != null) {
            ExportLogger.log("[BlockEntityTex] Loading atlas sprite " + String.valueOf(sprite.contents().name()) + " from atlas " + String.valueOf(sprite.atlasLocation()));
            return BlockEntityTextureManager.loadAtlasSprite(sprite);
        }
        return BlockEntityTextureManager.loadTextureFromResource(location);
    }

    private static BufferedImage loadAtlasSprite(TextureAtlasSprite sprite) {
        try {
            return TextureLoader.fromSprite(sprite);
        }
        catch (Exception e) {
            ExportLogger.log("[BlockEntityTex] Error loading atlas sprite " + String.valueOf(sprite.contents().name()) + ": " + e.getMessage());
            return null;
        }
    }

    private static ResourceLocation ensurePngLocation(ResourceLocation location) {
        Object path = location.getPath();
        if (((String)path).endsWith(".png")) {
            return location;
        }
        if (!((String)path).startsWith("textures/")) {
            path = "textures/" + (String)path;
        }
        path = (String)path + ".png";
        String namespace = location.getNamespace();
        return ResourceLocation.fromNamespaceAndPath((String)(namespace != null ? namespace : "minecraft"), (String)path);
    }

    public static void packIntoAtlas(ExportContext ctx, Path outDir) throws IOException {
        if (registeredTextures.isEmpty()) {
            ExportLogger.log("[BlockEntityTex] No textures to pack into atlas");
            return;
        }
        ExportLogger.log("[BlockEntityTex] Packing " + registeredTextures.size() + " textures into atlas");
        int atlasSize = ExportRuntimeConfig.getAtlasSize().getSize();
        BlockEntityAtlasPacker packer = new BlockEntityAtlasPacker(atlasSize, false);
        for (Map.Entry<String, ResourceLocation> entry : registeredTextures.entrySet()) {
            String spriteKey = entry.getKey();
            ResourceLocation pngLocation = entry.getValue();
            BufferedImage image = textureCache.get(pngLocation);
            if (image == null) {
                ExportLogger.log("[BlockEntityTex][WARN] Texture not in cache: " + spriteKey);
                continue;
            }
            packer.addTexture(spriteKey, image);
            ExportLogger.log("[BlockEntityTex] Added to packer: " + spriteKey + " (" + image.getWidth() + "x" + image.getHeight() + ")");
        }
        Path atlasDir = outDir.resolve("textures/blockentity_atlas");
        Files.createDirectories(atlasDir, new FileAttribute[0]);
        Map<String, BlockEntityAtlasPacker.Placement> placements = packer.pack(atlasDir, "blockentity_atlas_");
        for (Map.Entry<String, BlockEntityAtlasPacker.Placement> entry : placements.entrySet()) {
            String spriteKey = entry.getKey();
            BlockEntityAtlasPacker.Placement p = entry.getValue();
            ExportContext.BlockEntityAtlasPlacement placement = new ExportContext.BlockEntityAtlasPlacement(p.page(), p.udim(), p.x(), p.y(), p.width(), p.height(), atlasSize);
            ctx.getBlockEntityAtlasPlacements().put(spriteKey, placement);
            String atlasPath = "textures/blockentity_atlas/blockentity_atlas_" + p.udim() + ".png";
            ctx.getMaterialPaths().put(spriteKey, atlasPath);
            ExportLogger.log(String.format("[BlockEntityTex] Placed %s in atlas page %d at (%d,%d) size (%dx%d) -> %s", spriteKey, p.page(), p.x(), p.y(), p.width(), p.height(), atlasPath));
        }
        ExportLogger.log("[BlockEntityTex] Atlas packing complete, " + placements.size() + " textures packed");
    }

    public static void clear() {
        textureCache.clear();
        registeredTextures.clear();
    }

    private static String safe(String s) {
        return s.replace(':', '_').replace('/', '_');
    }
}

