/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.voxelbridge.export.ExportContext;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import java.util.Optional;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class EntityTextureManager {
    private static final int DEFAULT_TEX_SIZE = 16;

    private EntityTextureManager() {
    }

    public static TextureHandle register(ExportContext ctx, ResourceLocation texture) {
        String key = "entity:" + String.valueOf(texture);
        String materialName = ctx.getMaterialNameForSprite(key);
        String relativePath = ctx.getMaterialPaths().computeIfAbsent(key, k -> "entity_textures/" + EntityTextureManager.safe(texture.toString()) + ".png");
        ctx.getEntityTextures().computeIfAbsent(key, k -> EntityTextureManager.loadTextureInfo(ctx, texture));
        return new TextureHandle(key, materialName, relativePath, texture);
    }

    public static void dumpAll(ExportContext ctx, Path outDir) throws IOException {
        Minecraft mc = ctx.getMc();
        System.out.println("[EntityTextureManager] Dumping " + ctx.getEntityTextures().size() + " entity textures");
        System.out.println("[EntityTextureManager] Generated textures: " + ctx.getGeneratedEntityTextures().size());
        System.out.println("[EntityTextureManager] Generated texture keys:");
        for (String key : ctx.getGeneratedEntityTextures().keySet()) {
            System.out.println("[EntityTextureManager]   - " + key);
        }
        EntityTextureManager.writeGeneratedTextures(ctx, outDir);
        Map<String, BufferedImage> generated = ctx.getGeneratedEntityTextures();
        for (Map.Entry<String, ExportContext.EntityTexture> entry : ctx.getEntityTextures().entrySet()) {
            Optional resource;
            String spriteKey = entry.getKey();
            ExportContext.EntityTexture texture = entry.getValue();
            String relativePath = ctx.getMaterialPaths().get(spriteKey);
            if (spriteKey.contains("banner") || spriteKey.contains("base")) {
                System.out.println("[EntityTextureManager] Processing: " + spriteKey);
                System.out.println("[EntityTextureManager]   relativePath: " + relativePath);
                System.out.println("[EntityTextureManager]   has generated: " + generated.containsKey(spriteKey));
            }
            if (generated.containsKey(spriteKey)) continue;
            if (relativePath == null) {
                if (!spriteKey.contains("banner") && !spriteKey.contains("base")) continue;
                System.out.println("[EntityTextureManager]   SKIPPED: relativePath is null");
                continue;
            }
            Path target = outDir.resolve(relativePath);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            BufferedImage generatedImage = generated.get(spriteKey);
            if (generatedImage != null) {
                ImageIO.write((RenderedImage)generatedImage, "png", target.toFile());
                if (!spriteKey.contains("banner") && !spriteKey.contains("base")) continue;
                System.out.println("[EntityTextureManager]   SAVED generated image to: " + String.valueOf(target));
                continue;
            }
            if (Files.exists(target, new LinkOption[0]) || (resource = mc.getResourceManager().getResource(EntityTextureManager.resolveTexturePath(texture.location()))).isEmpty()) continue;
            Resource res = (Resource)resource.get();
            InputStream in = res.open();
            try {
                Files.copy(in, target, new CopyOption[0]);
            }
            finally {
                if (in == null) continue;
                in.close();
            }
        }
    }

    private static void writeGeneratedTextures(ExportContext ctx, Path outDir) throws IOException {
        for (Map.Entry<String, BufferedImage> entry : ctx.getGeneratedEntityTextures().entrySet()) {
            String spriteKey = entry.getKey();
            BufferedImage image = entry.getValue();
            if (image == null) continue;
            String relativePath = ctx.getMaterialPaths().computeIfAbsent(spriteKey, k -> "entity_textures/generated/" + EntityTextureManager.safe(spriteKey) + ".png");
            Path target = outDir.resolve(relativePath);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            ImageIO.write((RenderedImage)image, "png", target.toFile());
            ctx.getEntityTextures().computeIfAbsent(spriteKey, k -> new ExportContext.EntityTexture(EntityTextureManager.generatedLocation(spriteKey), image.getWidth(), image.getHeight()));
            if (!spriteKey.contains("banner") && !spriteKey.contains("base")) continue;
            System.out.println("[EntityTextureManager] Processing (generated cache): " + spriteKey);
            System.out.println("[EntityTextureManager]   relativePath: " + relativePath);
            System.out.println("[EntityTextureManager]   SAVED generated image to: " + String.valueOf(target));
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private static ExportContext.EntityTexture loadTextureInfo(ExportContext ctx, ResourceLocation texture) {
        Minecraft mc = ctx.getMc();
        try {
            Optional resource = mc.getResourceManager().getResource(EntityTextureManager.resolveTexturePath(texture));
            if (resource.isEmpty()) {
                return new ExportContext.EntityTexture(texture, 16, 16);
            }
            Resource res = (Resource)resource.get();
            try (InputStream in = res.open();){
                ExportContext.EntityTexture entityTexture;
                block15: {
                    NativeImage img = NativeImage.read((InputStream)in);
                    try {
                        entityTexture = new ExportContext.EntityTexture(texture, img.getWidth(), img.getHeight());
                        if (img == null) break block15;
                    }
                    catch (Throwable throwable) {
                        if (img != null) {
                            try {
                                img.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    img.close();
                }
                return entityTexture;
            }
        }
        catch (IOException e) {
            System.err.printf("[VoxelBridge][WARN] Failed to read entity texture %s: %s%n", texture, e.getMessage());
            return new ExportContext.EntityTexture(texture, 16, 16);
        }
    }

    private static ResourceLocation resolveTexturePath(ResourceLocation texture) {
        Object path = texture.getPath();
        if (!((String)path).startsWith("textures/")) {
            path = "textures/" + (String)path;
        }
        if (!((String)path).endsWith(".png")) {
            path = (String)path + ".png";
        }
        return ResourceLocation.fromNamespaceAndPath((String)texture.getNamespace(), (String)path);
    }

    public static TextureHandle registerGenerated(ExportContext ctx, String key, String relativePath, BufferedImage image) {
        ResourceLocation generatedLoc = EntityTextureManager.generatedLocation(key);
        ctx.getGeneratedEntityTextures().putIfAbsent(key, image);
        ctx.getMaterialPaths().putIfAbsent(key, relativePath);
        ctx.getEntityTextures().putIfAbsent(key, new ExportContext.EntityTexture(generatedLoc, image.getWidth(), image.getHeight()));
        String materialName = ctx.getMaterialNameForSprite(key);
        return new TextureHandle(key, materialName, relativePath, generatedLoc);
    }

    private static ResourceLocation generatedLocation(String key) {
        return ResourceLocation.fromNamespaceAndPath((String)"voxelbridge", (String)("generated/" + EntityTextureManager.safe(key)));
    }

    private static String safe(String s) {
        StringBuilder sb = new StringBuilder(s.length());
        for (int i = 0; i < s.length(); ++i) {
            char c = Character.toLowerCase(s.charAt(i));
            if (c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '.' || c == '-' || c == '_') {
                sb.append(c);
                continue;
            }
            sb.append('_');
        }
        return sb.toString();
    }

    public record TextureHandle(String spriteKey, String materialName, String relativePath, ResourceLocation textureLocation) {
    }
}

