/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.texture;

import net.minecraft.client.renderer.texture.SpriteContents;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class SpriteKeyResolver {
    private SpriteKeyResolver() {
    }

    public static String resolve(TextureAtlasSprite sprite) {
        try {
            SpriteContents contents = sprite.contents();
            ResourceLocation name = (ResourceLocation)contents.getClass().getMethod("name", new Class[0]).invoke((Object)contents, new Object[0]);
            return name.toString();
        }
        catch (Throwable ignore) {
            try {
                ResourceLocation name = (ResourceLocation)sprite.getClass().getMethod("getName", new Class[0]).invoke((Object)sprite, new Object[0]);
                return name.toString();
            }
            catch (Throwable t) {
                return "minecraft:block/unknown";
            }
        }
    }
}

