/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.texture;

import com.voxelbridge.config.ExportRuntimeConfig;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.scene.gltf.BlockEntityAtlasPacker;
import com.voxelbridge.export.texture.TextureLoader;
import com.voxelbridge.util.ExportLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TextureAtlasManager {
    private static final int MAX_TINT_SLOTS = 4096;
    private static final int DEFAULT_TINT = 0xFFFFFF;

    private TextureAtlasManager() {
    }

    public static void registerTint(ExportContext ctx, String spriteKey, int tint) {
        ExportContext.TintAtlas atlas = ctx.getOrCreateTintAtlas(spriteKey);
        int normalized = TextureAtlasManager.sanitizeTintValue(tint);
        atlas.tintToIndex.computeIfAbsent(normalized, key -> {
            int slot = TextureAtlasManager.reserveTintSlot(atlas, key);
            int totalSlots = Math.max(1, Math.min(4096, atlas.nextIndex.get()));
            ExportLogger.log(String.format("[Tint] sprite=%s tint=%06X slot=%d totalSlots=%d", spriteKey, normalized, slot, totalSlots));
            return slot;
        });
    }

    public static int getTintIndex(ExportContext ctx, String spriteKey, int tint) {
        ExportContext.TintAtlas atlas = ctx.getAtlasBook().computeIfAbsent(spriteKey, k -> new ExportContext.TintAtlas());
        int normalized = TextureAtlasManager.sanitizeTintValue(tint);
        if (!atlas.tintToIndex.containsKey(normalized)) {
            TextureAtlasManager.registerTint(ctx, spriteKey, tint);
        }
        return atlas.tintToIndex.getOrDefault(normalized, 0);
    }

    public static boolean hasMultipleTints(ExportContext ctx, String spriteKey) {
        ExportContext.TintAtlas atlas = ctx.getAtlasBook().get(spriteKey);
        if (atlas == null) {
            return false;
        }
        return atlas.nextIndex.get() > 1;
    }

    public static void generateAllAtlases(ExportContext ctx, Path outDir) throws IOException {
        Path texRoot = outDir.resolve("textures");
        Files.createDirectories(texRoot, new FileAttribute[0]);
        ExportRuntimeConfig.AtlasMode atlasMode = ExportRuntimeConfig.getAtlasMode();
        System.out.println("[TextureAtlasManager] Generating atlases (mode=" + String.valueOf((Object)atlasMode) + ")...");
        LinkedHashMap<String, ExportContext.TintAtlas> blockEntries = new LinkedHashMap<String, ExportContext.TintAtlas>();
        ctx.getAtlasBook().forEach((key, atlas) -> {
            if (!TextureAtlasManager.isBlockEntitySprite(key)) {
                blockEntries.put((String)key, (ExportContext.TintAtlas)atlas);
            }
        });
        if (atlasMode == ExportRuntimeConfig.AtlasMode.INDIVIDUAL) {
            TextureAtlasManager.generateIndividualTextures(ctx, outDir, blockEntries, "textures/individual/");
            return;
        }
        TextureAtlasManager.generatePackedAtlas(ctx, outDir, blockEntries, "textures/atlas", "atlas_");
    }

    private static void generateIndividualTextures(ExportContext ctx, Path outDir, Map<String, ExportContext.TintAtlas> entries, String subDir) throws IOException {
        if (entries.isEmpty()) {
            return;
        }
        for (Map.Entry<String, ExportContext.TintAtlas> entry : entries.entrySet()) {
            String spriteKey = entry.getKey();
            ExportContext.TintAtlas atlas = entry.getValue();
            atlas.placements.clear();
            if (atlas.tintToIndex.isEmpty()) {
                TextureAtlasManager.registerTint(ctx, spriteKey, 0xFFFFFF);
            }
            int tintSlots = Math.max(1, Math.min(4096, atlas.nextIndex.get()));
            int[] tintBySlot = TextureAtlasManager.resolveTintSlots(atlas, tintSlots);
            BufferedImage base = TextureAtlasManager.loadTextureForAtlas(ctx, spriteKey);
            if (base == null) {
                ExportLogger.log(String.format("[AtlasGen][WARN] sprite=%s missing texture, using placeholder", spriteKey));
                base = TextureAtlasManager.createMissingTexture();
            }
            BufferedImage outputImage = TextureAtlasManager.tintTile(base, tintBySlot[0]);
            String relativePath = subDir + TextureAtlasManager.safe(spriteKey) + ".png";
            Path target = outDir.resolve(relativePath);
            Files.createDirectories(target.getParent(), new FileAttribute[0]);
            ImageIO.write((RenderedImage)outputImage, "png", target.toFile());
            atlas.atlasFile = target;
            atlas.texW = outputImage.getWidth();
            atlas.texH = outputImage.getHeight();
            atlas.usesAtlas = false;
            atlas.cols = 1;
            atlas.placements.clear();
            ctx.getMaterialPaths().put(spriteKey, relativePath);
            ExportLogger.log(String.format("[AtlasGen] sprite=%s mode=individual path=%s", spriteKey, relativePath));
        }
    }

    /*
     * WARNING - void declaration
     */
    private static void generatePackedAtlas(ExportContext ctx, Path outDir, Map<String, ExportContext.TintAtlas> entries, String atlasDirName, String atlasPrefix) throws IOException {
        if (entries.isEmpty()) {
            return;
        }
        ArrayList<AtlasRequest> requests = new ArrayList<AtlasRequest>();
        HashMap<Integer, CallSite> pagePathMap = new HashMap<Integer, CallSite>();
        LinkedHashMap<CallSite, AtlasRequest> requestByKey = new LinkedHashMap<CallSite, AtlasRequest>();
        for (Map.Entry<String, ExportContext.TintAtlas> entry : entries.entrySet()) {
            String spriteKey = entry.getKey();
            ExportContext.TintAtlas atlas = entry.getValue();
            atlas.placements.clear();
            if (atlas.tintToIndex.isEmpty()) {
                TextureAtlasManager.registerTint(ctx, spriteKey, 0xFFFFFF);
            }
            int tintSlots = Math.max(1, Math.min(4096, atlas.nextIndex.get()));
            int[] tintBySlot = TextureAtlasManager.resolveTintSlots(atlas, tintSlots);
            BufferedImage bufferedImage = TextureAtlasManager.loadTextureForAtlas(ctx, spriteKey);
            if (bufferedImage == null) {
                ExportLogger.log(String.format("[AtlasGen][WARN] sprite=%s missing texture, using placeholder", spriteKey));
                BufferedImage bufferedImage2 = TextureAtlasManager.createMissingTexture();
            }
            for (int i = 0; i < tintSlots; ++i) {
                void var14_18;
                BufferedImage tinted = TextureAtlasManager.tintTile((BufferedImage)var14_18, tintBySlot[i]);
                requests.add(new AtlasRequest(spriteKey, i, tinted));
            }
        }
        int atlasSize = ExportRuntimeConfig.getAtlasSize().getSize();
        BlockEntityAtlasPacker packer = new BlockEntityAtlasPacker(atlasSize, false);
        int counter = 0;
        for (AtlasRequest req : requests) {
            String key = req.spriteKey + "#t" + req.tintIndex + "#" + counter++;
            requestByKey.put((CallSite)((Object)key), req);
            packer.addTexture(key, req.image);
        }
        Path atlasDir = outDir.resolve(atlasDirName);
        Files.createDirectories(atlasDir, new FileAttribute[0]);
        Map<String, BlockEntityAtlasPacker.Placement> packed = packer.pack(atlasDir, atlasPrefix);
        for (Map.Entry<String, BlockEntityAtlasPacker.Placement> entry : packed.entrySet()) {
            String key = entry.getKey();
            AtlasRequest req = (AtlasRequest)requestByKey.get(key);
            if (req == null) continue;
            BlockEntityAtlasPacker.Placement p = entry.getValue();
            int tileU = p.page() % 10;
            int tileV = p.page() / 10;
            float u0 = (float)tileU + (float)p.x() / (float)atlasSize;
            float v0 = (float)(-tileV) + (float)p.y() / (float)atlasSize;
            float u1 = (float)tileU + (float)(p.x() + p.width()) / (float)atlasSize;
            float v1 = (float)(-tileV) + (float)(p.y() + p.height()) / (float)atlasSize;
            ExportContext.TintAtlas atlas = ctx.getAtlasBook().get(req.spriteKey);
            ExportContext.TexturePlacement placement = new ExportContext.TexturePlacement(p.page(), tileU, tileV, p.x(), p.y(), p.width(), p.height(), u0, v0, u1, v1, atlasDirName + "/" + atlasPrefix + p.udim() + ".png");
            atlas.placements.put(req.tintIndex, placement);
            atlas.usesAtlas = true;
            atlas.texW = atlasSize;
            atlas.texH = atlasSize;
            atlas.cols = 1;
            pagePathMap.putIfAbsent(p.page(), (CallSite)((Object)(atlasDirName + "/" + atlasPrefix + p.udim() + ".png")));
        }
        for (Map.Entry<String, Object> entry : entries.entrySet()) {
            ExportContext.TintAtlas atlas = (ExportContext.TintAtlas)entry.getValue();
            ExportContext.TexturePlacement placement = atlas.placements.getOrDefault(0, atlas.placements.values().stream().findFirst().orElse(null));
            if (placement == null) continue;
            String rel = placement.path() != null ? placement.path() : (String)((Object)pagePathMap.getOrDefault(placement.page(), (CallSite)((Object)(atlasDirName + "/" + atlasPrefix + "1001.png"))));
            ctx.getMaterialPaths().put(entry.getKey(), rel);
        }
    }

    public static float[] remapUV(ExportContext ctx, String spriteKey, int tint, float u, float v) {
        u = TextureAtlasManager.clamp01(u);
        v = TextureAtlasManager.clamp01(v);
        if (ExportRuntimeConfig.getAtlasMode() != ExportRuntimeConfig.AtlasMode.ATLAS) {
            return new float[]{u, v};
        }
        if (TextureAtlasManager.isBlockEntitySprite(spriteKey)) {
            return new float[]{u, v};
        }
        int normalizedTint = TextureAtlasManager.sanitizeTintValue(tint);
        int tintIndex = TextureAtlasManager.getTintIndex(ctx, spriteKey, normalizedTint);
        ExportContext.TintAtlas atlas = ctx.getAtlasBook().get(spriteKey);
        if (atlas == null || atlas.placements.isEmpty()) {
            return new float[]{u, v};
        }
        ExportContext.TexturePlacement placement = atlas.placements.getOrDefault(tintIndex, atlas.placements.get(0));
        if (placement == null) {
            placement = atlas.placements.values().stream().findFirst().orElse(null);
        }
        if (placement == null) {
            return new float[]{u, v};
        }
        float uu = placement.u0() + u * (placement.u1() - placement.u0());
        float vv = placement.v0() + v * (placement.v1() - placement.v0());
        return new float[]{uu, vv};
    }

    private static int sanitizeTintValue(int tint) {
        if (tint == -1) {
            return 0xFFFFFF;
        }
        return tint & 0xFFFFFF;
    }

    private static int reserveTintSlot(ExportContext.TintAtlas atlas, int tint) {
        int idx = atlas.nextIndex.get();
        if (idx < 4096) {
            atlas.indexToTint.put(idx, tint);
            atlas.nextIndex.incrementAndGet();
            return idx;
        }
        int bestIndex = 0;
        int bestDistance = Integer.MAX_VALUE;
        for (Map.Entry<Integer, Integer> entry : atlas.indexToTint.entrySet()) {
            int dist = TextureAtlasManager.colorDistance(entry.getValue(), tint);
            if (dist >= bestDistance) continue;
            bestDistance = dist;
            bestIndex = entry.getKey();
        }
        atlas.indexToTint.put(bestIndex, tint);
        return bestIndex;
    }

    private static int colorDistance(int a, int b) {
        int ar = a >> 16 & 0xFF;
        int ag = a >> 8 & 0xFF;
        int ab = a & 0xFF;
        int br = b >> 16 & 0xFF;
        int bg = b >> 8 & 0xFF;
        int bb = b & 0xFF;
        int dr = ar - br;
        int dg = ag - bg;
        int db = ab - bb;
        return dr * dr + dg * dg + db * db;
    }

    private static int[] resolveTintSlots(ExportContext.TintAtlas atlas, int tintSlots) {
        int[] result = new int[tintSlots];
        boolean[] filled = new boolean[tintSlots];
        atlas.indexToTint.forEach((index, tint) -> {
            if (index >= 0 && index < tintSlots && !filled[index]) {
                result[index.intValue()] = tint;
                filled[index.intValue()] = true;
            }
        });
        if (tintSlots > 0 && !filled[0]) {
            result[0] = 0xFFFFFF;
            filled[0] = true;
        }
        int last = tintSlots > 0 ? result[0] : 0xFFFFFF;
        for (int i = 1; i < tintSlots; ++i) {
            if (!filled[i]) {
                result[i] = last;
                continue;
            }
            last = result[i];
        }
        return result;
    }

    private static BufferedImage tintTile(BufferedImage tile, int tint) {
        float[] mul = TextureLoader.rgbMul(tint);
        BufferedImage dst = new BufferedImage(tile.getWidth(), tile.getHeight(), 2);
        for (int y = 0; y < tile.getHeight(); ++y) {
            for (int x = 0; x < tile.getWidth(); ++x) {
                int argb = tile.getRGB(x, y);
                int a = argb >>> 24 & 0xFF;
                int r = argb >>> 16 & 0xFF;
                int g = argb >>> 8 & 0xFF;
                int b = argb & 0xFF;
                int rr = Math.min(255, (int)((float)r * mul[0]));
                int gg = Math.min(255, (int)((float)g * mul[1]));
                int bb = Math.min(255, (int)((float)b * mul[2]));
                dst.setRGB(x, y, a << 24 | rr << 16 | gg << 8 | bb);
            }
        }
        return dst;
    }

    private static BufferedImage createMissingTexture() {
        BufferedImage img = new BufferedImage(16, 16, 2);
        for (int y = 0; y < 16; ++y) {
            for (int x = 0; x < 16; ++x) {
                boolean pink = (x / 4 + y / 4) % 2 == 0;
                img.setRGB(x, y, pink ? -65281 : -16777216);
            }
        }
        return img;
    }

    private static float clamp01(float x) {
        return x < 0.0f ? 0.0f : (x > 1.0f ? 1.0f : x);
    }

    private static String safe(String spriteKey) {
        return spriteKey.replace(':', '_').replace('/', '_');
    }

    private static boolean isBlockEntitySprite(String spriteKey) {
        return spriteKey != null && (spriteKey.startsWith("blockentity:") || spriteKey.startsWith("entity:"));
    }

    private static BufferedImage loadTextureForAtlas(ExportContext ctx, String spriteKey) {
        ResourceLocation textureLocation = TextureLoader.spriteKeyToTexturePNG(spriteKey);
        return TextureLoader.readTexture(textureLocation);
    }

    private record AtlasRequest(String spriteKey, int tintIndex, BufferedImage image) {
    }
}

