/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.texture;

import com.mojang.blaze3d.platform.NativeImage;
import com.voxelbridge.util.ExportLogger;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.InputStream;
import java.util.Optional;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.Resource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class TextureLoader {
    private TextureLoader() {
    }

    public static BufferedImage readTexture(ResourceLocation png) {
        BufferedImage bufferedImage;
        block10: {
            ExportLogger.log(String.format("[TextureLoader] Resolving %s", png));
            ResourceManager rm = Minecraft.getInstance().getResourceManager();
            Optional opt = rm.getResource(png);
            if (opt.isEmpty()) {
                ExportLogger.log(String.format("[TextureLoader][WARN] Missing resource %s", png));
                return null;
            }
            InputStream in = ((Resource)opt.get()).open();
            try {
                BufferedImage img = TextureLoader.readPngNoColorConversion(in);
                ExportLogger.log(String.format("[TextureLoader] Loaded %s (%dx%d)", png, img.getWidth(), img.getHeight()));
                BufferedImage firstFrame = TextureLoader.extractFirstFrame(img);
                if (firstFrame != img) {
                    ExportLogger.log(String.format("[TextureLoader] Extracted first frame for %s -> %dx%d", png, firstFrame.getWidth(), firstFrame.getHeight()));
                }
                bufferedImage = firstFrame;
                if (in == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Throwable t) {
                    ExportLogger.log(String.format("[TextureLoader][ERROR] Failed to read %s: %s", png, t));
                    System.err.println("[VoxelBridge][WARN] readTexture failed: " + String.valueOf(png) + " :: " + String.valueOf(t));
                    return null;
                }
            }
            in.close();
        }
        return bufferedImage;
    }

    private static BufferedImage readPngNoColorConversion(InputStream in) throws Exception {
        try (NativeImage nativeImg = NativeImage.read((InputStream)in);){
            BufferedImage bufferedImage = TextureLoader.nativeImageToBufferedImage(nativeImg);
            return bufferedImage;
        }
    }

    public static BufferedImage fromNativeImage(NativeImage nativeImg) {
        return TextureLoader.nativeImageToBufferedImage(nativeImg);
    }

    public static BufferedImage fromSprite(TextureAtlasSprite sprite) {
        if (sprite == null) {
            return null;
        }
        NativeImage nativeImg = sprite.contents().getOriginalImage();
        return TextureLoader.nativeImageToBufferedImage(nativeImg);
    }

    private static BufferedImage nativeImageToBufferedImage(NativeImage nativeImg) {
        int w = nativeImg.getWidth();
        int h = nativeImg.getHeight();
        BufferedImage out = new BufferedImage(w, h, 2);
        int[] row = new int[w];
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int c = nativeImg.getPixelRGBA(x, y);
                int a = c >>> 24 & 0xFF;
                int r = c & 0xFF;
                int g = c >>> 8 & 0xFF;
                int b = c >>> 16 & 0xFF;
                row[x] = a << 24 | r << 16 | g << 8 | b;
            }
            out.setRGB(0, y, w, 1, row, 0, w);
        }
        return out;
    }

    private static BufferedImage extractFirstFrame(BufferedImage img) {
        int width = img.getWidth();
        int height = img.getHeight();
        if (height <= width) {
            return img;
        }
        int frameSize = Math.min(width, height);
        try {
            return img.getSubimage(0, 0, frameSize, frameSize);
        }
        catch (Exception e) {
            System.err.println("[TextureLoader][WARN] Failed to extract first frame: " + String.valueOf(e));
            return img;
        }
    }

    private static BufferedImage resizeToTile(BufferedImage src) {
        if (src.getWidth() == 16 && src.getHeight() == 16) {
            return src;
        }
        BufferedImage resized = new BufferedImage(16, 16, 2);
        Graphics2D g = resized.createGraphics();
        g.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
        g.drawImage(src, 0, 0, 16, 16, null);
        g.dispose();
        return resized;
    }

    public static BufferedImage tintImage(BufferedImage src, float r, float g, float b) {
        int w = src.getWidth();
        int h = src.getHeight();
        BufferedImage dst = new BufferedImage(w, h, 2);
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int argb = src.getRGB(x, y);
                int a = argb >>> 24 & 0xFF;
                int rr = Math.min(255, (int)((float)(argb >>> 16 & 0xFF) * r));
                int gg = Math.min(255, (int)((float)(argb >>> 8 & 0xFF) * g));
                int bb = Math.min(255, (int)((float)(argb & 0xFF) * b));
                dst.setRGB(x, y, a << 24 | rr << 16 | gg << 8 | bb);
            }
        }
        return dst;
    }

    public static ResourceLocation spriteKeyToTexturePNG(String spriteKey) {
        int secondSep;
        String rawPath;
        int separator = spriteKey.indexOf(58);
        String namespace = separator > 0 ? spriteKey.substring(0, separator) : "minecraft";
        String string = rawPath = separator > 0 ? spriteKey.substring(separator + 1) : spriteKey;
        if (("blockentity".equals(namespace) || "entity".equals(namespace)) && (secondSep = rawPath.indexOf(47)) > 0) {
            String actualNamespace = rawPath.substring(0, secondSep);
            String actualPath = rawPath.substring(secondSep + 1);
            return ResourceLocation.fromNamespaceAndPath((String)actualNamespace, (String)TextureLoader.ensurePngExtension(actualPath));
        }
        String normalizedPath = TextureLoader.normalizeSpritePath(rawPath);
        normalizedPath = TextureLoader.sanitizePath(normalizedPath);
        String safeNamespace = TextureLoader.sanitizePath(namespace);
        return ResourceLocation.fromNamespaceAndPath((String)safeNamespace, (String)normalizedPath);
    }

    private static String normalizeSpritePath(String rawPath) {
        String path = rawPath.replace('\\', '/');
        String string = path = path.startsWith("/") ? path.substring(1) : path;
        if (path.startsWith("textures/")) {
            return TextureLoader.ensurePngExtension(path);
        }
        if (path.contains("/")) {
            return TextureLoader.ensurePngExtension("textures/" + path);
        }
        return TextureLoader.ensurePngExtension("textures/block/" + path);
    }

    private static String ensurePngExtension(String path) {
        return path.endsWith(".png") ? path : path + ".png";
    }

    private static String sanitizePath(String path) {
        StringBuilder sb = new StringBuilder(path.length());
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            boolean ok = c >= 'a' && c <= 'z' || c >= '0' && c <= '9' || c == '/' || c == '.' || c == '_' || c == '-';
            sb.append(ok ? c : (char)'_');
        }
        return sb.toString();
    }

    public static float[] rgbMul(int rgb) {
        return new float[]{(float)(rgb >> 16 & 0xFF) / 255.0f, (float)(rgb >> 8 & 0xFF) / 255.0f, (float)(rgb & 0xFF) / 255.0f};
    }
}

