/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.animation;

import de.javagl.jgltf.model.animation.Animation;
import de.javagl.jgltf.model.animation.AnimationManagerListener;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;

public final class AnimationManager {
    private final AnimationPolicy animationPolicy;
    private long startNs;
    private long currentNs;
    private final List<Animation> animations;
    private float maxEndTimeS;
    private final List<AnimationManagerListener> animationManagerListeners;

    public AnimationManager(AnimationPolicy animationPolicy) {
        this.animationPolicy = animationPolicy;
        this.currentNs = this.startNs = System.nanoTime();
        this.animations = new CopyOnWriteArrayList<Animation>();
        this.maxEndTimeS = 0.0f;
        this.animationManagerListeners = new CopyOnWriteArrayList<AnimationManagerListener>();
    }

    public void reset() {
        this.startNs = System.nanoTime();
        this.currentNs = System.nanoTime();
        this.performStep(0L);
    }

    float getCurrentTimeS() {
        long timeNs = this.currentNs - this.startNs;
        float timeS = (float)timeNs * 1.0E-9f;
        return timeS;
    }

    public void addAnimation(Animation animation) {
        Objects.requireNonNull(animation, "The animation may not be null");
        this.animations.add(animation);
        this.updateMaxEndTime();
    }

    public void addAnimations(Iterable<? extends Animation> animations) {
        for (Animation animation : animations) {
            this.addAnimation(animation);
        }
    }

    public void removeAnimation(Animation animation) {
        this.animations.remove(animation);
        this.updateMaxEndTime();
    }

    public void removeAnimations(Iterable<? extends Animation> animations) {
        for (Animation animation : animations) {
            this.removeAnimation(animation);
        }
    }

    public List<Animation> getAnimations() {
        return Collections.unmodifiableList(this.animations);
    }

    private void updateMaxEndTime() {
        this.maxEndTimeS = 0.0f;
        for (Animation animation : this.animations) {
            this.maxEndTimeS = Math.max(this.maxEndTimeS, animation.getEndTimeS());
        }
    }

    void performStep(long deltaNs) {
        this.currentNs += deltaNs;
        float currentTimeS = this.getCurrentTimeS();
        if (this.animationPolicy == AnimationPolicy.ONCE && currentTimeS > this.maxEndTimeS) {
            this.animations.clear();
            return;
        }
        for (Animation animation : this.animations) {
            if (this.animationPolicy == AnimationPolicy.LOOP) {
                float loopTimeS = currentTimeS % this.maxEndTimeS;
                animation.update(loopTimeS);
                continue;
            }
            if (this.animationPolicy == AnimationPolicy.PING_PONG) {
                float loopTimeS;
                int interval = (int)(currentTimeS / this.maxEndTimeS);
                float pingPongTimeS = loopTimeS = currentTimeS % this.maxEndTimeS;
                if ((interval & 1) != 0) {
                    pingPongTimeS = this.maxEndTimeS - loopTimeS;
                }
                animation.update(pingPongTimeS);
                continue;
            }
            animation.update(currentTimeS);
        }
        this.fireAnimationsUpdated();
    }

    public void addAnimationManagerListener(AnimationManagerListener listener) {
        this.animationManagerListeners.add(listener);
    }

    public void removeAnimationManagerListener(AnimationManagerListener listener) {
        this.animationManagerListeners.remove(listener);
    }

    private void fireAnimationsUpdated() {
        for (AnimationManagerListener listener : this.animationManagerListeners) {
            listener.animationsUpdated(this);
        }
    }

    public static enum AnimationPolicy {
        ONCE,
        PING_PONG,
        LOOP;

    }
}

