/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.impl;

import de.javagl.jgltf.model.CameraModel;
import de.javagl.jgltf.model.NodeModel;
import de.javagl.jgltf.model.Suppliers;
import de.javagl.jgltf.model.impl.AbstractNamedModelElement;
import java.util.Objects;
import java.util.function.BiFunction;
import java.util.function.DoubleSupplier;
import java.util.function.Function;
import java.util.function.Supplier;

public final class DefaultCameraModel
extends AbstractNamedModelElement
implements CameraModel {
    private String instanceName;
    private NodeModel nodeModel;
    private final Function<float[], float[]> viewMatrixComputer;
    private final BiFunction<float[], Float, float[]> projectionMatrixComputer;

    public DefaultCameraModel(Function<float[], float[]> viewMatrixComputer, BiFunction<float[], Float, float[]> projectionMatrixComputer) {
        this.viewMatrixComputer = Objects.requireNonNull(viewMatrixComputer, "The viewMatrixComputer may not be null");
        this.projectionMatrixComputer = Objects.requireNonNull(projectionMatrixComputer, "The projectionMatrixComputer may not be null");
    }

    public void setInstanceName(String instanceName) {
        this.instanceName = instanceName;
    }

    public void setNodeModel(NodeModel nodeModel) {
        this.nodeModel = nodeModel;
    }

    @Override
    public String getInstanceName() {
        return this.instanceName;
    }

    @Override
    public NodeModel getNodeModel() {
        return this.nodeModel;
    }

    @Override
    public float[] computeViewMatrix(float[] result) {
        return this.viewMatrixComputer.apply(result);
    }

    @Override
    public float[] computeProjectionMatrix(float[] result, Float aspectRatio) {
        return this.projectionMatrixComputer.apply(result, aspectRatio);
    }

    @Override
    public Supplier<float[]> createViewMatrixSupplier() {
        return Suppliers.createTransformSupplier(this, CameraModel::computeViewMatrix);
    }

    @Override
    public Supplier<float[]> createProjectionMatrixSupplier(DoubleSupplier aspectRatioSupplier) {
        return Suppliers.createTransformSupplier(this, (c, t) -> {
            Float aspectRatio = null;
            if (aspectRatioSupplier != null) {
                aspectRatio = Float.valueOf((float)aspectRatioSupplier.getAsDouble());
            }
            this.computeProjectionMatrix((float[])t, aspectRatio);
        });
    }
}

