/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io;

import de.javagl.jgltf.impl.v2.GlTF;
import de.javagl.jgltf.model.io.Buffers;
import de.javagl.jgltf.model.io.GltfAsset;
import de.javagl.jgltf.model.io.GltfReader;
import de.javagl.jgltf.model.io.GltfReferenceResolver;
import de.javagl.jgltf.model.io.IO;
import de.javagl.jgltf.model.io.JsonError;
import de.javagl.jgltf.model.io.RawGltfData;
import de.javagl.jgltf.model.io.RawGltfDataReader;
import de.javagl.jgltf.model.io.v1.GltfAssetV1;
import de.javagl.jgltf.model.io.v2.GltfAssetV2;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.function.Consumer;

public final class GltfAssetReader {
    private final GltfReader gltfReader = new GltfReader();
    private GltfAsset gltfAsset;

    public void setJsonErrorConsumer(Consumer<? super JsonError> jsonErrorConsumer) {
        this.gltfReader.setJsonErrorConsumer(jsonErrorConsumer);
    }

    public GltfAsset read(URI uri) throws IOException {
        try (InputStream inputStream = uri.toURL().openStream();){
            this.readWithoutReferences(inputStream);
            URI baseUri = IO.getParent(uri);
            GltfReferenceResolver.resolveAll(this.gltfAsset.getReferences(), baseUri);
            GltfAsset gltfAsset = this.gltfAsset;
            return gltfAsset;
        }
    }

    public GltfAsset readWithoutReferences(URI uri) throws IOException {
        try (InputStream inputStream = uri.toURL().openStream();){
            this.readWithoutReferences(inputStream);
            GltfAsset gltfAsset = this.gltfAsset;
            return gltfAsset;
        }
    }

    public GltfAsset readWithoutReferences(InputStream inputStream) throws IOException {
        block14: {
            RawGltfData rawGltfData = RawGltfDataReader.read(inputStream);
            ByteBuffer jsonData = rawGltfData.getJsonData();
            try (InputStream jsonInputStream = Buffers.createByteBufferInputStream(jsonData);){
                this.gltfReader.read(jsonInputStream);
                int majorVersion = this.gltfReader.getMajorVersion();
                if (majorVersion == 1) {
                    de.javagl.jgltf.impl.v1.GlTF gltfV1 = this.gltfReader.getAsGltfV1();
                    this.gltfAsset = new GltfAssetV1(gltfV1, rawGltfData.getBinaryData());
                    break block14;
                }
                if (majorVersion == 2) {
                    GlTF gltfV2 = this.gltfReader.getAsGltfV2();
                    this.gltfAsset = new GltfAssetV2(gltfV2, rawGltfData.getBinaryData());
                    break block14;
                }
                throw new IOException("Unsupported major version: " + majorVersion);
            }
        }
        return this.gltfAsset;
    }

    int getMajorVersion() {
        return this.gltfReader.getMajorVersion();
    }

    GltfAssetV1 getAsGltfAssetV1() {
        if (this.gltfAsset instanceof GltfAssetV1) {
            return (GltfAssetV1)this.gltfAsset;
        }
        return null;
    }

    GltfAssetV2 getAsGltfAssetV2() {
        if (this.gltfAsset instanceof GltfAssetV2) {
            return (GltfAssetV2)this.gltfAsset;
        }
        return null;
    }
}

