/*
 * Decompiled with CFR 0.152.
 */
package de.javagl.jgltf.model.io.v1;

import de.javagl.jgltf.impl.v1.GlTF;
import de.javagl.jgltf.model.io.GltfAsset;
import de.javagl.jgltf.model.io.GltfAssetWriter;
import de.javagl.jgltf.model.io.GltfWriter;
import de.javagl.jgltf.model.io.v1.BinaryAssetCreatorV1;
import de.javagl.jgltf.model.io.v1.DefaultAssetCreatorV1;
import de.javagl.jgltf.model.io.v1.EmbeddedAssetCreatorV1;
import de.javagl.jgltf.model.io.v1.GltfAssetV1;
import de.javagl.jgltf.model.io.v1.GltfAssetWriterV1;
import de.javagl.jgltf.model.v1.GltfModelV1;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class GltfModelWriterV1 {
    public void write(GltfModelV1 gltfModel, File file) throws IOException {
        DefaultAssetCreatorV1 assetCreator = new DefaultAssetCreatorV1();
        GltfAssetV1 gltfAsset = assetCreator.create(gltfModel);
        GltfAssetWriter gltfAssetWriter = new GltfAssetWriter();
        gltfAssetWriter.write((GltfAsset)gltfAsset, file);
    }

    public void writeBinary(GltfModelV1 gltfModel, File file) throws IOException {
        try (FileOutputStream outputStream = new FileOutputStream(file);){
            this.writeBinary(gltfModel, outputStream);
        }
    }

    public void writeBinary(GltfModelV1 gltfModel, OutputStream outputStream) throws IOException {
        BinaryAssetCreatorV1 assetCreator = new BinaryAssetCreatorV1();
        GltfAssetV1 gltfAsset = assetCreator.create(gltfModel);
        GltfAssetWriterV1 gltfAssetWriter = new GltfAssetWriterV1();
        gltfAssetWriter.writeBinary(gltfAsset, outputStream);
    }

    public void writeEmbedded(GltfModelV1 gltfModel, OutputStream outputStream) throws IOException {
        EmbeddedAssetCreatorV1 assetCreator = new EmbeddedAssetCreatorV1();
        GltfAssetV1 gltfAsset = assetCreator.create(gltfModel);
        GltfWriter gltfWriter = new GltfWriter();
        GlTF gltf = gltfAsset.getGltf();
        gltfWriter.write(gltf, outputStream);
    }
}

