/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.client;

import com.voxelbridge.client.KeyBindings;
import com.voxelbridge.command.VoxelBridgeCommands;
import com.voxelbridge.export.ExportProgressTracker;
import com.voxelbridge.thread.ExportThread;
import com.voxelbridge.util.IOUtil;
import com.voxelbridge.util.RayCastUtil;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;

@EventBusSubscriber(modid="voxelbridge", bus=EventBusSubscriber.Bus.GAME, value={Dist.CLIENT})
public class KeyInputHandler {
    @SubscribeEvent
    public static void onClientTick(ClientTickEvent.Post event) {
        BlockPos hit;
        Minecraft mc = Minecraft.getInstance();
        if (mc.player == null || mc.level == null) {
            return;
        }
        if (KeyBindings.KEY_SET_POS1.consumeClick()) {
            hit = RayCastUtil.getLookingAt(mc, 20.0);
            if (hit == null) {
                mc.player.displayClientMessage((Component)Component.literal((String)"[VoxelBridge] No block targeted."), false);
            } else {
                VoxelBridgeCommands.setPos1(hit);
                ExportProgressTracker.previewSelection(hit, VoxelBridgeCommands.getPos2());
                mc.player.displayClientMessage((Component)Component.literal((String)("[VoxelBridge] pos1 set to " + String.valueOf(hit))), false);
            }
        }
        if (KeyBindings.KEY_SET_POS2.consumeClick()) {
            hit = RayCastUtil.getLookingAt(mc, 20.0);
            if (hit == null) {
                mc.player.displayClientMessage((Component)Component.literal((String)"[VoxelBridge] No block targeted."), false);
            } else {
                VoxelBridgeCommands.setPos2(hit);
                ExportProgressTracker.previewSelection(VoxelBridgeCommands.getPos1(), hit);
                mc.player.displayClientMessage((Component)Component.literal((String)("[VoxelBridge] pos2 set to " + String.valueOf(hit))), false);
            }
        }
        if (KeyBindings.KEY_CLEAR.consumeClick()) {
            VoxelBridgeCommands.clearSelection();
            mc.player.displayClientMessage((Component)Component.literal((String)"[VoxelBridge] Selection cleared."), false);
        }
        if (KeyBindings.KEY_EXPORT.consumeClick()) {
            BlockPos pos1 = VoxelBridgeCommands.getPos1();
            BlockPos pos2 = VoxelBridgeCommands.getPos2();
            if (pos1 == null || pos2 == null) {
                mc.player.displayClientMessage((Component)Component.literal((String)"[VoxelBridge] Please set pos1 and pos2 first (Numpad 7/9)."), false);
                return;
            }
            try {
                Path outDir = IOUtil.ensureExportDir();
                ExportThread exportThread = new ExportThread((Level)mc.level, pos1, pos2, outDir);
                mc.player.displayClientMessage((Component)Component.literal((String)"[VoxelBridge] Exporting to glTF..."), false);
                exportThread.start();
            }
            catch (Exception e) {
                e.printStackTrace();
                mc.player.displayClientMessage((Component)Component.literal((String)("[VoxelBridge] Export failed: " + e.getMessage())), false);
            }
        }
    }
}

