/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.voxelbridge.config.ExportRuntimeConfig;
import com.voxelbridge.export.CoordinateMode;
import com.voxelbridge.export.ExportProgressTracker;
import com.voxelbridge.thread.ExportThread;
import com.voxelbridge.util.IOUtil;
import com.voxelbridge.util.RayCastUtil;
import java.nio.file.Path;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.level.Level;
import net.neoforged.neoforge.client.event.RegisterClientCommandsEvent;

public final class VoxelBridgeCommands {
    private static BlockPos pos1;
    private static BlockPos pos2;

    private VoxelBridgeCommands() {
    }

    public static BlockPos getPos1() {
        return pos1;
    }

    public static BlockPos getPos2() {
        return pos2;
    }

    public static void setPos1(BlockPos pos) {
        pos1 = pos;
        ExportProgressTracker.previewSelection(pos1, pos2);
    }

    public static void setPos2(BlockPos pos) {
        pos2 = pos;
        ExportProgressTracker.previewSelection(pos1, pos2);
    }

    public static void clearSelection() {
        pos1 = null;
        pos2 = null;
        ExportProgressTracker.clear();
    }

    public static void register(RegisterClientCommandsEvent event) {
        LiteralArgumentBuilder root = Commands.literal((String)"voxelbridge");
        root.then(Commands.literal((String)"pos1").executes(ctx -> {
            Minecraft mc = Minecraft.getInstance();
            BlockPos hit = RayCastUtil.getLookingAt(mc, 20.0);
            if (hit == null) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"c[VoxelBridge] No block targeted."));
                return 0;
            }
            pos1 = hit;
            ExportProgressTracker.previewSelection(pos1, pos2);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("a[VoxelBridge] pos1 set to " + String.valueOf(pos1))));
            return 1;
        }));
        root.then(Commands.literal((String)"pos2").executes(ctx -> {
            Minecraft mc = Minecraft.getInstance();
            BlockPos hit = RayCastUtil.getLookingAt(mc, 20.0);
            if (hit == null) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"c[VoxelBridge] No block targeted."));
                return 0;
            }
            pos2 = hit;
            ExportProgressTracker.previewSelection(pos1, pos2);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("a[VoxelBridge] pos2 set to " + String.valueOf(pos2))));
            return 1;
        }));
        root.then(Commands.literal((String)"info").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"6[VoxelBridge] Selection info:"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("e  pos1: f" + String.valueOf(pos1 != null ? pos1 : "unset"))));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("e  pos2: f" + String.valueOf(pos2 != null ? pos2 : "unset"))));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("e  Atlas mode: f" + ExportRuntimeConfig.getAtlasMode().getDescription())));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("e  Atlas size: f" + ExportRuntimeConfig.getAtlasSize().getDescription())));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("e  Coordinate mode: f" + (ExportRuntimeConfig.getCoordinateMode() == CoordinateMode.CENTERED ? "centered" : "world"))));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("e  Export threads: f" + ExportRuntimeConfig.getExportThreadCount())));
            return 1;
        }));
        root.then(Commands.literal((String)"clear").executes(ctx -> {
            VoxelBridgeCommands.clearSelection();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"e[VoxelBridge] Selection cleared."));
            return 1;
        }));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"atlas").executes(ctx -> {
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("e[VoxelBridge] Current atlas mode: f" + ExportRuntimeConfig.getAtlasMode().getDescription())));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"7   individual: one texture per sprite"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"7   atlas: pack into 8192 UDIM tiles"));
            return 1;
        })).then(Commands.literal((String)"individual").executes(ctx -> {
            ExportRuntimeConfig.setAtlasMode(ExportRuntimeConfig.AtlasMode.INDIVIDUAL);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Atlas mode -> Individual textures"));
            return 1;
        }))).then(Commands.literal((String)"atlas").executes(ctx -> {
            ExportRuntimeConfig.setAtlasMode(ExportRuntimeConfig.AtlasMode.ATLAS);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Atlas mode -> Packed atlas (UDIM 8192)"));
            return 1;
        })));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"atlassize").executes(ctx -> {
            ExportRuntimeConfig.AtlasSize current = ExportRuntimeConfig.getAtlasSize();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("6[VoxelBridge] Current atlas size: f" + current.getDescription())));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"7   Available sizes:"));
            for (ExportRuntimeConfig.AtlasSize size : ExportRuntimeConfig.AtlasSize.values()) {
                String marker = size == current ? "a> " : "7  ";
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)(marker + size.getSize() + ": " + size.getDescription())));
            }
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"7   Usage: /voxelbridge atlassize <size>"));
            return 1;
        })).then(Commands.literal((String)"128").executes(ctx -> {
            ExportRuntimeConfig.setAtlasSize(ExportRuntimeConfig.AtlasSize.SIZE_128);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Atlas size -> 128x128"));
            return 1;
        }))).then(Commands.literal((String)"256").executes(ctx -> {
            ExportRuntimeConfig.setAtlasSize(ExportRuntimeConfig.AtlasSize.SIZE_256);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Atlas size -> 256x256"));
            return 1;
        }))).then(Commands.literal((String)"512").executes(ctx -> {
            ExportRuntimeConfig.setAtlasSize(ExportRuntimeConfig.AtlasSize.SIZE_512);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Atlas size -> 512x512"));
            return 1;
        }))).then(Commands.literal((String)"1024").executes(ctx -> {
            ExportRuntimeConfig.setAtlasSize(ExportRuntimeConfig.AtlasSize.SIZE_1024);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Atlas size -> 1024x1024"));
            return 1;
        }))).then(Commands.literal((String)"2048").executes(ctx -> {
            ExportRuntimeConfig.setAtlasSize(ExportRuntimeConfig.AtlasSize.SIZE_2048);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Atlas size -> 2048x2048"));
            return 1;
        }))).then(Commands.literal((String)"4096").executes(ctx -> {
            ExportRuntimeConfig.setAtlasSize(ExportRuntimeConfig.AtlasSize.SIZE_4096);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Atlas size -> 4096x4096"));
            return 1;
        }))).then(Commands.literal((String)"8192").executes(ctx -> {
            ExportRuntimeConfig.setAtlasSize(ExportRuntimeConfig.AtlasSize.SIZE_8192);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Atlas size -> 8192x8192"));
            return 1;
        })));
        root.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.literal((String)"coords").executes(ctx -> {
            String mode = ExportRuntimeConfig.getCoordinateMode() == CoordinateMode.CENTERED ? "centered" : "world";
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("6[VoxelBridge] Coordinate mode is currently f" + mode)));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"7   centered: model centered at origin (default)"));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"7   world: preserve original world coordinates"));
            return 1;
        })).then(Commands.literal((String)"centered").executes(ctx -> {
            ExportRuntimeConfig.setCoordinateMode(CoordinateMode.CENTERED);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Coordinate mode -> Centered (model at origin)"));
            return 1;
        }))).then(Commands.literal((String)"world").executes(ctx -> {
            ExportRuntimeConfig.setCoordinateMode(CoordinateMode.WORLD_ORIGIN);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Coordinate mode -> World (preserve coordinates)"));
            return 1;
        })));
        root.then(((LiteralArgumentBuilder)Commands.literal((String)"threads").executes(ctx -> {
            int threads = ExportRuntimeConfig.getExportThreadCount();
            int cpuCores = Runtime.getRuntime().availableProcessors();
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("6[VoxelBridge] Export thread count: f" + threads + "7 (CPU cores: " + cpuCores + ")")));
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"7   Usage: /voxelbridge threads <count> (1-32)"));
            return 1;
        })).then(Commands.argument((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1, (int)32)).executes(ctx -> {
            int count = IntegerArgumentType.getInteger((CommandContext)ctx, (String)"count");
            ExportRuntimeConfig.setExportThreadCount(count);
            ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("a[VoxelBridge] Export threads -> " + count)));
            return 1;
        })));
        root.then(Commands.literal((String)"export").executes(ctx -> {
            if (pos1 == null || pos2 == null) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"c[VoxelBridge] Please set pos1 and pos2 first."));
                return 0;
            }
            Minecraft mc = Minecraft.getInstance();
            ClientLevel level = mc.level;
            if (level == null) {
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"c[VoxelBridge] No world loaded."));
                return 0;
            }
            try {
                Path outDir = IOUtil.ensureExportDir();
                ExportThread exportThread = new ExportThread((Level)level, pos1, pos2, outDir);
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)"a[VoxelBridge] Exporting to glTF..."));
                exportThread.start();
                return 1;
            }
            catch (Exception e) {
                e.printStackTrace();
                ((CommandSourceStack)ctx.getSource()).sendSystemMessage((Component)Component.literal((String)("c[VoxelBridge] Export failed: " + e.getMessage())));
                return 0;
            }
        }));
        LiteralCommandNode rootNode = event.getDispatcher().register(root);
        event.getDispatcher().register((LiteralArgumentBuilder)Commands.literal((String)"vb").redirect((CommandNode)rootNode));
    }
}

