/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.config;

import com.voxelbridge.export.CoordinateMode;

public final class ExportRuntimeConfig {
    private static AtlasMode atlasMode = AtlasMode.ATLAS;
    private static AtlasSize atlasSize = AtlasSize.SIZE_8192;
    private static CoordinateMode coordinateMode = CoordinateMode.CENTERED;
    private static int exportThreadCount = Runtime.getRuntime().availableProcessors();

    private ExportRuntimeConfig() {
    }

    public static AtlasMode getAtlasMode() {
        return atlasMode;
    }

    public static void setAtlasMode(AtlasMode mode) {
        if (mode != null) {
            atlasMode = mode;
        }
    }

    public static AtlasSize getAtlasSize() {
        return atlasSize;
    }

    public static void setAtlasSize(AtlasSize size) {
        if (size != null) {
            atlasSize = size;
        }
    }

    public static CoordinateMode getCoordinateMode() {
        return coordinateMode;
    }

    public static void setCoordinateMode(CoordinateMode mode) {
        if (mode != null) {
            coordinateMode = mode;
        }
    }

    public static int getExportThreadCount() {
        return exportThreadCount;
    }

    public static void setExportThreadCount(int count) {
        exportThreadCount = count < 1 ? 1 : (count > 32 ? 32 : count);
    }

    public static enum AtlasMode {
        INDIVIDUAL("Individual textures (one file per sprite)"),
        ATLAS("Packed atlas (UDIM tiles)");

        private final String description;

        private AtlasMode(String description) {
            this.description = description;
        }

        public String getDescription() {
            return this.description;
        }
    }

    public static enum AtlasSize {
        SIZE_128(128, "128x128 (Tiny)"),
        SIZE_256(256, "256x256 (Small)"),
        SIZE_512(512, "512x512 (Medium)"),
        SIZE_1024(1024, "1024x1024 (Normal)"),
        SIZE_2048(2048, "2048x2048 (Large)"),
        SIZE_4096(4096, "4096x4096 (Very Large)"),
        SIZE_8192(8192, "8192x8192 (Maximum)");

        private final int size;
        private final String description;

        private AtlasSize(int size, String description) {
            this.size = size;
            this.description = description;
        }

        public int getSize() {
            return this.size;
        }

        public String getDescription() {
            return this.description;
        }

        public static AtlasSize fromSize(int size) {
            for (AtlasSize s : AtlasSize.values()) {
                if (s.size != size) continue;
                return s;
            }
            return SIZE_8192;
        }
    }
}

