/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter;

import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.voxelbridge.export.CoordinateMode;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.exporter.FluidExporter;
import com.voxelbridge.export.exporter.blockentity.BlockEntityExportResult;
import com.voxelbridge.export.exporter.blockentity.BlockEntityExporter;
import com.voxelbridge.export.scene.SceneSink;
import com.voxelbridge.export.texture.ColorMapManager;
import com.voxelbridge.export.texture.SpriteKeyResolver;
import com.voxelbridge.export.texture.TextureAtlasManager;
import com.voxelbridge.export.texture.TextureLoader;
import com.voxelbridge.modhandler.ModHandledQuads;
import com.voxelbridge.modhandler.ModHandlerRegistry;
import java.awt.image.BufferedImage;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.fabricmc.fabric.api.renderer.v1.Renderer;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.IBakedModelExtension;
import net.neoforged.neoforge.client.model.data.ModelData;

public final class BlockExporter {
    private final ExportContext ctx;
    private final SceneSink sceneSink;
    private final Level level;
    private final ClientChunkCache chunkCache;
    private final SpriteFinder spriteFinder;
    private BlockPos regionMin;
    private BlockPos regionMax;
    private double offsetX = 0.0;
    private double offsetY = 0.0;
    private double offsetZ = 0.0;
    private final Map<Long, List<OverlayQuadData>> overlayCacheVanilla = new HashMap<Long, List<OverlayQuadData>>();
    private final Map<Long, List<OverlayQuadData>> overlayCacheCTM = new HashMap<Long, List<OverlayQuadData>>();
    private final Map<Long, List<OverlayQuadData>> overlayCacheCombined = new HashMap<Long, List<OverlayQuadData>>();
    private volatile boolean missingNeighborDetected = false;
    private boolean currentBlockIsCTM = false;
    private static final boolean CTM_LOG_ENABLED = true;
    private static final float AXIS_NORMAL_DOT_MIN = 0.9999f;
    private static final float AXIS_COMPONENT_EPS = 0.001f;
    private static final float PLANE_EPS = 1.0E-4f;
    private static final float SIZE_EPS = 1.0E-4f;
    private static final float UNIT_SIZE = 1.0f;
    private static final float UNIT_EPS = 0.001f;
    private static final float OVERLAY_ZFIGHT_OFFSET = 3.0E-4f;
    private static PrintWriter ctmDebugLog = null;
    private static int sampledBlockCount = 0;

    public BlockExporter(ExportContext ctx, SceneSink sceneSink, Level level) {
        ClientChunkCache clientChunkCache;
        this.ctx = ctx;
        this.sceneSink = sceneSink;
        this.level = level;
        if (level instanceof ClientLevel) {
            ClientLevel cl = (ClientLevel)level;
            clientChunkCache = cl.getChunkSource();
        } else {
            clientChunkCache = null;
        }
        this.chunkCache = clientChunkCache;
        this.spriteFinder = SpriteFinder.get((TextureAtlas)ctx.getMc().getModelManager().getAtlas(TextureAtlas.LOCATION_BLOCKS));
    }

    public static void initializeCTMDebugLog(Path outDir) {
        if (ctmDebugLog == null) {
            try {
                Path logPath = outDir.resolve("voxelbridge_ctm_debug.log");
                ctmDebugLog = new PrintWriter(new FileWriter(logPath.toFile(), false));
                ctmDebugLog.println("=== VoxelBridge CTM Debug Log ===");
                ctmDebugLog.println("Timestamp: " + System.currentTimeMillis());
                ctmDebugLog.flush();
                System.out.println("[VoxelBridge] CTM Debug Log initialized at: " + String.valueOf(logPath));
            }
            catch (IOException e) {
                System.err.println("[VoxelBridge] Failed to create CTM debug log: " + e.getMessage());
                e.printStackTrace();
            }
            catch (Exception e) {
                System.err.println("[VoxelBridge] Failed to create CTM debug log (Unknown error): " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    public static void closeCTMDebugLog() {
        if (ctmDebugLog != null) {
            try {
                ctmDebugLog.println("\n=== Log Complete ===");
                ctmDebugLog.println("Total blocks sampled: " + sampledBlockCount);
                ctmDebugLog.close();
                ctmDebugLog = null;
                sampledBlockCount = 0;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void setRegionBounds(BlockPos min, BlockPos max) {
        this.regionMin = min;
        this.regionMax = max;
        if (this.ctx.getCoordinateMode() == CoordinateMode.CENTERED) {
            this.offsetX = (double)(-(min.getX() + max.getX())) / 2.0;
            this.offsetY = (double)(-(min.getY() + max.getY())) / 2.0;
            this.offsetZ = (double)(-(min.getZ() + max.getZ())) / 2.0;
        } else {
            this.offsetX = 0.0;
            this.offsetY = 0.0;
            this.offsetZ = 0.0;
        }
    }

    public void sampleBlock(BlockState state, BlockPos pos) {
        ModHandledQuads handledQuads;
        List<BakedQuad> quads;
        boolean shouldLog;
        boolean isTransparent;
        BlockEntityExportResult beResult;
        BlockEntity be;
        if (!this.isNeighborChunksLoadedForBlock(pos)) {
            this.missingNeighborDetected = true;
            return;
        }
        this.overlayCacheVanilla.clear();
        this.overlayCacheCTM.clear();
        this.overlayCacheCombined.clear();
        this.currentBlockIsCTM = false;
        if (state.isAir()) {
            return;
        }
        FluidState fluidState = state.getFluidState();
        if (fluidState != null && !fluidState.isEmpty()) {
            FluidExporter.sample(this.ctx, this.sceneSink, this.level, state, pos, fluidState, this.offsetX, this.offsetY, this.offsetZ, this.regionMin, this.regionMax);
        }
        if ((be = this.level.getBlockEntity(pos)) != null && this.ctx.isBlockEntityExportEnabled() && (beResult = BlockEntityExporter.export(this.ctx, this.level, state, be, pos, this.sceneSink, this.offsetX, this.offsetY, this.offsetZ)).replaceBlockModel()) {
            return;
        }
        if (state.getRenderShape() == RenderShape.INVISIBLE) {
            return;
        }
        BakedModel model = this.ctx.getMc().getModelManager().getBlockModelShaper().getBlockModel(state);
        if (model == null) {
            return;
        }
        boolean bl = isTransparent = !state.isSolidRender((BlockGetter)this.level, pos);
        if (!isTransparent && this.isFullyOccluded(pos)) {
            return;
        }
        ModelData modelData = this.getModelData(model, state, pos);
        boolean bl2 = shouldLog = sampledBlockCount < 100;
        if (shouldLog && ctmDebugLog != null) {
            ++sampledBlockCount;
            try {
                ctmDebugLog.println("\n--- Block #" + sampledBlockCount + " ---");
                ctmDebugLog.println("Position: " + pos.toShortString());
                ctmDebugLog.println("BlockState: " + state.toString());
                ctmDebugLog.println("Model Class: " + model.getClass().getName());
                if (model instanceof FabricBakedModel) {
                    FabricBakedModel fabricModel = (FabricBakedModel)model;
                    ctmDebugLog.println("Is FabricBakedModel: true");
                    ctmDebugLog.println("Is Vanilla Adapter: " + fabricModel.isVanillaAdapter());
                } else {
                    ctmDebugLog.println("Is FabricBakedModel: false");
                }
                ctmDebugLog.flush();
            }
            catch (Exception fabricModel) {
                // empty catch block
            }
        }
        List<BakedQuad> list = quads = (handledQuads = ModHandlerRegistry.handle(this.ctx, this.level, state, be, pos, model)) != null ? handledQuads.quads() : this.getQuads(model, state, modelData, pos);
        if (!quads.isEmpty()) {
            this.currentBlockIsCTM = this.isCTMModel(model, quads);
        }
        if (shouldLog && ctmDebugLog != null) {
            try {
                ctmDebugLog.println("Quads returned: " + quads.size());
                ctmDebugLog.println("Is CTM (sprite analysis): " + this.currentBlockIsCTM);
                for (int i = 0; i < Math.min(quads.size(), 20); ++i) {
                    BakedQuad quad = quads.get(i);
                    if (quad == null || quad.getSprite() == null) continue;
                    ctmDebugLog.println("  Quad[" + i + "]: sprite=" + String.valueOf(quad.getSprite().contents().name()) + ", dir=" + String.valueOf(quad.getDirection()) + ", tint=" + quad.getTintIndex());
                }
                ctmDebugLog.flush();
            }
            catch (Exception i) {
                // empty catch block
            }
        }
        if (quads.isEmpty()) {
            return;
        }
        String blockKey = BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString();
        HashMap<Long, List<QuadInfo>> ctmPositionQuads = new HashMap<Long, List<QuadInfo>>();
        int quadIndex = 0;
        for (BakedQuad bakedQuad : quads) {
            if (bakedQuad == null || bakedQuad.getSprite() == null) {
                ++quadIndex;
                continue;
            }
            float[] fArray = new float[12];
            float[] uv0 = new float[8];
            this.extractVertices(bakedQuad, pos, fArray, uv0, bakedQuad.getSprite());
            long posHash = this.computePositionHash(fArray);
            float[] normal = this.computeFaceNormal(fArray);
            String spriteKey = SpriteKeyResolver.resolve(bakedQuad.getSprite());
            QuadInfo info4 = this.buildQuadInfo(spriteKey, fArray, normal, quadIndex);
            ctmPositionQuads.computeIfAbsent(posHash, k -> new ArrayList()).add(info4);
            ++quadIndex;
        }
        for (Map.Entry entry : ctmPositionQuads.entrySet()) {
            List list2 = (List)entry.getValue();
            if (list2.size() < 2) continue;
            boolean hasCTM = false;
            boolean hasVanillaOverlay = false;
            for (QuadInfo info2 : list2) {
                if (this.isCTMQuad(info2.sprite)) {
                    hasCTM = true;
                }
                if (!this.isVanillaOverlayQuad(info2.sprite)) continue;
                hasVanillaOverlay = true;
            }
            int minIndex = Integer.MAX_VALUE;
            for (QuadInfo info3 : list2) {
                if (info3.originalIndex >= minIndex) continue;
                minIndex = info3.originalIndex;
            }
            if (hasCTM) {
                Object info2;
                boolean allValid = true;
                for (Object info2 : list2) {
                    if (this.isApprox1x1Square((QuadInfo)info2)) continue;
                    allValid = false;
                    break;
                }
                if (!allValid) continue;
                int overlayIdx = 0;
                info2 = list2.iterator();
                while (info2.hasNext()) {
                    QuadInfo info5 = (QuadInfo)info2.next();
                    if (info5.originalIndex <= minIndex) continue;
                    BakedQuad overlayQuad = quads.get(info5.originalIndex);
                    this.cacheOverlayQuad(state, pos, overlayQuad, true, overlayIdx++);
                }
                continue;
            }
            if (!hasVanillaOverlay) continue;
            int overlayIdx = 0;
            for (Object info2 : list2) {
                if (!this.isVanillaOverlayQuad(((QuadInfo)info2).sprite)) continue;
                BakedQuad overlayQuad = quads.get(((QuadInfo)info2).originalIndex);
                this.cacheOverlayQuad(state, pos, overlayQuad, false, overlayIdx++);
            }
        }
        for (Map.Entry entry : this.overlayCacheVanilla.entrySet()) {
            this.overlayCacheCombined.put((Long)entry.getKey(), new ArrayList((Collection)entry.getValue()));
        }
        for (Map.Entry entry : this.overlayCacheCTM.entrySet()) {
            List list3 = this.overlayCacheCombined.computeIfAbsent((Long)entry.getKey(), k -> new ArrayList());
            list3.addAll((Collection)entry.getValue());
        }
        int totalOverlayCount = 0;
        for (List<OverlayQuadData> list4 : this.overlayCacheCombined.values()) {
            totalOverlayCount += list4.size();
        }
        int n = totalOverlayCount;
        if (n > 24) {
            if (ctmDebugLog != null && sampledBlockCount <= 100) {
                ctmDebugLog.println("  [WARNING] Abnormal overlay count: " + n + " (expected <=24), clearing overlay detection");
                ctmDebugLog.println("  [INFO] This block likely has complex geometry, not CTM overlays");
                ctmDebugLog.flush();
            }
            this.overlayCacheVanilla.clear();
            this.overlayCacheCTM.clear();
            this.overlayCacheCombined.clear();
        }
        HashSet<Long> hashSet = new HashSet<Long>();
        HashSet<Long> processedPositions = new HashSet<Long>();
        for (BakedQuad quad : quads) {
            if (quad == null) continue;
            Direction dir = quad.getDirection();
            if (dir != null) {
                if (!isTransparent) {
                    if (this.isFaceOccluded(pos, dir)) {
                        if (ctmDebugLog == null || sampledBlockCount > 100 || !(blockName = state.getBlock().getName().getString()).contains("leaves") && !blockName.contains("glass")) continue;
                        ctmDebugLog.println("  [CULLED] Opaque face " + String.valueOf(dir) + " at " + pos.toShortString());
                        continue;
                    }
                } else if (this.currentBlockIsCTM && this.isFaceOccludedBySameBlock(state, pos, dir)) {
                    if (ctmDebugLog == null || sampledBlockCount > 100 || !(blockName = state.getBlock().getName().getString()).contains("leaves") && !blockName.contains("glass")) continue;
                    ctmDebugLog.println("  [CULLED] CTM transparent face " + String.valueOf(dir) + " at " + pos.toShortString());
                    continue;
                }
            }
            this.processQuad(state, pos, quad, hashSet, processedPositions, ctmPositionQuads, blockKey);
        }
    }

    private void processQuad(BlockState state, BlockPos pos, BakedQuad quad, Set<Long> quadKeys, Set<Long> processedPositions, Map<Long, List<QuadInfo>> ctmPositionQuads, String blockKey) {
        boolean isDynamic;
        TextureAtlasSprite sprite = quad.getSprite();
        if (sprite == null) {
            return;
        }
        String spriteKey = SpriteKeyResolver.resolve(sprite);
        boolean bl = isDynamic = spriteKey.matches(".*\\d+$") || !this.ctx.getMaterialPaths().containsKey(spriteKey);
        if (isDynamic) {
            TextureAtlasManager.registerTint(this.ctx, spriteKey, 0xFFFFFF);
            if (this.ctx.getCachedSpriteImage(spriteKey) == null) {
                try {
                    BufferedImage img = TextureLoader.fromSprite(sprite);
                    if (img != null) {
                        this.ctx.cacheSpriteImage(spriteKey, img);
                    }
                }
                catch (Exception img) {
                    // empty catch block
                }
            }
        }
        float[] positions = new float[12];
        float[] uv0 = new float[8];
        boolean doubleSided = state.getBlock() instanceof BushBlock;
        this.extractVertices(quad, pos, positions, uv0, sprite);
        float[] normal = this.computeFaceNormal(positions);
        long quadKey = this.computeQuadKey(spriteKey, positions, normal, doubleSided, uv0);
        if (!quadKeys.add(quadKey)) {
            return;
        }
        long posHash = this.computePositionHash(positions);
        if (this.isQuadCachedAsOverlay(posHash, spriteKey)) {
            return;
        }
        int argb = this.computeTintColor(state, pos, quad);
        float[] uv1 = this.getColormapUV(argb);
        float[] colors = this.whiteColor();
        this.sceneSink.addQuad(blockKey, spriteKey, null, positions, uv0, uv1, normal, colors, doubleSided);
        if (!processedPositions.add(posHash)) {
            return;
        }
        List<OverlayQuadData> overlays = this.overlayCacheCombined.get(posHash);
        if (overlays != null && !overlays.isEmpty()) {
            for (OverlayQuadData overlay : overlays) {
                this.sceneSink.addQuad(blockKey, overlay.spriteKey, "overlay", overlay.positions, overlay.uv, overlay.colorUv, overlay.normal, colors, doubleSided);
            }
        }
    }

    private void extractVertices(BakedQuad quad, BlockPos pos, float[] positions, float[] uv0, TextureAtlasSprite sprite) {
        float dv;
        float du;
        int[] verts = quad.getVertices();
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        int spriteWidth = sprite.contents().width();
        int spriteHeight = sprite.contents().height();
        if (spriteHeight > spriteWidth) {
            int frameCount = spriteHeight / spriteWidth;
            float frameRatio = 1.0f / (float)frameCount;
            v1 = v0 + (v1 - v0) * frameRatio;
            if (ctmDebugLog != null && sampledBlockCount <= 100) {
                ctmDebugLog.println(String.format("  [ANIMATED] %s: %dx%d -> %d frames, adjusted V: [%.4f, %.4f]", sprite.contents().name(), spriteWidth, spriteHeight, frameCount, Float.valueOf(v0), Float.valueOf(v1)));
            }
        }
        if ((du = u1 - u0) == 0.0f) {
            du = 1.0f;
        }
        if ((dv = v1 - v0) == 0.0f) {
            dv = 1.0f;
        }
        for (int i = 0; i < 4; ++i) {
            int base = i * 8;
            float vx = Float.intBitsToFloat(verts[base]);
            float vy = Float.intBitsToFloat(verts[base + 1]);
            float vz = Float.intBitsToFloat(verts[base + 2]);
            float uu = Float.intBitsToFloat(verts[base + 4]);
            float vv = Float.intBitsToFloat(verts[base + 5]);
            double worldX = (double)((float)pos.getX() + vx) + this.offsetX;
            double worldY = (double)((float)pos.getY() + vy) + this.offsetY;
            double worldZ = (double)((float)pos.getZ() + vz) + this.offsetZ;
            positions[i * 3] = (float)worldX;
            positions[i * 3 + 1] = (float)worldY;
            positions[i * 3 + 2] = (float)worldZ;
            uv0[i * 2] = (uu - u0) / du;
            uv0[i * 2 + 1] = (vv - v0) / dv;
        }
    }

    private float[] getColormapUV(int argb) {
        ExportContext.TexturePlacement p = ColorMapManager.registerColor(this.ctx, argb);
        return new float[]{p.u0(), p.v0(), p.u1(), p.v0(), p.u1(), p.v1(), p.u0(), p.v1()};
    }

    private QuadInfo buildQuadInfo(String spriteKey, float[] positions, float[] normal, int originalIndex) {
        int axis = this.dominantAxis(normal);
        if (axis < 0) {
            return new QuadInfo(spriteKey, normal, -1, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, originalIndex);
        }
        float plane = positions[axis];
        float minU = Float.POSITIVE_INFINITY;
        float maxU = Float.NEGATIVE_INFINITY;
        float minV = Float.POSITIVE_INFINITY;
        float maxV = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < 4; ++i) {
            float v;
            float u;
            int base = i * 3;
            float coord = positions[base + axis];
            if (Math.abs(coord - plane) > 1.0E-4f) {
                return new QuadInfo(spriteKey, normal, -1, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, originalIndex);
            }
            switch (axis) {
                case 0: {
                    u = positions[base + 1];
                    v = positions[base + 2];
                    break;
                }
                case 1: {
                    u = positions[base];
                    v = positions[base + 2];
                    break;
                }
                case 2: {
                    u = positions[base];
                    v = positions[base + 1];
                    break;
                }
                default: {
                    return new QuadInfo(spriteKey, normal, -1, 0.0f, 0.0f, 0.0f, 0.0f, 0.0f, originalIndex);
                }
            }
            if (u < minU) {
                minU = u;
            }
            if (u > maxU) {
                maxU = u;
            }
            if (v < minV) {
                minV = v;
            }
            if (!(v > maxV)) continue;
            maxV = v;
        }
        return new QuadInfo(spriteKey, normal, axis, plane, minU, maxU, minV, maxV, originalIndex);
    }

    private int dominantAxis(float[] normal) {
        if (normal == null || normal.length < 3) {
            return -1;
        }
        float ax = Math.abs(normal[0]);
        float ay = Math.abs(normal[1]);
        float az = Math.abs(normal[2]);
        float max = ax;
        int axis = 0;
        if (ay > max) {
            max = ay;
            axis = 1;
        }
        if (az > max) {
            max = az;
            axis = 2;
        }
        if (max < 0.9999f) {
            return -1;
        }
        if (axis != 0 && ax > 0.001f) {
            return -1;
        }
        if (axis != 1 && ay > 0.001f) {
            return -1;
        }
        if (axis != 2 && az > 0.001f) {
            return -1;
        }
        return axis;
    }

    private boolean isOverlayPair(QuadInfo a, QuadInfo b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.axis < 0 || b.axis < 0) {
            return false;
        }
        if (a.axis != b.axis) {
            return false;
        }
        if (Math.abs(a.planeCoord - b.planeCoord) > 1.0E-4f) {
            return false;
        }
        float sizeU1 = a.maxU - a.minU;
        float sizeU2 = b.maxU - b.minU;
        float sizeV1 = a.maxV - a.minV;
        float sizeV2 = b.maxV - b.minV;
        if (Math.abs(sizeU1 - sizeU2) > 1.0E-4f) {
            return false;
        }
        if (Math.abs(sizeV1 - sizeV2) > 1.0E-4f) {
            return false;
        }
        if (Math.abs(a.minU - b.minU) > 1.0E-4f) {
            return false;
        }
        if (Math.abs(a.minV - b.minV) > 1.0E-4f) {
            return false;
        }
        if (Math.abs(sizeU1 - sizeV1) > 1.0E-4f) {
            return false;
        }
        return !(Math.abs(sizeU1 - 1.0f) > 0.001f);
    }

    private boolean isOverlayGeometry(float[] positions, float[] normal) {
        QuadInfo info = this.buildQuadInfo("overlay_check", positions, normal, -1);
        if (info.axis < 0) {
            return false;
        }
        float sizeU = info.maxU - info.minU;
        float sizeV = info.maxV - info.minV;
        if (Math.abs(sizeU - sizeV) > 1.0E-4f) {
            return false;
        }
        return !(Math.abs(sizeU - 1.0f) > 0.001f);
    }

    private void applyLocalOverlayOffset(float[] localPositions, int overlayIndex) {
        float nz;
        float ny;
        float nx;
        if (localPositions == null || localPositions.length < 12) {
            return;
        }
        float cx = 0.0f;
        float cy = 0.0f;
        float cz = 0.0f;
        for (int i = 0; i < 4; ++i) {
            cx += localPositions[i * 3];
            cy += localPositions[i * 3 + 1];
            cz += localPositions[i * 3 + 2];
        }
        float localCenter = 0.5f;
        float dx = (cx *= 0.25f) - 0.5f;
        float dy = (cy *= 0.25f) - 0.5f;
        float dz = (cz *= 0.25f) - 0.5f;
        float adx = Math.abs(dx);
        float ady = Math.abs(dy);
        float adz = Math.abs(dz);
        if (adx >= ady && adx >= adz) {
            nx = dx > 0.0f ? 1.0f : -1.0f;
            ny = 0.0f;
            nz = 0.0f;
        } else if (ady >= adx && ady >= adz) {
            nx = 0.0f;
            ny = dy > 0.0f ? 1.0f : -1.0f;
            nz = 0.0f;
        } else {
            nx = 0.0f;
            ny = 0.0f;
            nz = dz > 0.0f ? 1.0f : -1.0f;
        }
        float offsetMultiplier = overlayIndex + 1;
        float offset = 3.0E-4f * offsetMultiplier;
        for (int i = 0; i < 4; ++i) {
            int n = i * 3;
            localPositions[n] = localPositions[n] + nx * offset;
            int n2 = i * 3 + 1;
            localPositions[n2] = localPositions[n2] + ny * offset;
            int n3 = i * 3 + 2;
            localPositions[n3] = localPositions[n3] + nz * offset;
        }
    }

    @Deprecated
    private void applyOverlayOffsetWithIndex(BlockPos pos, float[] positions, float[] normal, int overlayIndex) {
        float nz;
        float ny;
        float nx;
        if (positions == null || positions.length < 12 || normal == null || normal.length < 3) {
            return;
        }
        float cx = 0.0f;
        float cy = 0.0f;
        float cz = 0.0f;
        for (int i = 0; i < 4; ++i) {
            cx += positions[i * 3];
            cy += positions[i * 3 + 1];
            cz += positions[i * 3 + 2];
        }
        cx *= 0.25f;
        cy *= 0.25f;
        cz *= 0.25f;
        float centerX = (float)((double)pos.getX() + 0.5 + this.offsetX);
        float centerY = (float)((double)pos.getY() + 0.5 + this.offsetY);
        float centerZ = (float)((double)pos.getZ() + 0.5 + this.offsetZ);
        float dx = cx - centerX;
        float dy = cy - centerY;
        float dz = cz - centerZ;
        float adx = Math.abs(dx);
        float ady = Math.abs(dy);
        float adz = Math.abs(dz);
        if (adx >= ady && adx >= adz) {
            nx = dx > 0.0f ? 1.0f : -1.0f;
            ny = 0.0f;
            nz = 0.0f;
        } else if (ady >= adx && ady >= adz) {
            nx = 0.0f;
            ny = dy > 0.0f ? 1.0f : -1.0f;
            nz = 0.0f;
        } else {
            nx = 0.0f;
            ny = 0.0f;
            nz = dz > 0.0f ? 1.0f : -1.0f;
        }
        float offsetMultiplier = overlayIndex + 1;
        float offset = 3.0E-4f * offsetMultiplier;
        for (int i = 0; i < 4; ++i) {
            int n = i * 3;
            positions[n] = positions[n] + nx * offset;
            int n2 = i * 3 + 1;
            positions[n2] = positions[n2] + ny * offset;
            int n3 = i * 3 + 2;
            positions[n3] = positions[n3] + nz * offset;
        }
        normal[0] = nx;
        normal[1] = ny;
        normal[2] = nz;
    }

    private boolean isQuadCachedAsOverlay(long posHash, String spriteKey) {
        List<OverlayQuadData> ctmList;
        List<OverlayQuadData> vanillaList = this.overlayCacheVanilla.get(posHash);
        if (vanillaList != null) {
            for (OverlayQuadData data : vanillaList) {
                if (!data.spriteKey.equals(spriteKey)) continue;
                return true;
            }
        }
        if ((ctmList = this.overlayCacheCTM.get(posHash)) != null) {
            for (OverlayQuadData data : ctmList) {
                if (!data.spriteKey.equals(spriteKey)) continue;
                return true;
            }
        }
        return false;
    }

    private OverlayQuadData findOverlayForSprite(long posHash, BlockPos pos, String spriteKey) {
        List<OverlayQuadData> ctmList;
        List<OverlayQuadData> vanillaList = this.overlayCacheVanilla.get(posHash);
        if (vanillaList != null) {
            for (OverlayQuadData data : vanillaList) {
                if (!data.spriteKey.equals(spriteKey)) continue;
                return data;
            }
        }
        if ((ctmList = this.overlayCacheCTM.get(posHash)) != null) {
            for (OverlayQuadData data : ctmList) {
                if (!data.spriteKey.equals(spriteKey)) continue;
                return data;
            }
        }
        return null;
    }

    private List<OverlayQuadData> findOverlaysForBase(long posHash, BlockPos pos) {
        ArrayList overlays = this.overlayCacheCombined.get(posHash);
        return overlays != null ? overlays : new ArrayList();
    }

    private boolean isLikelyCTMOverlay(String spriteKey) {
        if (spriteKey == null) {
            return false;
        }
        String key = spriteKey.toLowerCase(Locale.ROOT);
        return key.matches(".*_\\d+$") || key.contains("/ctm/") || key.contains("ctm/");
    }

    private boolean isCTMQuad(String spriteKey) {
        return spriteKey != null && spriteKey.contains("continuity");
    }

    private boolean isVanillaOverlayQuad(String spriteKey) {
        return spriteKey != null && spriteKey.contains("_overlay");
    }

    private boolean isApprox1x1Square(QuadInfo info) {
        if (info == null || info.axis < 0) {
            return false;
        }
        float sizeU = info.maxU - info.minU;
        float sizeV = info.maxV - info.minV;
        float SIZE_TOLERANCE = 0.01f;
        if (Math.abs(sizeU - sizeV) > SIZE_TOLERANCE) {
            return false;
        }
        return !(Math.abs(sizeU - 1.0f) > SIZE_TOLERANCE);
    }

    private void cacheOverlayQuad(BlockState state, BlockPos pos, BakedQuad quad, boolean isCtmOverlay, int overlayIndex) {
        int i;
        int[] verts;
        boolean isDynamicTexture;
        TextureAtlasSprite sprite = quad.getSprite();
        if (sprite == null) {
            return;
        }
        String spriteKey = SpriteKeyResolver.resolve(sprite);
        boolean bl = isDynamicTexture = spriteKey.contains("_overlay") || spriteKey.matches(".*\\d+$") || !this.ctx.getMaterialPaths().containsKey(spriteKey);
        if (isDynamicTexture) {
            TextureAtlasManager.registerTint(this.ctx, spriteKey, 0xFFFFFF);
        }
        if (isDynamicTexture && this.ctx.getCachedSpriteImage(spriteKey) == null) {
            try {
                BufferedImage image = TextureLoader.fromSprite(sprite);
                if (image != null) {
                    this.ctx.cacheSpriteImage(spriteKey, image);
                }
            }
            catch (Exception image) {
                // empty catch block
            }
        }
        float[] positions = new float[12];
        float[] uv0 = new float[8];
        float u0 = sprite.getU0();
        float u1 = sprite.getU1();
        float v0 = sprite.getV0();
        float v1 = sprite.getV1();
        int spriteWidth = sprite.contents().width();
        int spriteHeight = sprite.contents().height();
        if (spriteHeight > spriteWidth) {
            int frameCount = spriteHeight / spriteWidth;
            float frameRatio = 1.0f / (float)frameCount;
            v1 = v0 + (v1 - v0) * frameRatio;
        }
        float du = u1 - u0;
        float dv = v1 - v0;
        if (du == 0.0f) {
            du = 1.0f;
        }
        if (dv == 0.0f) {
            dv = 1.0f;
        }
        try {
            verts = quad.getVertices();
        }
        catch (Throwable t) {
            return;
        }
        if (verts.length < 32) {
            return;
        }
        int stride = 8;
        int[] vertexColors = new int[4];
        float[] localPos = new float[12];
        for (i = 0; i < 4; ++i) {
            int base = i * 8;
            float vx = Float.intBitsToFloat(verts[base]);
            float vy = Float.intBitsToFloat(verts[base + 1]);
            float vz = Float.intBitsToFloat(verts[base + 2]);
            int abgr = verts[base + 3];
            float uu = Float.intBitsToFloat(verts[base + 4]);
            float vv = Float.intBitsToFloat(verts[base + 5]);
            vertexColors[i] = abgr;
            localPos[i * 3] = vx;
            localPos[i * 3 + 1] = vy;
            localPos[i * 3 + 2] = vz;
            float su = (uu - u0) / du;
            float sv = (vv - v0) / dv;
            uv0[i * 2] = su;
            uv0[i * 2 + 1] = sv;
        }
        this.applyLocalOverlayOffset(localPos, overlayIndex);
        for (i = 0; i < 4; ++i) {
            double worldX = (double)((float)pos.getX() + localPos[i * 3]) + this.offsetX;
            double worldY = (double)((float)pos.getY() + localPos[i * 3 + 1]) + this.offsetY;
            double worldZ = (double)((float)pos.getZ() + localPos[i * 3 + 2]) + this.offsetZ;
            positions[i * 3] = (float)worldX;
            positions[i * 3 + 1] = (float)worldY;
            positions[i * 3 + 2] = (float)worldZ;
        }
        int overlayColor = this.extractOverlayColor(state, pos, quad, vertexColors);
        float[] overlayColorUv = new float[8];
        ExportContext.TexturePlacement placement = ColorMapManager.registerColor(this.ctx, overlayColor);
        overlayColorUv[0] = placement.u0();
        overlayColorUv[1] = placement.v0();
        overlayColorUv[2] = placement.u1();
        overlayColorUv[3] = placement.v0();
        overlayColorUv[4] = placement.u1();
        overlayColorUv[5] = placement.v1();
        overlayColorUv[6] = placement.u0();
        overlayColorUv[7] = placement.v1();
        float[] normal = this.computeFaceNormal(positions);
        long posHash = this.computePositionHash(positions);
        Map<Long, List<OverlayQuadData>> cache = isCtmOverlay ? this.overlayCacheCTM : this.overlayCacheVanilla;
        List overlayList = cache.computeIfAbsent(posHash, k -> new ArrayList());
        OverlayQuadData data = new OverlayQuadData((float[])positions.clone(), normal, (float[])uv0.clone(), overlayColorUv, spriteKey, overlayColor, isCtmOverlay, overlayIndex);
        overlayList.add(data);
    }

    private int extractOverlayColor(BlockState state, BlockPos pos, BakedQuad quad, int[] vertexColors) {
        for (int i = 0; i < 4; ++i) {
            int abgr = vertexColors[i];
            int rgb = abgr & 0xFFFFFF;
            if (rgb == 0xFFFFFF) continue;
            return 0xFF000000 | rgb;
        }
        if (quad.getTintIndex() >= 0) {
            int argb = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)this.level, pos, quad.getTintIndex());
            return argb == -1 ? -1 : argb;
        }
        return -1;
    }

    private ModelData getModelData(BakedModel model, BlockState state, BlockPos pos) {
        ModelData modelData = ModelData.EMPTY;
        try {
            modelData = this.level.getModelData(pos);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        try {
            if (model instanceof IBakedModelExtension) {
                BakedModel extension = model;
                modelData = extension.getModelData((BlockAndTintGetter)this.level, pos, state, modelData);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return modelData;
    }

    private List<BakedQuad> getQuads(BakedModel model, final BlockState state, ModelData data, final BlockPos pos) {
        RandomSource rand;
        ArrayList<BakedQuad> quads;
        block14: {
            quads = new ArrayList<BakedQuad>();
            long seed = state.is(Blocks.LILY_PAD) ? this.computeBushSeed(pos) : Mth.getSeed((int)pos.getX(), (int)pos.getY(), (int)pos.getZ());
            rand = RandomSource.create((long)seed);
            try {
                FabricBakedModel fabricModel;
                final Renderer renderer = RendererAccess.INSTANCE.getRenderer();
                if (renderer == null || !(model instanceof FabricBakedModel) || (fabricModel = (FabricBakedModel)model).isVanillaAdapter()) break block14;
                final LinkedList<MeshBuilder> builders = new LinkedList<MeshBuilder>();
                final LinkedList<QuadEmitter> emitters = new LinkedList<QuadEmitter>();
                final LinkedList<Object> transforms = new LinkedList<Object>();
                ArrayList<BakedQuad> fabricQuads = new ArrayList<BakedQuad>();
                MeshBuilder baseBuilder = renderer.meshBuilder();
                builders.push(baseBuilder);
                emitters.push(baseBuilder.getEmitter());
                transforms.push(null);
                RenderContext context = new RenderContext(){

                    public QuadEmitter getEmitter() {
                        return (QuadEmitter)emitters.peek();
                    }

                    public boolean isFaceCulled(Direction face) {
                        return false;
                    }

                    public void pushTransform(RenderContext.QuadTransform transform) {
                        MeshBuilder layerBuilder = renderer.meshBuilder();
                        builders.push(layerBuilder);
                        emitters.push(layerBuilder.getEmitter());
                        transforms.push(transform);
                        if (ctmDebugLog != null && sampledBlockCount <= 100) {
                            ctmDebugLog.println("  [TRANSFORM] Push - Stack size: " + emitters.size());
                        }
                    }

                    public void popTransform() {
                        if (emitters.size() <= 1) {
                            if (ctmDebugLog != null && sampledBlockCount <= 100) {
                                ctmDebugLog.println("  [TRANSFORM] Pop ignored (stack empty or base reached)");
                            }
                            return;
                        }
                        MeshBuilder topBuilder = (MeshBuilder)builders.pop();
                        emitters.pop();
                        RenderContext.QuadTransform transform = (RenderContext.QuadTransform)transforms.pop();
                        QuadEmitter target = (QuadEmitter)emitters.peek();
                        Mesh mesh = topBuilder.build();
                        mesh.forEach(q -> {
                            target.copyFrom(q);
                            if (transform.transform((MutableQuadView)target)) {
                                target.emit();
                            }
                        });
                        if (ctmDebugLog != null && sampledBlockCount <= 100) {
                            ctmDebugLog.println("  [TRANSFORM] Pop - Flushed layer to parent");
                        }
                    }

                    public RenderContext.BakedModelConsumer bakedModelConsumer() {
                        final 1 current = this;
                        return new RenderContext.BakedModelConsumer(){

                            public void accept(BakedModel bakedModel) {
                                if (bakedModel instanceof FabricBakedModel) {
                                    FabricBakedModel fbm = (FabricBakedModel)bakedModel;
                                    fbm.emitBlockQuads((BlockAndTintGetter)BlockExporter.this.level, state, pos, () -> rand, current);
                                }
                            }

                            public void accept(BakedModel bakedModel, BlockState modelState) {
                                if (bakedModel instanceof FabricBakedModel) {
                                    FabricBakedModel fbm = (FabricBakedModel)bakedModel;
                                    BlockState targetState = modelState != null ? modelState : state;
                                    fbm.emitBlockQuads((BlockAndTintGetter)BlockExporter.this.level, targetState, pos, () -> rand, current);
                                }
                            }
                        };
                    }
                };
                fabricModel.emitBlockQuads((BlockAndTintGetter)this.level, state, pos, () -> rand, context);
                Mesh mesh = baseBuilder.build();
                mesh.forEach(q -> fabricQuads.add(this.toBakedQuad((QuadView)q)));
                if (fabricQuads.isEmpty()) break block14;
                if (ctmDebugLog != null && sampledBlockCount <= 100) {
                    try {
                        ctmDebugLog.println("  [FABRIC API PATH] Collected " + fabricQuads.size() + " quads via Fabric Renderer");
                        ctmDebugLog.flush();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return fabricQuads;
            }
            catch (Throwable t) {
                if (ctmDebugLog == null || sampledBlockCount > 100) break block14;
                try {
                    ctmDebugLog.println("  [FABRIC API ERROR] " + t.getClass().getSimpleName() + ": " + t.getMessage());
                    t.printStackTrace(ctmDebugLog);
                    ctmDebugLog.flush();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        try {
            for (Direction dir : Direction.values()) {
                List q2 = model.getQuads(state, dir, rand, data, null);
                if (q2 == null) continue;
                quads.addAll(q2);
            }
            List q2 = model.getQuads(state, null, rand, data, null);
            if (q2 != null) {
                quads.addAll(q2);
            }
            if (ctmDebugLog != null && sampledBlockCount <= 100) {
                try {
                    ctmDebugLog.println("  [VANILLA PATH] Collected " + quads.size() + " quads via vanilla getQuads()");
                    ctmDebugLog.flush();
                }
                catch (Exception exception) {}
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return quads;
    }

    private BakedQuad toBakedQuad(QuadView quad) {
        int vertexSize = DefaultVertexFormat.BLOCK.getVertexSize() / 4;
        int[] vertices = new int[vertexSize * 4];
        for (int i = 0; i < 4; ++i) {
            int offset = i * vertexSize;
            vertices[offset + 0] = Float.floatToRawIntBits(quad.x(i));
            vertices[offset + 1] = Float.floatToRawIntBits(quad.y(i));
            vertices[offset + 2] = Float.floatToRawIntBits(quad.z(i));
            vertices[offset + 3] = quad.color(i);
            vertices[offset + 4] = Float.floatToRawIntBits(quad.u(i));
            vertices[offset + 5] = Float.floatToRawIntBits(quad.v(i));
            vertices[offset + 6] = quad.lightmap(i);
            if (quad.hasNormal(i)) {
                float nx = quad.normalX(i);
                float ny = quad.normalY(i);
                float nz = quad.normalZ(i);
                vertices[offset + 7] = this.packNormal(nx, ny, nz);
                continue;
            }
            Direction dir = quad.lightFace();
            vertices[offset + 7] = dir != null ? this.packNormal(dir.getStepX(), dir.getStepY(), dir.getStepZ()) : this.packNormal(0.0f, 1.0f, 0.0f);
        }
        TextureAtlasSprite sprite = this.spriteFinder.find(quad, 0);
        Direction cullFace = quad.cullFace();
        int tintIndex = quad.colorIndex();
        boolean shade = true;
        return new BakedQuad(vertices, tintIndex, cullFace, sprite, shade);
    }

    private int packNormal(float x, float y, float z) {
        float len = (float)Math.sqrt(x * x + y * y + z * z);
        if (len > 1.0E-4f) {
            x /= len;
            y /= len;
            z /= len;
        }
        int nx = (int)(x * 127.0f) & 0xFF;
        int ny = (int)(y * 127.0f) & 0xFF;
        int nz = (int)(z * 127.0f) & 0xFF;
        return nx | ny << 8 | nz << 16;
    }

    private boolean isCTMModel(BakedModel model, List<BakedQuad> quads) {
        if (!(model instanceof FabricBakedModel)) {
            return false;
        }
        FabricBakedModel fbm = (FabricBakedModel)model;
        if (fbm.isVanillaAdapter()) {
            return false;
        }
        String className = model.getClass().getName().toLowerCase();
        if (!(className.contains("continuity") || className.contains("ctm") || className.contains("connected"))) {
            return false;
        }
        HashSet<String> uniqueSprites = new HashSet<String>();
        for (BakedQuad quad : quads) {
            String spriteKey;
            if (quad == null || quad.getSprite() == null || (spriteKey = SpriteKeyResolver.resolve(quad.getSprite())).contains("_overlay")) continue;
            String baseSprite = spriteKey.replaceAll("_\\d+$", "");
            uniqueSprites.add(baseSprite);
        }
        return uniqueSprites.size() > 1;
    }

    private boolean isNeighborChunksLoadedForBlock(BlockPos pos) {
        if (this.chunkCache == null) {
            return true;
        }
        int localX = pos.getX() & 0xF;
        int localZ = pos.getZ() & 0xF;
        int cx = pos.getX() >> 4;
        int cz = pos.getZ() >> 4;
        if (localX == 0 && this.isChunkMissing(cx - 1, cz)) {
            return false;
        }
        if (localX == 15 && this.isChunkMissing(cx + 1, cz)) {
            return false;
        }
        if (localZ == 0 && this.isChunkMissing(cx, cz - 1)) {
            return false;
        }
        return localZ != 15 || !this.isChunkMissing(cx, cz + 1);
    }

    private boolean isChunkMissing(int cx, int cz) {
        LevelChunk chunk = this.chunkCache.getChunk(cx, cz, false);
        return chunk == null || chunk.isEmpty();
    }

    private boolean isFullyOccluded(BlockPos pos) {
        for (Direction dir : Direction.values()) {
            BlockPos neighbor = pos.relative(dir);
            if (this.isOutsideRegion(neighbor)) {
                return false;
            }
            if (this.isNeighborSolid(neighbor)) continue;
            return false;
        }
        return true;
    }

    private boolean isFaceOccluded(BlockPos pos, Direction face) {
        BlockPos neighbor = pos.relative(face);
        if (this.isOutsideRegion(neighbor)) {
            return false;
        }
        return this.isNeighborSolid(neighbor);
    }

    private boolean isFaceOccludedBySameBlock(BlockState state, BlockPos pos, Direction face) {
        BlockPos neighbor = pos.relative(face);
        if (this.isOutsideRegion(neighbor)) {
            return false;
        }
        BlockState neighborState = this.level.getBlockState(neighbor);
        return neighborState.getBlock() == state.getBlock();
    }

    private boolean isOutsideRegion(BlockPos pos) {
        if (this.regionMin == null || this.regionMax == null) {
            return false;
        }
        return pos.getX() < this.regionMin.getX() || pos.getX() > this.regionMax.getX() || pos.getY() < this.regionMin.getY() || pos.getY() > this.regionMax.getY() || pos.getZ() < this.regionMin.getZ() || pos.getZ() > this.regionMax.getZ();
    }

    private boolean isNeighborSolid(BlockPos neighbor) {
        if (this.chunkCache != null) {
            int cz;
            int cx = neighbor.getX() >> 4;
            LevelChunk chunk = this.chunkCache.getChunk(cx, cz = neighbor.getZ() >> 4, false);
            if (chunk == null || chunk.isEmpty()) {
                return true;
            }
            BlockState state = chunk.getBlockState(neighbor);
            return state.isSolidRender((BlockGetter)this.level, neighbor);
        }
        BlockState neighborState = this.level.getBlockState(neighbor);
        return neighborState.isSolidRender((BlockGetter)this.level, neighbor);
    }

    private long computeBushSeed(BlockPos pos) {
        long seed = (long)pos.getX() * 3129871L ^ (long)pos.getZ() * 116129781L ^ (long)pos.getY();
        return seed * seed * 42317861L + seed * 11L;
    }

    private float[] computeFaceNormal(float[] positions) {
        float ay = positions[4] - positions[1];
        float bz = positions[8] - positions[2];
        float az = positions[5] - positions[2];
        float by = positions[7] - positions[1];
        float nx = ay * bz - az * by;
        float bx = positions[6] - positions[0];
        float ax = positions[3] - positions[0];
        float ny = az * bx - ax * bz;
        float nz = ax * by - ay * bx;
        float len = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (len == 0.0f) {
            return new float[]{0.0f, 1.0f, 0.0f};
        }
        return new float[]{nx / len, ny / len, nz / len};
    }

    private int computeTintColor(BlockState state, BlockPos pos, BakedQuad quad) {
        if (quad.getTintIndex() < 0) {
            return -1;
        }
        int argb = Minecraft.getInstance().getBlockColors().getColor(state, (BlockAndTintGetter)this.level, pos, quad.getTintIndex());
        return argb == -1 ? -1 : argb;
    }

    private float[] whiteColor() {
        return new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    }

    private long computePositionHash(float[] positions) {
        Integer[] order = new Integer[]{0, 1, 2, 3};
        Arrays.sort(order, (a, b) -> {
            int ib;
            int ia = a * 3;
            int cmpX = Float.compare(positions[ia], positions[ib = b * 3]);
            if (cmpX != 0) {
                return cmpX;
            }
            int cmpY = Float.compare(positions[ia + 1], positions[ib + 1]);
            if (cmpY != 0) {
                return cmpY;
            }
            return Float.compare(positions[ia + 2], positions[ib + 2]);
        });
        long hash = 1125899906842597L;
        Integer[] integerArray = order;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int idx = integerArray[i];
            int pi = idx * 3;
            hash = 31L * hash + (long)Math.round(positions[pi] * 100.0f);
            hash = 31L * hash + (long)Math.round(positions[pi + 1] * 100.0f);
            hash = 31L * hash + (long)Math.round(positions[pi + 2] * 100.0f);
        }
        return hash;
    }

    private long computeQuadKey(String spriteKey, float[] positions, float[] normal, boolean doubleSided, float[] uv0) {
        Integer[] order = new Integer[]{0, 1, 2, 3};
        Arrays.sort(order, (a, b) -> {
            int ib;
            int ia = a * 3;
            int cmpX = Float.compare(positions[ia], positions[ib = b * 3]);
            if (cmpX != 0) {
                return cmpX;
            }
            int cmpY = Float.compare(positions[ia + 1], positions[ib + 1]);
            if (cmpY != 0) {
                return cmpY;
            }
            return Float.compare(positions[ia + 2], positions[ib + 2]);
        });
        long hash = 1125899906842597L;
        hash = 31L * hash + (long)spriteKey.hashCode();
        if (!doubleSided) {
            hash = 31L * hash + (long)Math.round(normal[0] * 1000.0f);
            hash = 31L * hash + (long)Math.round(normal[1] * 1000.0f);
            hash = 31L * hash + (long)Math.round(normal[2] * 1000.0f);
        }
        Integer[] integerArray = order;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int idx = integerArray[i];
            int pi = idx * 3;
            hash = 31L * hash + (long)Math.round(positions[pi] * 1000.0f);
            hash = 31L * hash + (long)Math.round(positions[pi + 1] * 1000.0f);
            hash = 31L * hash + (long)Math.round(positions[pi + 2] * 1000.0f);
            if (uv0 == null || uv0.length < idx * 2 + 2) continue;
            hash = 31L * hash + (long)Math.round(uv0[idx * 2] * 1000.0f);
            hash = 31L * hash + (long)Math.round(uv0[idx * 2 + 1] * 1000.0f);
        }
        return hash;
    }

    public boolean hadMissingNeighborAndReset() {
        boolean result = this.missingNeighborDetected;
        this.missingNeighborDetected = false;
        return result;
    }

    private static class QuadInfo {
        final String sprite;
        final float[] normal;
        final int axis;
        final float planeCoord;
        final float minU;
        final float maxU;
        final float minV;
        final float maxV;
        final int originalIndex;

        QuadInfo(String sprite, float[] normal, int axis, float planeCoord, float minU, float maxU, float minV, float maxV, int originalIndex) {
            this.sprite = sprite;
            this.normal = normal;
            this.axis = axis;
            this.planeCoord = planeCoord;
            this.minU = minU;
            this.maxU = maxU;
            this.minV = minV;
            this.maxV = maxV;
            this.originalIndex = originalIndex;
        }
    }

    private static class OverlayQuadData {
        final float[] positions;
        final float[] normal;
        final float[] uv;
        final float[] colorUv;
        final String spriteKey;
        final int color;
        final boolean ctmOverlay;
        final int overlayIndex;

        OverlayQuadData(float[] positions, float[] normal, float[] uv, float[] colorUv, String spriteKey, int color, boolean ctmOverlay, int overlayIndex) {
            this.positions = positions;
            this.normal = normal;
            this.uv = uv;
            this.colorUv = colorUv;
            this.spriteKey = spriteKey;
            this.color = color;
            this.ctmOverlay = ctmOverlay;
            this.overlayIndex = overlayIndex;
        }
    }
}

