/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter;

import com.mojang.blaze3d.vertex.VertexConsumer;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.scene.SceneSink;
import com.voxelbridge.export.texture.ColorMapManager;
import com.voxelbridge.export.texture.SpriteKeyResolver;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;

final class QuadCollector
implements VertexConsumer {
    private final SceneSink sink;
    private final ExportContext ctx;
    private final BlockPos pos;
    private final TextureAtlasSprite[] sprites;
    private final double offsetX;
    private final double offsetY;
    private final double offsetZ;
    private final double regionMinX;
    private final double regionMaxX;
    private final double regionMinZ;
    private final double regionMaxZ;
    private final boolean hasRegionBounds;
    private final String materialGroupKey;
    private final float[] rawPositions = new float[12];
    private int rawCount = 0;
    private boolean decided = false;
    private boolean needsOffset = false;
    private boolean useChunkOffset = false;
    private int chunkOffsetX = 0;
    private int chunkOffsetY = 0;
    private int chunkOffsetZ = 0;
    private final float[] positions = new float[12];
    private final float[] uvs = new float[8];
    private final float[] colors = new float[16];
    private int vertexIndex = 0;
    private int quadArgb = -1;
    private boolean quadColorCaptured = false;

    QuadCollector(SceneSink sink, ExportContext ctx, BlockPos pos, TextureAtlasSprite[] sprites, double offsetX, double offsetY, double offsetZ, BlockPos regionMin, BlockPos regionMax, String materialGroupKey) {
        this.sink = sink;
        this.ctx = ctx;
        this.pos = pos;
        this.sprites = sprites;
        this.offsetX = offsetX;
        this.offsetY = offsetY;
        this.offsetZ = offsetZ;
        this.materialGroupKey = materialGroupKey;
        if (regionMin != null) {
            this.regionMinX = (double)regionMin.getX() + offsetX;
            this.regionMaxX = (double)regionMax.getX() + offsetX + 1.0;
            this.regionMinZ = (double)regionMin.getZ() + offsetZ;
            this.regionMaxZ = (double)regionMax.getZ() + offsetZ + 1.0;
            this.hasRegionBounds = true;
        } else {
            this.regionMinX = 0.0;
            this.regionMaxX = 0.0;
            this.regionMinZ = 0.0;
            this.regionMaxZ = 0.0;
            this.hasRegionBounds = false;
        }
    }

    public void flush() {
        this.vertexIndex = 0;
        this.resetQuadState();
    }

    public VertexConsumer addVertex(float x, float y, float z) {
        if (this.rawCount < 4) {
            this.rawPositions[this.rawCount * 3] = x;
            this.rawPositions[this.rawCount * 3 + 1] = y;
            this.rawPositions[this.rawCount * 3 + 2] = z;
            ++this.rawCount;
        }
        if (!this.decided && this.rawCount >= 4) {
            this.decideCoordinateSystem();
            this.decided = true;
            this.recomputePositions();
        }
        float[] adjusted = this.applyOffsets(x, y, z);
        this.positions[this.vertexIndex * 3] = adjusted[0];
        this.positions[this.vertexIndex * 3 + 1] = adjusted[1];
        this.positions[this.vertexIndex * 3 + 2] = adjusted[2];
        return this;
    }

    public VertexConsumer setColor(int r, int g, int b, int a) {
        this.colors[this.vertexIndex * 4] = (float)r / 255.0f;
        this.colors[this.vertexIndex * 4 + 1] = (float)g / 255.0f;
        this.colors[this.vertexIndex * 4 + 2] = (float)b / 255.0f;
        this.colors[this.vertexIndex * 4 + 3] = (float)a / 255.0f;
        if (!this.quadColorCaptured) {
            this.quadArgb = (a & 0xFF) << 24 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
            this.quadColorCaptured = true;
        }
        return this;
    }

    public VertexConsumer setUv(float u, float v) {
        this.uvs[this.vertexIndex * 2] = u;
        this.uvs[this.vertexIndex * 2 + 1] = v;
        return this;
    }

    public VertexConsumer setUv1(int u, int v) {
        return this;
    }

    public VertexConsumer setUv2(int u, int v) {
        return this;
    }

    public VertexConsumer setNormal(float x, float y, float z) {
        ++this.vertexIndex;
        if (this.vertexIndex == 4) {
            this.emitQuad();
            this.vertexIndex = 0;
        }
        return this;
    }

    public void endVertex() {
    }

    public void defaultColor(int r, int g, int b, int a) {
    }

    public void unsetDefaultColor() {
    }

    private void emitQuad() {
        TextureAtlasSprite sprite = this.chooseSpriteForQuad();
        if (sprite == null) {
            return;
        }
        float[] normal = this.computeFaceNormal(this.positions);
        if (this.hasRegionBounds && this.isBoundarySideQuad(normal)) {
            this.resetQuadState();
            return;
        }
        String spriteKey = SpriteKeyResolver.resolve(sprite);
        float[] normalizedUVs = this.normalizeUVs(this.uvs, sprite);
        float[] lut = ColorMapManager.remapColorUV(this.ctx, this.quadArgb);
        float u0 = lut[0];
        float v0 = lut[1];
        float u1 = lut[2];
        float v1 = lut[3];
        float du = u1 - u0;
        float dv = v1 - v0;
        float[] uv1 = new float[8];
        for (int i = 0; i < 4; ++i) {
            uv1[i * 2] = u0 + normalizedUVs[i * 2] * du;
            uv1[i * 2 + 1] = v0 + normalizedUVs[i * 2 + 1] * dv;
        }
        float[] linearColors = this.whiteColor();
        this.sink.addQuad(this.materialGroupKey, spriteKey, "voxelbridge:transparent", (float[])this.positions.clone(), normalizedUVs, uv1, normal, linearColors, true);
        this.resetQuadState();
    }

    private void resetQuadState() {
        this.rawCount = 0;
        this.decided = false;
        this.needsOffset = false;
        this.useChunkOffset = false;
        this.quadColorCaptured = false;
        this.quadArgb = -1;
    }

    private float[] normalizeUVs(float[] input, TextureAtlasSprite s) {
        float dv;
        float[] out = new float[8];
        float u0 = s.getU0();
        float u1 = s.getU1();
        float v0 = s.getV0();
        float v1 = s.getV1();
        float du = u1 - u0;
        if (du == 0.0f) {
            du = 1.0f;
        }
        if ((dv = v1 - v0) == 0.0f) {
            dv = 1.0f;
        }
        for (int i = 0; i < 4; ++i) {
            float u = input[i * 2];
            float v = input[i * 2 + 1];
            float su = (u - u0) / du;
            float sv = (v - v0) / dv;
            out[i * 2] = this.clamp01(su);
            out[i * 2 + 1] = this.clamp01(sv);
        }
        return out;
    }

    private TextureAtlasSprite chooseSpriteForQuad() {
        float d1;
        if (this.sprites.length == 0) {
            return null;
        }
        if (this.sprites.length == 1) {
            return this.sprites[0];
        }
        float centerU = 0.0f;
        float centerV = 0.0f;
        for (int i = 0; i < 4; ++i) {
            centerU += this.uvs[i * 2];
            centerV += this.uvs[i * 2 + 1];
        }
        if (this.isPointInSprite(centerU /= 4.0f, centerV /= 4.0f, this.sprites[0])) {
            return this.sprites[0];
        }
        if (this.isPointInSprite(centerU, centerV, this.sprites[1])) {
            return this.sprites[1];
        }
        float d0 = this.distToCenter(this.sprites[0], centerU, centerV);
        return d0 <= (d1 = this.distToCenter(this.sprites[1], centerU, centerV)) ? this.sprites[0] : this.sprites[1];
    }

    private boolean isPointInSprite(float u, float v, TextureAtlasSprite s) {
        return u >= s.getU0() && u <= s.getU1() && v >= s.getV0() && v <= s.getV1();
    }

    private float distToCenter(TextureAtlasSprite s, float u, float v) {
        float cu = (s.getU0() + s.getU1()) * 0.5f;
        float cv = (s.getV0() + s.getV1()) * 0.5f;
        return (float)Math.sqrt(Math.pow(u - cu, 2.0) + Math.pow(v - cv, 2.0));
    }

    private void decideCoordinateSystem() {
        boolean inUnit;
        float minX = Float.POSITIVE_INFINITY;
        float maxX = Float.NEGATIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < Math.min(this.rawCount, 4); ++i) {
            float vx = this.rawPositions[i * 3];
            float vy = this.rawPositions[i * 3 + 1];
            float vz = this.rawPositions[i * 3 + 2];
            minX = Math.min(minX, vx);
            maxX = Math.max(maxX, vx);
            minY = Math.min(minY, vy);
            maxY = Math.max(maxY, vy);
            minZ = Math.min(minZ, vz);
            maxZ = Math.max(maxZ, vz);
        }
        boolean inChunkRange = minX >= -0.1f && maxX <= 16.1f && minY >= -0.1f && maxY <= 16.1f && minZ >= -0.1f && maxZ <= 16.1f;
        boolean bl = inUnit = minX >= -0.001f && maxX <= 1.001f && minY >= -0.001f && maxY <= 1.001f && minZ >= -0.001f && maxZ <= 1.001f;
        if (inChunkRange) {
            this.needsOffset = true;
            this.useChunkOffset = true;
            this.chunkOffsetX = Math.floorDiv(this.pos.getX(), 16) * 16;
            this.chunkOffsetY = Math.floorDiv(this.pos.getY(), 16) * 16;
            this.chunkOffsetZ = Math.floorDiv(this.pos.getZ(), 16) * 16;
        } else if (inUnit) {
            this.needsOffset = true;
            this.useChunkOffset = false;
        } else {
            this.needsOffset = false;
            this.useChunkOffset = false;
        }
    }

    private float[] applyOffsets(float x, float y, float z) {
        float wz;
        float wy;
        float wx;
        if (!this.needsOffset) {
            wx = x;
            wy = y;
            wz = z;
        } else if (this.useChunkOffset) {
            wx = (float)this.chunkOffsetX + x;
            wy = (float)this.chunkOffsetY + y;
            wz = (float)this.chunkOffsetZ + z;
        } else {
            wx = (float)this.pos.getX() + x;
            wy = (float)this.pos.getY() + y;
            wz = (float)this.pos.getZ() + z;
        }
        return new float[]{(float)((double)wx + this.offsetX), (float)((double)wy + this.offsetY), (float)((double)wz + this.offsetZ)};
    }

    private void recomputePositions() {
        for (int i = 0; i < Math.min(this.rawCount, 4); ++i) {
            float x = this.rawPositions[i * 3];
            float y = this.rawPositions[i * 3 + 1];
            float z = this.rawPositions[i * 3 + 2];
            float[] adj = this.applyOffsets(x, y, z);
            this.positions[i * 3] = adj[0];
            this.positions[i * 3 + 1] = adj[1];
            this.positions[i * 3 + 2] = adj[2];
        }
    }

    private boolean isBoundarySideQuad(float[] normal) {
        double minX = Double.POSITIVE_INFINITY;
        double maxX = Double.NEGATIVE_INFINITY;
        double minZ = Double.POSITIVE_INFINITY;
        double maxZ = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < 4; ++i) {
            minX = Math.min(minX, (double)this.positions[i * 3]);
            maxX = Math.max(maxX, (double)this.positions[i * 3]);
            minZ = Math.min(minZ, (double)this.positions[i * 3 + 2]);
            maxZ = Math.max(maxZ, (double)this.positions[i * 3 + 2]);
        }
        double eps = 0.001;
        return minX < this.regionMinX - eps || maxX > this.regionMaxX + eps || minZ < this.regionMinZ - eps || maxZ > this.regionMaxZ + eps;
    }

    private float[] computeFaceNormal(float[] p) {
        float ay = p[4] - p[1];
        float bz = p[8] - p[2];
        float az = p[5] - p[2];
        float by = p[7] - p[1];
        float nx = ay * bz - az * by;
        float bx = p[6] - p[0];
        float ax = p[3] - p[0];
        float ny = az * bx - ax * bz;
        float nz = ax * by - ay * bx;
        float l = (float)Math.sqrt(nx * nx + ny * ny + nz * nz);
        if (l == 0.0f) {
            return new float[]{0.0f, 1.0f, 0.0f};
        }
        return new float[]{nx / l, ny / l, nz / l};
    }

    private float clamp01(float v) {
        return v < 0.0f ? 0.0f : (v > 1.0f ? 1.0f : v);
    }

    private float[] whiteColor() {
        return new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f};
    }
}

