/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter.blockentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.AbstractTexture;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
final class BlockEntityAtlasLocator {
    private final Minecraft mc;

    BlockEntityAtlasLocator(Minecraft mc) {
        this.mc = mc;
    }

    TextureAtlasSprite find(ResourceLocation atlasLocation, float u, float v) {
        if (atlasLocation == null) {
            return null;
        }
        AbstractTexture tex = this.mc.getTextureManager().getTexture(atlasLocation);
        if (!(tex instanceof TextureAtlas)) {
            return null;
        }
        TextureAtlas atlas = (TextureAtlas)tex;
        for (TextureAtlasSprite sprite : atlas.getTextures().values()) {
            if (!this.contains(sprite, u, v)) continue;
            return sprite;
        }
        return null;
    }

    private boolean contains(TextureAtlasSprite sprite, float u, float v) {
        return u >= sprite.getU0() && u <= sprite.getU1() && v >= sprite.getV0() && v <= sprite.getV1();
    }
}

