/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.exporter.blockentity;

import com.voxelbridge.export.exporter.blockentity.RenderTypeTextureResolver;
import com.voxelbridge.util.ExportLogger;
import java.time.MonthDay;
import java.time.ZoneOffset;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CeilingHangingSignBlock;
import net.minecraft.world.level.block.ChestBlock;
import net.minecraft.world.level.block.EnderChestBlock;
import net.minecraft.world.level.block.SignBlock;
import net.minecraft.world.level.block.TrappedChestBlock;
import net.minecraft.world.level.block.WallHangingSignBlock;
import net.minecraft.world.level.block.WallSignBlock;
import net.minecraft.world.level.block.entity.BedBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.level.block.entity.EnderChestBlockEntity;
import net.minecraft.world.level.block.entity.HangingSignBlockEntity;
import net.minecraft.world.level.block.entity.SignBlockEntity;
import net.minecraft.world.level.block.state.properties.ChestType;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.WoodType;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public final class BlockEntityTextureResolver {
    private static final boolean IS_CHRISTMAS = BlockEntityTextureResolver.isChristmasWindow();

    private BlockEntityTextureResolver() {
    }

    public static ResolvedTexture resolve(BlockEntity blockEntity, RenderType renderType) {
        ResourceLocation base = RenderTypeTextureResolver.resolve(renderType);
        ResolvedTexture mapped = BlockEntityTextureResolver.resolveFromBlockEntity(blockEntity, base);
        if (mapped != null) {
            return mapped;
        }
        if (base != null) {
            return BlockEntityTextureResolver.resolveTextureWithAtlasDetection(base);
        }
        return null;
    }

    private static ResolvedTexture resolveTextureWithAtlasDetection(ResourceLocation texture) {
        ResourceLocation[] knownAtlases;
        for (ResourceLocation atlas : knownAtlases = new ResourceLocation[]{Sheets.CHEST_SHEET, Sheets.BED_SHEET, Sheets.SIGN_SHEET, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/atlas/decorated_pot.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/atlas/shulker_boxes.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/atlas/banner_patterns.png"), ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"textures/atlas/shield_patterns.png")}) {
            try {
                TextureAtlasSprite sprite;
                Function atlasGetter = Minecraft.getInstance().getTextureAtlas(atlas);
                if (atlasGetter == null || (sprite = (TextureAtlasSprite)atlasGetter.apply(texture)) == null || BlockEntityTextureResolver.isMissingSprite(sprite)) continue;
                ExportLogger.log("[BlockEntityTextureResolver] Found texture " + String.valueOf(texture) + " in atlas " + String.valueOf(atlas));
                return new ResolvedTexture(texture, sprite.getU0(), sprite.getU1(), sprite.getV0(), sprite.getV1(), true, sprite, atlas);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (texture != null && texture.getPath().startsWith("textures/atlas/")) {
            ExportLogger.log("[BlockEntityTextureResolver] Atlas texture not resolved via sprite, using full atlas: " + String.valueOf(texture));
            return new ResolvedTexture(texture, 0.0f, 1.0f, 0.0f, 1.0f, true, null, texture);
        }
        ExportLogger.log("[BlockEntityTextureResolver] Texture not in any atlas, treating as standalone: " + String.valueOf(texture));
        return new ResolvedTexture(texture, 0.0f, 1.0f, 0.0f, 1.0f, false, null, null);
    }

    private static boolean isMissingSprite(TextureAtlasSprite sprite) {
        return sprite.contents().name().toString().contains("missingno");
    }

    private static ResolvedTexture resolveFromBlockEntity(BlockEntity blockEntity, ResourceLocation current) {
        if (blockEntity == null) {
            return null;
        }
        if (blockEntity instanceof EnderChestBlockEntity) {
            ResourceLocation tex = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entity/chest/ender");
            return BlockEntityTextureResolver.resolveTextureInAtlas(Sheets.CHEST_SHEET, tex);
        }
        if (blockEntity instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)blockEntity;
            return BlockEntityTextureResolver.resolveChestTexture(chest);
        }
        if (blockEntity instanceof BedBlockEntity) {
            BedBlockEntity bed = (BedBlockEntity)blockEntity;
            DyeColor color = bed.getColor();
            ResourceLocation tex = ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("entity/bed/" + color.getName()));
            return BlockEntityTextureResolver.resolveTextureInAtlas(Sheets.BED_SHEET, tex);
        }
        if (blockEntity instanceof HangingSignBlockEntity) {
            HangingSignBlockEntity hangingSign = (HangingSignBlockEntity)blockEntity;
            return BlockEntityTextureResolver.resolveSignTexture(hangingSign.getBlockState().getBlock(), true);
        }
        if (blockEntity instanceof SignBlockEntity) {
            SignBlockEntity sign = (SignBlockEntity)blockEntity;
            return BlockEntityTextureResolver.resolveSignTexture(sign.getBlockState().getBlock(), false);
        }
        return null;
    }

    private static ResolvedTexture resolveChestTexture(ChestBlockEntity chest) {
        ChestType type;
        Block block = chest.getBlockState().getBlock();
        if (block instanceof EnderChestBlock) {
            return BlockEntityTextureResolver.resolveTextureInAtlas(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)"entity/chest/ender"));
        }
        boolean isTrapped = block instanceof TrappedChestBlock;
        boolean isChristmas = IS_CHRISTMAS;
        ChestType chestType = type = chest.getBlockState().hasProperty((Property)ChestBlock.TYPE) ? (ChestType)chest.getBlockState().getValue((Property)ChestBlock.TYPE) : ChestType.SINGLE;
        String base = isChristmas ? "christmas" : (isTrapped ? "trapped" : "normal");
        String suffix = switch (type) {
            case ChestType.LEFT -> "_left";
            case ChestType.RIGHT -> "_right";
            default -> "";
        };
        return BlockEntityTextureResolver.resolveTextureInAtlas(Sheets.CHEST_SHEET, ResourceLocation.fromNamespaceAndPath((String)"minecraft", (String)("entity/chest/" + base + suffix)));
    }

    private static ResolvedTexture resolveSignTexture(Block block, boolean hanging) {
        WoodType woodType = BlockEntityTextureResolver.extractWoodType(block);
        if (woodType == null) {
            return null;
        }
        ResourceLocation woodId = ResourceLocation.tryParse((String)woodType.name());
        String namespace = woodId != null ? woodId.getNamespace() : "minecraft";
        String path = woodId != null ? woodId.getPath() : woodType.name();
        String prefix = hanging ? "entity/signs/hanging/" : "entity/signs/";
        ResourceLocation texture = ResourceLocation.fromNamespaceAndPath((String)namespace, (String)(prefix + path));
        return BlockEntityTextureResolver.resolveTextureInAtlas(Sheets.SIGN_SHEET, texture);
    }

    private static WoodType extractWoodType(Block block) {
        if (block instanceof SignBlock) {
            SignBlock sign = (SignBlock)block;
            return sign.type();
        }
        if (block instanceof WallSignBlock) {
            WallSignBlock wallSign = (WallSignBlock)block;
            return wallSign.type();
        }
        if (block instanceof CeilingHangingSignBlock) {
            CeilingHangingSignBlock hangingSign = (CeilingHangingSignBlock)block;
            return hangingSign.type();
        }
        if (block instanceof WallHangingSignBlock) {
            WallHangingSignBlock wallHangingSign = (WallHangingSignBlock)block;
            return wallHangingSign.type();
        }
        return null;
    }

    private static boolean isChristmasWindow() {
        MonthDay today = MonthDay.now(ZoneOffset.UTC);
        MonthDay start = MonthDay.of(12, 24);
        MonthDay end = MonthDay.of(12, 26);
        return !today.isBefore(start) && !today.isAfter(end);
    }

    private static ResolvedTexture resolveTextureInAtlas(ResourceLocation atlas, ResourceLocation texture) {
        if (atlas == null || texture == null) {
            ExportLogger.log("[BlockEntityTextureResolver] Null atlas or texture, using fallback");
            return new ResolvedTexture(texture, 0.0f, 1.0f, 0.0f, 1.0f, false, null, atlas);
        }
        try {
            TextureAtlasSprite atlasSprite;
            Function atlasGetter = Minecraft.getInstance().getTextureAtlas(atlas);
            if (atlasGetter != null && (atlasSprite = (TextureAtlasSprite)atlasGetter.apply(texture)) != null && !BlockEntityTextureResolver.isMissingSprite(atlasSprite)) {
                ExportLogger.log("[BlockEntityTextureResolver] Resolved sprite for " + String.valueOf(texture) + " in atlas " + String.valueOf(atlas) + " UV: [" + atlasSprite.getU0() + "," + atlasSprite.getU1() + "] x [" + atlasSprite.getV0() + "," + atlasSprite.getV1() + "]");
                return new ResolvedTexture(texture, atlasSprite.getU0(), atlasSprite.getU1(), atlasSprite.getV0(), atlasSprite.getV1(), true, atlasSprite, atlas);
            }
        }
        catch (Exception e) {
            ExportLogger.log("[BlockEntityTextureResolver] Failed to resolve sprite: " + e.getMessage());
        }
        if (texture != null && texture.getPath().startsWith("textures/atlas/")) {
            ExportLogger.log("[BlockEntityTextureResolver] Atlas texture not resolved via sprite, using full atlas: " + String.valueOf(texture));
            return new ResolvedTexture(texture, 0.0f, 1.0f, 0.0f, 1.0f, true, null, texture);
        }
        ExportLogger.log("[BlockEntityTextureResolver] Texture not in atlas, treating as standalone: " + String.valueOf(texture));
        return new ResolvedTexture(texture, 0.0f, 1.0f, 0.0f, 1.0f, false, null, null);
    }

    public record ResolvedTexture(ResourceLocation texture, float u0, float u1, float v0, float v1, boolean isAtlasTexture, TextureAtlasSprite sprite, ResourceLocation atlasLocation) {
    }
}

