/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.scene;

import com.voxelbridge.export.scene.SceneSink;
import com.voxelbridge.export.scene.SceneWriteRequest;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public final class BufferedSceneSink
implements SceneSink {
    private final List<QuadRecord> buffer = new ArrayList<QuadRecord>();

    @Override
    public void addQuad(String materialGroupKey, String spriteKey, String overlaySpriteKey, float[] positions, float[] uv0, float[] uv1, float[] normal, float[] colors, boolean doubleSided) {
        this.buffer.add(new QuadRecord(materialGroupKey, spriteKey, overlaySpriteKey, positions, uv0, uv1, normal, colors, doubleSided));
    }

    @Override
    public Path write(SceneWriteRequest request) throws IOException {
        throw new UnsupportedOperationException("Buffered sink cannot write to file directly. Use flushTo().");
    }

    public void flushTo(SceneSink target) {
        for (QuadRecord q : this.buffer) {
            target.addQuad(q.materialGroupKey, q.spriteKey, q.overlaySpriteKey, q.positions, q.uv0, q.uv1, q.normal, q.colors, q.doubleSided);
        }
        this.buffer.clear();
    }

    public boolean isEmpty() {
        return this.buffer.isEmpty();
    }

    public int getQuadCount() {
        return this.buffer.size();
    }

    private record QuadRecord(String materialGroupKey, String spriteKey, String overlaySpriteKey, float[] positions, float[] uv0, float[] uv1, float[] normal, float[] colors, boolean doubleSided) {
    }
}

