/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.scene.gltf;

import java.io.ByteArrayOutputStream;

final class BinaryChunk {
    private final ByteArrayOutputStream out = new ByteArrayOutputStream();

    BinaryChunk() {
    }

    int size() {
        return this.out.size();
    }

    int writeFloatArray(float[] values) {
        int offset = this.align(4);
        for (float v : values) {
            this.writeInt(Float.floatToIntBits(v));
        }
        return offset;
    }

    int writeIntArray(int[] values) {
        int offset = this.align(4);
        for (int v : values) {
            this.writeInt(v);
        }
        return offset;
    }

    byte[] toByteArray() {
        return this.out.toByteArray();
    }

    private int align(int alignment) {
        int padding = (alignment - this.out.size() % alignment) % alignment;
        for (int i = 0; i < padding; ++i) {
            this.out.write(0);
        }
        return this.out.size();
    }

    private void writeInt(int value) {
        this.out.write(value & 0xFF);
        this.out.write(value >> 8 & 0xFF);
        this.out.write(value >> 16 & 0xFF);
        this.out.write(value >> 24 & 0xFF);
    }
}

