/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.scene.gltf;

import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;

public final class BlockEntityAtlasPacker {
    private final int atlasSize;
    private final List<TextureEntry> textures = new ArrayList<TextureEntry>();
    private final boolean powerOfTwo;

    public BlockEntityAtlasPacker(int atlasSize, boolean powerOfTwo) {
        this.atlasSize = atlasSize;
        this.powerOfTwo = powerOfTwo;
    }

    public void addTexture(String spriteKey, BufferedImage image) {
        this.textures.add(new TextureEntry(spriteKey, image));
    }

    public Map<String, Placement> pack(Path outputDir, String prefix) throws IOException {
        LinkedHashMap<String, Placement> placements = new LinkedHashMap<String, Placement>();
        ArrayList<AtlasPage> pages = new ArrayList<AtlasPage>();
        this.textures.sort(Comparator.comparingInt(t -> Math.max(t.image.getWidth(), t.image.getHeight())).reversed().thenComparing(t -> t.spriteKey));
        for (TextureEntry entry : this.textures) {
            Rect rect;
            boolean placed = false;
            Rect bestRect = null;
            int bestPageIndex = -1;
            for (int i = 0; i < pages.size(); ++i) {
                rect = ((AtlasPage)pages.get(i)).insert(entry.image.getWidth(), entry.image.getHeight());
                if (rect == null || bestRect != null && rect.score >= bestRect.score) continue;
                bestRect = rect;
                bestPageIndex = i;
            }
            if (bestRect != null) {
                placed = true;
                ((AtlasPage)pages.get(bestPageIndex)).placeRect(bestRect, entry.image);
                int udim = 1001 + bestPageIndex % 10 + bestPageIndex / 10 * 10;
                placements.put(entry.spriteKey, new Placement(bestPageIndex, udim, bestRect.x, bestRect.y, entry.image.getWidth(), entry.image.getHeight()));
            }
            if (placed) continue;
            AtlasPage newPage = new AtlasPage(this.atlasSize, this.powerOfTwo);
            rect = newPage.insert(entry.image.getWidth(), entry.image.getHeight());
            if (rect == null) {
                throw new IOException("Texture too large for atlas: " + entry.spriteKey + " (" + entry.image.getWidth() + "x" + entry.image.getHeight() + ")");
            }
            pages.add(newPage);
            int pageIdx = pages.size() - 1;
            newPage.placeRect(rect, entry.image);
            int udim = 1001 + pageIdx % 10 + pageIdx / 10 * 10;
            placements.put(entry.spriteKey, new Placement(pageIdx, udim, rect.x, rect.y, entry.image.getWidth(), entry.image.getHeight()));
        }
        for (int i = 0; i < pages.size(); ++i) {
            int udim = 1001 + i % 10 + i / 10 * 10;
            String filename = prefix + udim + ".png";
            Path outputPath = outputDir.resolve(filename);
            ImageIO.write((RenderedImage)((AtlasPage)pages.get((int)i)).image, "png", outputPath.toFile());
            System.out.println("[BlockEntityAtlasPacker] Wrote atlas page: " + filename);
        }
        return placements;
    }

    private static class TextureEntry {
        final String spriteKey;
        final BufferedImage image;

        TextureEntry(String spriteKey, BufferedImage image) {
            this.spriteKey = spriteKey;
            this.image = image;
        }

        int getLargestDimension() {
            return Math.max(this.image.getWidth(), this.image.getHeight());
        }
    }

    private static class AtlasPage {
        final BufferedImage image;
        final int width;
        final int height;
        final List<Rect> freeRects = new ArrayList<Rect>();

        AtlasPage(int size, boolean powerOfTwo) {
            this.width = size;
            this.height = size;
            this.image = new BufferedImage(this.width, this.height, 2);
            this.freeRects.add(new Rect(0, 0, this.width, this.height));
        }

        Rect insert(int w, int h) {
            Rect bestRect = new Rect(0, 0, 0, 0);
            bestRect.score = Integer.MAX_VALUE;
            int bestNodeIndex = -1;
            for (int i = 0; i < this.freeRects.size(); ++i) {
                int score;
                Rect free = this.freeRects.get(i);
                if (free.width < w || free.height < h || (score = Math.min(free.width - w, free.height - h)) >= bestRect.score) continue;
                bestRect.x = free.x;
                bestRect.y = free.y;
                bestRect.width = w;
                bestRect.height = h;
                bestRect.score = score;
                bestNodeIndex = i;
            }
            if (bestNodeIndex == -1) {
                return null;
            }
            this.splitFreeNode(this.freeRects.get(bestNodeIndex), bestRect);
            this.freeRects.remove(bestNodeIndex);
            this.pruneFreeList();
            return bestRect;
        }

        void placeRect(Rect rect, BufferedImage texture) {
            Graphics2D g = this.image.createGraphics();
            g.drawImage((Image)texture, rect.x, rect.y, null);
            g.dispose();
        }

        private void splitFreeNode(Rect freeNode, Rect usedNode) {
            int freeRight;
            int usedRight;
            int freeBottom;
            int usedBottom;
            if (usedNode.x >= freeNode.x + freeNode.width || usedNode.x + usedNode.width <= freeNode.x || usedNode.y >= freeNode.y + freeNode.height || usedNode.y + usedNode.height <= freeNode.y) {
                return;
            }
            if (usedNode.y > freeNode.y) {
                this.freeRects.add(new Rect(freeNode.x, freeNode.y, freeNode.width, usedNode.y - freeNode.y));
            }
            if ((usedBottom = usedNode.y + usedNode.height) < (freeBottom = freeNode.y + freeNode.height)) {
                this.freeRects.add(new Rect(freeNode.x, usedBottom, freeNode.width, freeBottom - usedBottom));
            }
            if (usedNode.x > freeNode.x) {
                this.freeRects.add(new Rect(freeNode.x, usedNode.y, usedNode.x - freeNode.x, usedNode.height));
            }
            if ((usedRight = usedNode.x + usedNode.width) < (freeRight = freeNode.x + freeNode.width)) {
                this.freeRects.add(new Rect(usedRight, usedNode.y, freeRight - usedRight, usedNode.height));
            }
        }

        private void pruneFreeList() {
            block0: for (int i = 0; i < this.freeRects.size(); ++i) {
                for (int j = i + 1; j < this.freeRects.size(); ++j) {
                    Rect r2;
                    Rect r1 = this.freeRects.get(i);
                    if (this.isContainedIn(r1, r2 = this.freeRects.get(j))) {
                        this.freeRects.remove(i--);
                        continue block0;
                    }
                    if (!this.isContainedIn(r2, r1)) continue;
                    this.freeRects.remove(j--);
                }
            }
        }

        private boolean isContainedIn(Rect a, Rect b) {
            return a.x >= b.x && a.y >= b.y && a.x + a.width <= b.x + b.width && a.y + a.height <= b.y + b.height;
        }
    }

    private static class Rect {
        int x;
        int y;
        int width;
        int height;
        int score;

        Rect(int x, int y, int width, int height) {
            this.x = x;
            this.y = y;
            this.width = width;
            this.height = height;
        }
    }

    public static class Placement {
        private final int page;
        private final int udim;
        private final int x;
        private final int y;
        private final int w;
        private final int h;

        Placement(int page, int udim, int x, int y, int w, int h) {
            this.page = page;
            this.udim = udim;
            this.x = x;
            this.y = y;
            this.w = w;
            this.h = h;
        }

        public int page() {
            return this.page;
        }

        public int udim() {
            return this.udim;
        }

        public int x() {
            return this.x;
        }

        public int y() {
            return this.y;
        }

        public int width() {
            return this.w;
        }

        public int height() {
            return this.h;
        }
    }
}

