/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.scene.gltf;

import java.util.Arrays;

final class FloatList {
    private float[] data = new float[256];
    private int size = 0;

    FloatList() {
    }

    void add(float value) {
        this.ensure(this.size + 1);
        this.data[this.size++] = value;
    }

    void addAll(float[] values) {
        this.ensure(this.size + values.length);
        for (float v : values) {
            this.data[this.size++] = v;
        }
    }

    int size() {
        return this.size;
    }

    float[] toArray() {
        return Arrays.copyOf(this.data, this.size);
    }

    float get(int idx) {
        return this.data[idx];
    }

    private void ensure(int needed) {
        int newLength;
        if (needed <= this.data.length) {
            return;
        }
        for (newLength = this.data.length; newLength < needed; newLength <<= 1) {
        }
        this.data = Arrays.copyOf(this.data, newLength);
    }

    float[] computeMin() {
        if (this.size == 0) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        float minX = Float.POSITIVE_INFINITY;
        float minY = Float.POSITIVE_INFINITY;
        float minZ = Float.POSITIVE_INFINITY;
        for (int i = 0; i < this.size; i += 3) {
            float x = this.data[i];
            float y = this.data[i + 1];
            float z = this.data[i + 2];
            if (x < minX) {
                minX = x;
            }
            if (y < minY) {
                minY = y;
            }
            if (!(z < minZ)) continue;
            minZ = z;
        }
        return new float[]{minX, minY, minZ};
    }

    float[] computeMax() {
        if (this.size == 0) {
            return new float[]{0.0f, 0.0f, 0.0f};
        }
        float maxX = Float.NEGATIVE_INFINITY;
        float maxY = Float.NEGATIVE_INFINITY;
        float maxZ = Float.NEGATIVE_INFINITY;
        for (int i = 0; i < this.size; i += 3) {
            float x = this.data[i];
            float y = this.data[i + 1];
            float z = this.data[i + 2];
            if (x > maxX) {
                maxX = x;
            }
            if (y > maxY) {
                maxY = y;
            }
            if (!(z > maxZ)) continue;
            maxZ = z;
        }
        return new float[]{maxX, maxY, maxZ};
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    void clear() {
        this.size = 0;
    }
}

