/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.scene.gltf;

import com.voxelbridge.config.ExportRuntimeConfig;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.scene.SceneSink;
import com.voxelbridge.export.scene.SceneWriteRequest;
import com.voxelbridge.export.scene.gltf.BinaryChunk;
import com.voxelbridge.export.scene.gltf.PrimitiveData;
import com.voxelbridge.export.scene.gltf.TextureRegistry;
import com.voxelbridge.export.texture.ColorMapManager;
import com.voxelbridge.export.texture.TextureAtlasManager;
import com.voxelbridge.shadow.jgltf.impl.v2.Accessor;
import com.voxelbridge.shadow.jgltf.impl.v2.Asset;
import com.voxelbridge.shadow.jgltf.impl.v2.Buffer;
import com.voxelbridge.shadow.jgltf.impl.v2.BufferView;
import com.voxelbridge.shadow.jgltf.impl.v2.GlTF;
import com.voxelbridge.shadow.jgltf.impl.v2.Image;
import com.voxelbridge.shadow.jgltf.impl.v2.Material;
import com.voxelbridge.shadow.jgltf.impl.v2.MaterialPbrMetallicRoughness;
import com.voxelbridge.shadow.jgltf.impl.v2.Mesh;
import com.voxelbridge.shadow.jgltf.impl.v2.MeshPrimitive;
import com.voxelbridge.shadow.jgltf.impl.v2.Node;
import com.voxelbridge.shadow.jgltf.impl.v2.Sampler;
import com.voxelbridge.shadow.jgltf.impl.v2.Scene;
import com.voxelbridge.shadow.jgltf.impl.v2.Texture;
import com.voxelbridge.shadow.jgltf.impl.v2.TextureInfo;
import com.voxelbridge.shadow.jgltf.model.io.GltfAsset;
import com.voxelbridge.shadow.jgltf.model.io.GltfAssetWriter;
import com.voxelbridge.shadow.jgltf.model.io.v2.GltfAssetV2;
import com.voxelbridge.util.ExportLogger;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;

public final class GltfSceneBuilder
implements SceneSink {
    private final ExportContext ctx;
    private final Path texturesDir;
    private final TextureRegistry textureRegistry;
    private final List<GltfQuadRecord> bufferedQuads = new ArrayList<GltfQuadRecord>();
    private final Object lock = new Object();

    public GltfSceneBuilder(ExportContext ctx, Path outDir) {
        this.ctx = ctx;
        this.texturesDir = outDir.resolve("textures");
        this.textureRegistry = new TextureRegistry(ctx, outDir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addQuad(String materialGroupKey, String spriteKey, String overlaySpriteKey, float[] positions, float[] uv0, float[] uv1, float[] normal, float[] colors, boolean doubleSided) {
        boolean isBlockEntityTexture;
        if (materialGroupKey == null || spriteKey == null) {
            return;
        }
        boolean bl = isBlockEntityTexture = spriteKey.startsWith("blockentity:") || spriteKey.startsWith("entity:") || spriteKey.startsWith("base:");
        if (!isBlockEntityTexture) {
            TextureAtlasManager.registerTint(this.ctx, spriteKey, 0xFFFFFF);
        }
        Object object = this.lock;
        synchronized (object) {
            this.bufferedQuads.add(new GltfQuadRecord(materialGroupKey, spriteKey, overlaySpriteKey, positions, uv0, uv1, normal, colors, doubleSided));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path write(SceneWriteRequest request) throws IOException {
        Object object = this.lock;
        synchronized (object) {
            return this.writeInternal(request);
        }
    }

    private Path writeInternal(SceneWriteRequest request) throws IOException {
        ColorMapManager.generateColorMaps(this.ctx, request.outputDir());
        LinkedHashMap<String, PrimitiveData> primitiveMap = new LinkedHashMap<String, PrimitiveData>();
        for (GltfQuadRecord q : this.bufferedQuads) {
            String overlaySpriteKey;
            PrimitiveData data;
            int[] verts;
            String spriteKey = q.spriteKey;
            Object primitiveKey = q.materialGroupKey;
            if ("overlay".equals(q.overlaySpriteKey)) {
                primitiveKey = q.materialGroupKey + "_overlay";
            }
            if ((verts = (data = primitiveMap.computeIfAbsent((String)primitiveKey, k -> new PrimitiveData(q.materialGroupKey))).registerQuad(spriteKey, overlaySpriteKey = q.overlaySpriteKey, q.positions, q.uv0, q.uv1, q.colors)) == null) continue;
            data.doubleSided |= q.doubleSided;
            data.addTriangle(verts[0], verts[1], verts[2]);
            data.addTriangle(verts[0], verts[2], verts[3]);
        }
        GlTF gltf = new GlTF();
        Asset asset = new Asset();
        asset.setVersion("2.0");
        asset.setGenerator("VoxelBridge");
        gltf.setAsset(asset);
        Path binPath = request.outputDir().resolve(request.baseName() + ".bin");
        Buffer buffer = new Buffer();
        buffer.setUri(binPath.getFileName().toString());
        gltf.addBuffers(buffer);
        BinaryChunk chunk = new BinaryChunk();
        ArrayList<Material> materials = new ArrayList<Material>();
        ArrayList<Mesh> meshes = new ArrayList<Mesh>();
        ArrayList<Node> nodes = new ArrayList<Node>();
        ArrayList<Texture> textures = new ArrayList<Texture>();
        ArrayList<Image> images = new ArrayList<Image>();
        ArrayList<Sampler> samplers = new ArrayList<Sampler>();
        Sampler sampler = new Sampler();
        sampler.setMagFilter(9728);
        sampler.setMinFilter(9728);
        sampler.setWrapS(10497);
        sampler.setWrapT(10497);
        samplers.add(sampler);
        gltf.setSamplers(samplers);
        List<Integer> colorMapIndices = this.registerColorMapTextures(request.outputDir(), textures, images, 0);
        HashMap materialIndices = new HashMap();
        for (Map.Entry entry : primitiveMap.entrySet()) {
            String primitiveKey = (String)entry.getKey();
            PrimitiveData data = (PrimitiveData)entry.getValue();
            if (data.vertexCount == 0) continue;
            if (ExportRuntimeConfig.getAtlasMode() == ExportRuntimeConfig.AtlasMode.ATLAS) {
                float[] uvs = data.uv0.toArray();
                for (PrimitiveData.SpriteRange range : data.spriteRanges) {
                    for (int i = 0; i < range.count(); ++i) {
                        int vIdx = range.startVertexIndex() + i;
                        float u = uvs[vIdx * 2];
                        float v = uvs[vIdx * 2 + 1];
                        float[] newUV = this.remapUV(range.spriteKey(), u, v);
                        uvs[vIdx * 2] = newUV[0];
                        uvs[vIdx * 2 + 1] = newUV[1];
                    }
                }
                data.uv0.clear();
                data.uv0.addAll(uvs);
            }
            int posOffset = chunk.writeFloatArray(data.positions.toArray());
            int posView = this.addView(gltf, 0, posOffset, data.positions.size() * 4, 34962);
            int posAcc = this.addAccessor(gltf, posView, data.vertexCount, "VEC3", 5126, data.positionMin(), data.positionMax());
            int texAcc = -1;
            if (!data.uv0.isEmpty()) {
                int off = chunk.writeFloatArray(data.uv0.toArray());
                int view = this.addView(gltf, 0, off, data.uv0.size() * 4, 34962);
                texAcc = this.addAccessor(gltf, view, data.vertexCount, "VEC2", 5126, null, null);
            }
            int uv1Acc = -1;
            if (!data.uv1.isEmpty()) {
                int off = chunk.writeFloatArray(data.uv1.toArray());
                int view = this.addView(gltf, 0, off, data.uv1.size() * 4, 34962);
                uv1Acc = this.addAccessor(gltf, view, data.vertexCount, "VEC2", 5126, null, null);
            }
            int idxOffset = chunk.writeIntArray(data.indices.toArray());
            int idxView = this.addView(gltf, 0, idxOffset, data.indices.size() * 4, 34963);
            int idxAcc = this.addAccessor(gltf, idxView, data.indices.size(), "SCALAR", 5125, null, null);
            String sampleSprite = data.spriteRanges.get(0).spriteKey();
            int textureIndex = this.textureRegistry.ensureSpriteTexture(sampleSprite, textures, images);
            Material material = new Material();
            material.setName(data.materialGroupKey);
            MaterialPbrMetallicRoughness pbr = new MaterialPbrMetallicRoughness();
            TextureInfo texInfo = new TextureInfo();
            texInfo.setIndex(textureIndex);
            pbr.setBaseColorTexture(texInfo);
            pbr.setMetallicFactor(Float.valueOf(0.0f));
            pbr.setRoughnessFactor(Float.valueOf(1.0f));
            material.setPbrMetallicRoughness(pbr);
            material.setDoubleSided(data.doubleSided);
            HashMap<String, Object> extras = new HashMap<String, Object>();
            if (!colorMapIndices.isEmpty()) {
                extras.put("voxelbridge:colormapTextures", colorMapIndices);
                extras.put("voxelbridge:colormapUV", 1);
            }
            if (!extras.isEmpty()) {
                material.setExtras(extras);
            }
            materials.add(material);
            int matIndex = materials.size() - 1;
            MeshPrimitive prim = new MeshPrimitive();
            LinkedHashMap<String, Integer> attrs = new LinkedHashMap<String, Integer>();
            attrs.put("POSITION", posAcc);
            if (texAcc >= 0) {
                attrs.put("TEXCOORD_0", texAcc);
            }
            if (uv1Acc >= 0) {
                attrs.put("TEXCOORD_1", uv1Acc);
            }
            prim.setAttributes(attrs);
            prim.setIndices(idxAcc);
            prim.setMaterial(matIndex);
            prim.setMode(4);
            Mesh mesh = new Mesh();
            mesh.setName(primitiveKey);
            mesh.setPrimitives(Collections.singletonList(prim));
            meshes.add(mesh);
            Node node = new Node();
            node.setName(primitiveKey);
            node.setMesh(meshes.size() - 1);
            nodes.add(node);
        }
        if (meshes.isEmpty()) {
            throw new IOException("No geometry generated.");
        }
        gltf.setMeshes(meshes);
        gltf.setNodes(nodes);
        gltf.setMaterials(materials);
        gltf.setTextures(textures);
        gltf.setImages(images);
        Scene scene = new Scene();
        ArrayList<Integer> nodeIndices = new ArrayList<Integer>();
        for (int i = 0; i < nodes.size(); ++i) {
            nodeIndices.add(i);
        }
        scene.setNodes(nodeIndices);
        gltf.addScenes(scene);
        gltf.setScene(0);
        byte[] bytes = chunk.toByteArray();
        buffer.setByteLength(bytes.length);
        Files.write(binPath, bytes, new OpenOption[0]);
        GltfAssetV2 assetModel = new GltfAssetV2(gltf, ByteBuffer.wrap(bytes));
        GltfAssetWriter writer = new GltfAssetWriter();
        writer.writeJson((GltfAsset)assetModel, request.outputDir().resolve(request.baseName() + ".gltf").toFile());
        return request.outputDir().resolve(request.baseName() + ".gltf");
    }

    private float[] remapUV(String spriteKey, float u, float v) {
        if (spriteKey.startsWith("blockentity:") || spriteKey.startsWith("entity:") || spriteKey.startsWith("base:")) {
            ExportContext.BlockEntityAtlasPlacement p = this.ctx.getBlockEntityAtlasPlacements().get(spriteKey);
            if (p == null && spriteKey.startsWith("entity:")) {
                String altKey = "blockentity:" + spriteKey.substring("entity:".length());
                p = this.ctx.getBlockEntityAtlasPlacements().get(altKey);
            } else if (p == null && spriteKey.startsWith("blockentity:")) {
                String altKey = "entity:" + spriteKey.substring("blockentity:".length());
                p = this.ctx.getBlockEntityAtlasPlacements().get(altKey);
            }
            if (p != null) {
                return new float[]{p.u0() + u * (p.u1() - p.u0()), p.v0() + v * (p.v1() - p.v0())};
            }
            ExportLogger.log(String.format("[RemapUV][WARN] No BlockEntity atlas placement found for '%s' - UV will remain in sprite space (0-1). This may indicate the texture was not packed into the atlas.", spriteKey));
            return new float[]{u, v};
        }
        return TextureAtlasManager.remapUV(this.ctx, spriteKey, 0xFFFFFF, u, v);
    }

    private int addView(GlTF gltf, int bufferIndex, int byteOffset, int byteLength, int target) {
        BufferView view = new BufferView();
        view.setBuffer(bufferIndex);
        view.setByteOffset(byteOffset);
        view.setByteLength(byteLength);
        view.setTarget(target);
        gltf.addBufferViews(view);
        return gltf.getBufferViews().size() - 1;
    }

    private int addAccessor(GlTF gltf, int bufferView, int count, String type, int componentType, float[] min, float[] max) {
        Accessor accessor = new Accessor();
        accessor.setBufferView(bufferView);
        accessor.setComponentType(componentType);
        accessor.setCount(count);
        accessor.setType(type);
        if (min != null) {
            accessor.setMin(this.toNumbers(min));
        }
        if (max != null) {
            accessor.setMax(this.toNumbers(max));
        }
        gltf.addAccessors(accessor);
        return gltf.getAccessors().size() - 1;
    }

    private Number[] toNumbers(float[] values) {
        Number[] arr = new Number[values.length];
        for (int i = 0; i < values.length; ++i) {
            arr[i] = Float.valueOf(values[i]);
        }
        return arr;
    }

    private List<Integer> registerColorMapTextures(Path outDir, List<Texture> textures, List<Image> images, int samplerIndex) throws IOException {
        List<Path> pages;
        Path dir = outDir.resolve("textures/colormap");
        if (!Files.exists(dir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.list(dir);){
            pages = stream.filter(p -> p.getFileName().toString().startsWith("colormap_")).sorted().toList();
        }
        ArrayList<Integer> indices = new ArrayList<Integer>();
        for (Path png : pages) {
            Image image = new Image();
            image.setUri("textures/colormap/" + png.getFileName().toString());
            images.add(image);
            Texture texture = new Texture();
            texture.setSource(images.size() - 1);
            texture.setSampler(samplerIndex);
            textures.add(texture);
            indices.add(textures.size() - 1);
        }
        return indices;
    }

    private record GltfQuadRecord(String materialGroupKey, String spriteKey, String overlaySpriteKey, float[] positions, float[] uv0, float[] uv1, float[] normal, float[] colors, boolean doubleSided) {
    }
}

