/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.scene.gltf;

import com.voxelbridge.export.scene.gltf.FloatList;
import com.voxelbridge.export.scene.gltf.IntList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

final class PrimitiveData {
    final String materialGroupKey;
    final FloatList positions = new FloatList();
    final FloatList uv0 = new FloatList();
    final FloatList uv1 = new FloatList();
    final FloatList colors = new FloatList();
    final IntList indices = new IntList();
    final Map<VertexKey, Integer> vertexLookup = new HashMap<VertexKey, Integer>();
    final Set<QuadKey> quadKeys = new HashSet<QuadKey>();
    int vertexCount = 0;
    boolean doubleSided = false;
    final List<SpriteRange> spriteRanges = new ArrayList<SpriteRange>();

    PrimitiveData(String materialGroupKey) {
        this.materialGroupKey = materialGroupKey;
    }

    int[] registerQuad(String spriteKey, String overlaySpriteKey, float[] pos, float[] uv, float[] uv1In, float[] col) {
        int startVert = this.vertexCount;
        int[] order = this.sortQuadCCW(pos);
        int spriteHash = Objects.hash(spriteKey, overlaySpriteKey);
        int v0 = this.registerVertex(spriteHash, pos[order[0] * 3], pos[order[0] * 3 + 1], pos[order[0] * 3 + 2], uv[order[0] * 2], uv[order[0] * 2 + 1], uv1In != null ? uv1In[order[0] * 2] : 0.0f, uv1In != null ? uv1In[order[0] * 2 + 1] : 0.0f, col[order[0] * 4], col[order[0] * 4 + 1], col[order[0] * 4 + 2], col[order[0] * 4 + 3]);
        int v1 = this.registerVertex(spriteHash, pos[order[1] * 3], pos[order[1] * 3 + 1], pos[order[1] * 3 + 2], uv[order[1] * 2], uv[order[1] * 2 + 1], uv1In != null ? uv1In[order[1] * 2] : 0.0f, uv1In != null ? uv1In[order[1] * 2 + 1] : 0.0f, col[order[1] * 4], col[order[1] * 4 + 1], col[order[1] * 4 + 2], col[order[1] * 4 + 3]);
        int v2 = this.registerVertex(spriteHash, pos[order[2] * 3], pos[order[2] * 3 + 1], pos[order[2] * 3 + 2], uv[order[2] * 2], uv[order[2] * 2 + 1], uv1In != null ? uv1In[order[2] * 2] : 0.0f, uv1In != null ? uv1In[order[2] * 2 + 1] : 0.0f, col[order[2] * 4], col[order[2] * 4 + 1], col[order[2] * 4 + 2], col[order[2] * 4 + 3]);
        int v3 = this.registerVertex(spriteHash, pos[order[3] * 3], pos[order[3] * 3 + 1], pos[order[3] * 3 + 2], uv[order[3] * 2], uv[order[3] * 2 + 1], uv1In != null ? uv1In[order[3] * 2] : 0.0f, uv1In != null ? uv1In[order[3] * 2 + 1] : 0.0f, col[order[3] * 4], col[order[3] * 4 + 1], col[order[3] * 4 + 2], col[order[3] * 4 + 3]);
        if (v0 == v1 || v1 == v2 || v2 == v3 || v0 == v3) {
            return null;
        }
        QuadKey qk = QuadKey.from(v0, v1, v2, v3);
        if (!this.quadKeys.add(qk)) {
            return null;
        }
        int addedCount = this.vertexCount - startVert;
        if (addedCount > 0) {
            if (!this.spriteRanges.isEmpty()) {
                SpriteRange last = this.spriteRanges.get(this.spriteRanges.size() - 1);
                if (last.spriteKey.equals(spriteKey) && (overlaySpriteKey == null ? last.overlaySpriteKey == null : overlaySpriteKey.equals(last.overlaySpriteKey)) && last.startVertexIndex + last.count == startVert) {
                    this.spriteRanges.set(this.spriteRanges.size() - 1, new SpriteRange(last.startVertexIndex, last.count + addedCount, spriteKey, overlaySpriteKey));
                } else {
                    this.spriteRanges.add(new SpriteRange(startVert, addedCount, spriteKey, overlaySpriteKey));
                }
            } else {
                this.spriteRanges.add(new SpriteRange(startVert, addedCount, spriteKey, overlaySpriteKey));
            }
        }
        return new int[]{v0, v1, v2, v3};
    }

    int registerVertex(int spriteHash, float px, float py, float pz, float u, float v, float u1, float v1, float r, float g, float b, float a) {
        VertexKey key = new VertexKey(spriteHash, this.quantize(px), this.quantize(py), this.quantize(pz), this.quantizeUV(u), this.quantizeUV(v), this.quantizeUV(u1), this.quantizeUV(v1), this.quantizeColor(r), this.quantizeColor(g), this.quantizeColor(b), this.quantizeColor(a));
        Integer existing = this.vertexLookup.get(key);
        if (existing != null) {
            return existing;
        }
        int idx = this.vertexCount++;
        this.vertexLookup.put(key, idx);
        this.positions.add(px);
        this.positions.add(py);
        this.positions.add(pz);
        this.uv0.add(u);
        this.uv0.add(v);
        this.uv1.add(u1);
        this.uv1.add(v1);
        this.colors.add(r);
        this.colors.add(g);
        this.colors.add(b);
        this.colors.add(a);
        return idx;
    }

    void addTriangle(int a, int b, int c) {
        this.indices.add(a);
        this.indices.add(b);
        this.indices.add(c);
    }

    float[] positionMin() {
        return this.positions.computeMin();
    }

    float[] positionMax() {
        return this.positions.computeMax();
    }

    int maxIndex() {
        int max = 0;
        for (int value : this.indices.toArray()) {
            max = Math.max(max, value);
        }
        return max;
    }

    private int quantize(float v) {
        return Math.round(v * 10000.0f);
    }

    private int quantizeUV(float v) {
        return Math.round(v * 100000.0f);
    }

    private int quantizeColor(float v) {
        return Math.round(v * 100.0f);
    }

    private int[] sortQuadCCW(float[] pos) {
        Integer[] idx = new Integer[]{0, 1, 2, 3};
        float ax = pos[3] - pos[0];
        float ay = pos[4] - pos[1];
        float az = pos[5] - pos[2];
        float bx = pos[6] - pos[0];
        float by = pos[7] - pos[1];
        float bz = pos[8] - pos[2];
        float nx = ay * bz - az * by;
        float ny = az * bx - ax * bz;
        float nz = ax * by - ay * bx;
        float anx = Math.abs(nx);
        float any = Math.abs(ny);
        float anz = Math.abs(nz);
        int drop = anx >= any && anx >= anz ? 0 : (any >= anz ? 1 : 2);
        float cx = 0.0f;
        float cy = 0.0f;
        float cz = 0.0f;
        for (int i = 0; i < 4; ++i) {
            cx += pos[i * 3];
            cy += pos[i * 3 + 1];
            cz += pos[i * 3 + 2];
        }
        float fcx = cx * 0.25f;
        float fcy = cy * 0.25f;
        float fcz = cz * 0.25f;
        int fdrop = drop;
        Arrays.sort(idx, (i1, i2) -> {
            double a1;
            float x1 = pos[i1 * 3] - fcx;
            float y1 = pos[i1 * 3 + 1] - fcy;
            float z1 = pos[i1 * 3 + 2] - fcz;
            float x2 = pos[i2 * 3] - fcx;
            float y2 = pos[i2 * 3 + 1] - fcy;
            float z2 = pos[i2 * 3 + 2] - fcz;
            double d = fdrop == 0 ? Math.atan2(z1, y1) : (a1 = fdrop == 1 ? Math.atan2(z1, x1) : Math.atan2(y1, x1));
            double a2 = fdrop == 0 ? Math.atan2(z2, y2) : (fdrop == 1 ? Math.atan2(z2, x2) : Math.atan2(y2, x2));
            return Double.compare(a1, a2);
        });
        float ovx1 = pos[3] - pos[0];
        float ovy1 = pos[4] - pos[1];
        float ovz1 = pos[5] - pos[2];
        float ovx2 = pos[6] - pos[0];
        float ovy2 = pos[7] - pos[1];
        float ovz2 = pos[8] - pos[2];
        float onx = ovy1 * ovz2 - ovz1 * ovy2;
        float ony = ovz1 * ovx2 - ovx1 * ovz2;
        float onz = ovx1 * ovy2 - ovy1 * ovx2;
        float svx1 = pos[idx[1] * 3] - pos[idx[0] * 3];
        float svy1 = pos[idx[1] * 3 + 1] - pos[idx[0] * 3 + 1];
        float svz1 = pos[idx[1] * 3 + 2] - pos[idx[0] * 3 + 2];
        float svx2 = pos[idx[2] * 3] - pos[idx[0] * 3];
        float svy2 = pos[idx[2] * 3 + 1] - pos[idx[0] * 3 + 1];
        float svz2 = pos[idx[2] * 3 + 2] - pos[idx[0] * 3 + 2];
        float snx = svy1 * svz2 - svz1 * svy2;
        float sny = svz1 * svx2 - svx1 * svz2;
        float snz = svx1 * svy2 - svy1 * svx2;
        if (onx * snx + ony * sny + onz * snz < 0.0f) {
            int tmp = idx[1];
            idx[1] = idx[3];
            idx[3] = tmp;
        }
        return new int[]{idx[0], idx[1], idx[2], idx[3]};
    }

    private record QuadKey(int a, int b, int c, int d) {
        static QuadKey from(int v0, int v1, int v2, int v3) {
            int[] arr = new int[]{v0, v1, v2, v3};
            Arrays.sort(arr);
            return new QuadKey(arr[0], arr[1], arr[2], arr[3]);
        }
    }

    record SpriteRange(int startVertexIndex, int count, String spriteKey, String overlaySpriteKey) {
    }

    private record VertexKey(int spriteHash, int px, int py, int pz, int u, int v, int u1, int v1, int r, int g, int b, int a) {
    }
}

