/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.scene.gltf;

import com.voxelbridge.config.ExportRuntimeConfig;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.export.texture.BlockEntityTextureManager;
import com.voxelbridge.export.texture.TextureLoader;
import com.voxelbridge.shadow.jgltf.impl.v2.Image;
import com.voxelbridge.shadow.jgltf.impl.v2.Texture;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.imageio.ImageIO;
import net.minecraft.resources.ResourceLocation;

final class TextureRegistry {
    private final ExportContext ctx;
    private final Path texturesDir;
    private final Map<String, String> spriteRelativePaths = new HashMap<String, String>();
    private final Map<String, Integer> spriteTextureIndices = new HashMap<String, Integer>();

    TextureRegistry(ExportContext ctx, Path outDir) {
        this.ctx = ctx;
        this.texturesDir = outDir.resolve("textures");
    }

    void ensureSpriteExport(String spriteKey) {
        String path;
        if (spriteKey.startsWith("blockentity:") || spriteKey.startsWith("entity:") || spriteKey.startsWith("base:")) {
            if (this.spriteRelativePaths.containsKey(spriteKey)) {
                return;
            }
            String path2 = this.ctx.getMaterialPaths().get(spriteKey);
            if (path2 != null) {
                this.spriteRelativePaths.put(spriteKey, path2);
                return;
            }
            String filename = BlockEntityTextureManager.getTextureFilename(spriteKey);
            this.spriteRelativePaths.put(spriteKey, filename);
            return;
        }
        if (ExportRuntimeConfig.getAtlasMode() == ExportRuntimeConfig.AtlasMode.ATLAS && (path = this.ctx.getMaterialPaths().get(spriteKey)) != null) {
            this.spriteRelativePaths.put(spriteKey, path);
            return;
        }
        if (this.spriteRelativePaths.containsKey(spriteKey)) {
            return;
        }
        try {
            Files.createDirectories(this.texturesDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String safe = spriteKey.replace(':', '_').replace('/', '_');
        Path png = this.texturesDir.resolve(safe + ".png");
        this.spriteRelativePaths.put(spriteKey, "textures/" + png.getFileName().toString());
        if (!Files.exists(png, new LinkOption[0])) {
            BufferedImage image = this.ctx.getCachedSpriteImage(spriteKey);
            if (image == null) {
                ResourceLocation pngRes = TextureLoader.spriteKeyToTexturePNG(spriteKey);
                image = TextureLoader.readTexture(pngRes);
            }
            if (image != null) {
                try {
                    ImageIO.write((RenderedImage)image, "PNG", png.toFile());
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    int ensureSpriteTexture(String spriteKey, List<Texture> textures, List<Image> images) {
        this.ensureSpriteExport(spriteKey);
        return this.spriteTextureIndices.computeIfAbsent(spriteKey, key -> {
            String rel = this.spriteRelativePaths.get(key);
            Image image = new Image();
            image.setUri(rel);
            images.add(image);
            Texture texture = new Texture();
            texture.setSource(images.size() - 1);
            texture.setSampler(0);
            textures.add(texture);
            return textures.size() - 1;
        });
    }
}

