/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.export.texture;

import com.voxelbridge.config.ExportRuntimeConfig;
import com.voxelbridge.export.ExportContext;
import com.voxelbridge.util.ExportLogger;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;
import javax.imageio.ImageIO;

public final class ColorMapManager {
    private static final int SLOT_SIZE = 4;

    private ColorMapManager() {
    }

    public static void initializeReservedSlots(ExportContext ctx) {
        int whiteColor = -1;
        ctx.getNextColorSlot().set(0);
        ExportContext.TexturePlacement whitePlacement = ColorMapManager.registerColor(ctx, whiteColor);
        if (whitePlacement.x() != 0 || whitePlacement.y() != 0) {
            throw new IllegalStateException("White color not in slot 0! Got position: (" + whitePlacement.x() + ", " + whitePlacement.y() + ")");
        }
        ctx.getNextColorSlot().set(1);
        ExportLogger.log("[ColorMap] Reserved slot 0 for white color (4x4)");
    }

    public static ExportContext.TexturePlacement registerColor(ExportContext ctx, int argb) {
        int norm = argb | 0xFF000000;
        Map<Integer, ExportContext.TexturePlacement> map = ctx.getColorMap();
        ExportContext.TexturePlacement existing = map.get(norm);
        if (existing != null) {
            return existing;
        }
        int pageSize = ExportRuntimeConfig.getAtlasSize().getSize();
        int slotsPerRow = pageSize / 4;
        long slotsPerPage = (long)slotsPerRow * (long)slotsPerRow;
        long slot = ctx.getNextColorSlot().getAndIncrement();
        long page = slot / slotsPerPage;
        long idx = slot % slotsPerPage;
        int slotRow = (int)(idx / (long)slotsPerRow);
        int slotCol = (int)(idx % (long)slotsPerRow);
        int x = slotCol * 4;
        int y = slotRow * 4;
        int tileU = (int)(page % 10L);
        int tileV = (int)(page / 10L);
        float u0 = (float)tileU + ((float)x + 0.5f) / (float)pageSize;
        float v0 = (float)(-tileV) + ((float)y + 0.5f) / (float)pageSize;
        float u1 = (float)tileU + ((float)(x + 4) - 0.5f) / (float)pageSize;
        float v1 = (float)(-tileV) + ((float)(y + 4) - 0.5f) / (float)pageSize;
        ExportContext.TexturePlacement placement = new ExportContext.TexturePlacement((int)page, tileU, tileV, x, y, 4, 4, u0, v0, u1, v1, null);
        map.put(norm, placement);
        return placement;
    }

    public static void generateColorMaps(ExportContext ctx, Path outDir) throws IOException {
        Path dir = outDir.resolve("textures/colormap");
        Files.createDirectories(dir, new FileAttribute[0]);
        int maxPage = 0;
        for (ExportContext.TexturePlacement p : ctx.getColorMap().values()) {
            maxPage = Math.max(maxPage, p.page());
        }
        int pageSize = ExportRuntimeConfig.getAtlasSize().getSize();
        ExportLogger.log("[ColorMap] entries=" + ctx.getColorMap().size() + " nextSlot=" + ctx.getNextColorSlot().get() + " pages=" + (maxPage + 1) + " pageSize=" + pageSize);
        BufferedImage[] pages = new BufferedImage[maxPage + 1];
        for (int i = 0; i < pages.length; ++i) {
            pages[i] = new BufferedImage(pageSize, pageSize, 2);
        }
        int[] sampleCount = new int[]{0};
        ctx.getColorMap().forEach((color, placement) -> {
            BufferedImage img = pages[placement.page()];
            for (int dx = 0; dx < 4; ++dx) {
                for (int dy = 0; dy < 4; ++dy) {
                    img.setRGB(placement.x() + dx, placement.y() + dy, (int)color);
                }
            }
            if (sampleCount[0] < 10) {
                sampleCount[0] = sampleCount[0] + 1;
                ExportLogger.log(String.format("[ColorMap] sample #%d color=%08X page=%d xy=(%d,%d) uv=[(%.4f,%.4f)-(%.4f,%.4f)]", sampleCount[0], color, placement.page(), placement.x(), placement.y(), Float.valueOf(placement.u0()), Float.valueOf(placement.v0()), Float.valueOf(placement.u1()), Float.valueOf(placement.v1())));
            }
        });
        for (int i = 0; i < pages.length; ++i) {
            int udim = 1001 + i % 10 + i / 10 * 10;
            String name = "colormap_" + udim + ".png";
            Path target = dir.resolve(name);
            ImageIO.write((RenderedImage)pages[i], "png", target.toFile());
            ExportLogger.log("[ColorMap] page=" + i + " -> " + String.valueOf(target));
        }
    }

    public static float[] remapColorUV(ExportContext ctx, int argb) {
        ExportContext.TexturePlacement placement = ColorMapManager.registerColor(ctx, argb);
        return new float[]{placement.u0(), placement.v0(), placement.u1(), placement.v1()};
    }
}

