/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.modhandler.yuushya;

import com.voxelbridge.export.ExportContext;
import com.voxelbridge.modhandler.ModBlockHandler;
import com.voxelbridge.modhandler.ModHandledQuads;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public final class YuushyaShowBlockHandler
implements ModBlockHandler {
    private static final String SHOW_BLOCK_ID = "yuushya:showblock";
    private static final String SHOW_BLOCK_ENTITY_CLASS = "com.yuushya.modelling.blockentity.showblock.ShowBlockEntity";
    private static final List<String> MODEL_CLASSES = List.of("com.yuushya.modelling.neoforge.client.ShowBlockModel", "com.yuushya.modelling.fabriclike.client.ShowBlockModel", "com.yuushya.modelling.blockentity.showblock.ShowBlockModel");

    @Override
    public Optional<ModHandledQuads> handle(ExportContext ctx, Level level, BlockState state, BlockEntity blockEntity, BlockPos pos, BakedModel bakedModel) {
        if (blockEntity == null) {
            return Optional.empty();
        }
        if (!SHOW_BLOCK_ID.equals(BuiltInRegistries.BLOCK.getKey((Object)state.getBlock()).toString())) {
            return Optional.empty();
        }
        if (!blockEntity.getClass().getName().equals(SHOW_BLOCK_ENTITY_CLASS)) {
            return Optional.empty();
        }
        try {
            RandomSource rand;
            Method getter = blockEntity.getClass().getMethod("getTransformDatas", new Class[0]);
            Object dataObj = getter.invoke((Object)blockEntity, new Object[0]);
            if (!(dataObj instanceof List)) {
                return Optional.empty();
            }
            List transformData = (List)dataObj;
            Direction facing = state.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING) ? (Direction)state.getValue((Property)BlockStateProperties.HORIZONTAL_FACING) : Direction.SOUTH;
            Object modelInstance = this.createModel(facing, bakedModel);
            if (modelInstance == null) {
                return Optional.empty();
            }
            Method getQuads = modelInstance.getClass().getMethod("getQuads", BlockState.class, Direction.class, RandomSource.class, List.class);
            Object result = getQuads.invoke(modelInstance, state, null, rand = RandomSource.create((long)Mth.getSeed((int)pos.getX(), (int)pos.getY(), (int)pos.getZ())), transformData);
            if (!(result instanceof List)) {
                return Optional.empty();
            }
            List rawQuads = (List)result;
            ArrayList<BakedQuad> quads = new ArrayList<BakedQuad>();
            for (Object q : rawQuads) {
                if (!(q instanceof BakedQuad)) continue;
                BakedQuad quad = (BakedQuad)q;
                quads.add(quad);
            }
            if (quads.isEmpty()) {
                return Optional.empty();
            }
            return Optional.of(new ModHandledQuads(quads));
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }

    private Object createModel(Direction facing, BakedModel backup) {
        for (String className : MODEL_CLASSES) {
            try {
                Class<?> clazz = Class.forName(className);
                try {
                    Constructor<?> ctor = clazz.getConstructor(Direction.class, BakedModel.class);
                    return ctor.newInstance(facing, backup);
                }
                catch (NoSuchMethodException ignored) {
                    Constructor<?> ctor = clazz.getConstructor(Direction.class);
                    return ctor.newInstance(facing);
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (Exception exception) {
            }
        }
        return null;
    }
}

