/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.impl.v2;

import com.voxelbridge.shadow.jgltf.impl.v2.GlTFChildOfRootProperty;
import com.voxelbridge.shadow.jgltf.impl.v2.MaterialNormalTextureInfo;
import com.voxelbridge.shadow.jgltf.impl.v2.MaterialOcclusionTextureInfo;
import com.voxelbridge.shadow.jgltf.impl.v2.MaterialPbrMetallicRoughness;
import com.voxelbridge.shadow.jgltf.impl.v2.TextureInfo;

public class Material
extends GlTFChildOfRootProperty {
    private MaterialPbrMetallicRoughness pbrMetallicRoughness;
    private MaterialNormalTextureInfo normalTexture;
    private MaterialOcclusionTextureInfo occlusionTexture;
    private TextureInfo emissiveTexture;
    private float[] emissiveFactor;
    private String alphaMode;
    private Float alphaCutoff;
    private Boolean doubleSided;

    public void setPbrMetallicRoughness(MaterialPbrMetallicRoughness pbrMetallicRoughness) {
        if (pbrMetallicRoughness == null) {
            this.pbrMetallicRoughness = pbrMetallicRoughness;
            return;
        }
        this.pbrMetallicRoughness = pbrMetallicRoughness;
    }

    public MaterialPbrMetallicRoughness getPbrMetallicRoughness() {
        return this.pbrMetallicRoughness;
    }

    public void setNormalTexture(MaterialNormalTextureInfo normalTexture) {
        if (normalTexture == null) {
            this.normalTexture = normalTexture;
            return;
        }
        this.normalTexture = normalTexture;
    }

    public MaterialNormalTextureInfo getNormalTexture() {
        return this.normalTexture;
    }

    public void setOcclusionTexture(MaterialOcclusionTextureInfo occlusionTexture) {
        if (occlusionTexture == null) {
            this.occlusionTexture = occlusionTexture;
            return;
        }
        this.occlusionTexture = occlusionTexture;
    }

    public MaterialOcclusionTextureInfo getOcclusionTexture() {
        return this.occlusionTexture;
    }

    public void setEmissiveTexture(TextureInfo emissiveTexture) {
        if (emissiveTexture == null) {
            this.emissiveTexture = emissiveTexture;
            return;
        }
        this.emissiveTexture = emissiveTexture;
    }

    public TextureInfo getEmissiveTexture() {
        return this.emissiveTexture;
    }

    public void setEmissiveFactor(float[] emissiveFactor) {
        if (emissiveFactor == null) {
            this.emissiveFactor = emissiveFactor;
            return;
        }
        if (emissiveFactor.length < 3) {
            throw new IllegalArgumentException("Number of emissiveFactor elements is < 3");
        }
        if (emissiveFactor.length > 3) {
            throw new IllegalArgumentException("Number of emissiveFactor elements is > 3");
        }
        for (float emissiveFactorElement : emissiveFactor) {
            if ((double)emissiveFactorElement > 1.0) {
                throw new IllegalArgumentException("emissiveFactorElement > 1.0");
            }
            if (!((double)emissiveFactorElement < 0.0)) continue;
            throw new IllegalArgumentException("emissiveFactorElement < 0.0");
        }
        this.emissiveFactor = emissiveFactor;
    }

    public float[] getEmissiveFactor() {
        return this.emissiveFactor;
    }

    public float[] defaultEmissiveFactor() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public void setAlphaMode(String alphaMode) {
        if (alphaMode == null) {
            this.alphaMode = alphaMode;
            return;
        }
        if (!("OPAQUE".equals(alphaMode) || "MASK".equals(alphaMode) || "BLEND".equals(alphaMode))) {
            throw new IllegalArgumentException("Invalid value for alphaMode: " + alphaMode + ", valid: [OPAQUE, MASK, BLEND]");
        }
        this.alphaMode = alphaMode;
    }

    public String getAlphaMode() {
        return this.alphaMode;
    }

    public String defaultAlphaMode() {
        return "OPAQUE";
    }

    public void setAlphaCutoff(Float alphaCutoff) {
        if (alphaCutoff == null) {
            this.alphaCutoff = alphaCutoff;
            return;
        }
        if ((double)alphaCutoff.floatValue() < 0.0) {
            throw new IllegalArgumentException("alphaCutoff < 0.0");
        }
        this.alphaCutoff = alphaCutoff;
    }

    public Float getAlphaCutoff() {
        return this.alphaCutoff;
    }

    public Float defaultAlphaCutoff() {
        return Float.valueOf(0.5f);
    }

    public void setDoubleSided(Boolean doubleSided) {
        if (doubleSided == null) {
            this.doubleSided = doubleSided;
            return;
        }
        this.doubleSided = doubleSided;
    }

    public Boolean isDoubleSided() {
        return this.doubleSided;
    }

    public Boolean defaultDoubleSided() {
        return false;
    }
}

