/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.impl.v2;

import com.voxelbridge.shadow.jgltf.impl.v2.GlTFProperty;
import com.voxelbridge.shadow.jgltf.impl.v2.TextureInfo;

public class MaterialPbrMetallicRoughness
extends GlTFProperty {
    private float[] baseColorFactor;
    private TextureInfo baseColorTexture;
    private Float metallicFactor;
    private Float roughnessFactor;
    private TextureInfo metallicRoughnessTexture;

    public void setBaseColorFactor(float[] baseColorFactor) {
        if (baseColorFactor == null) {
            this.baseColorFactor = baseColorFactor;
            return;
        }
        if (baseColorFactor.length < 4) {
            throw new IllegalArgumentException("Number of baseColorFactor elements is < 4");
        }
        if (baseColorFactor.length > 4) {
            throw new IllegalArgumentException("Number of baseColorFactor elements is > 4");
        }
        for (float baseColorFactorElement : baseColorFactor) {
            if ((double)baseColorFactorElement > 1.0) {
                throw new IllegalArgumentException("baseColorFactorElement > 1.0");
            }
            if (!((double)baseColorFactorElement < 0.0)) continue;
            throw new IllegalArgumentException("baseColorFactorElement < 0.0");
        }
        this.baseColorFactor = baseColorFactor;
    }

    public float[] getBaseColorFactor() {
        return this.baseColorFactor;
    }

    public float[] defaultBaseColorFactor() {
        return new float[]{1.0f, 1.0f, 1.0f, 1.0f};
    }

    public void setBaseColorTexture(TextureInfo baseColorTexture) {
        if (baseColorTexture == null) {
            this.baseColorTexture = baseColorTexture;
            return;
        }
        this.baseColorTexture = baseColorTexture;
    }

    public TextureInfo getBaseColorTexture() {
        return this.baseColorTexture;
    }

    public void setMetallicFactor(Float metallicFactor) {
        if (metallicFactor == null) {
            this.metallicFactor = metallicFactor;
            return;
        }
        if ((double)metallicFactor.floatValue() > 1.0) {
            throw new IllegalArgumentException("metallicFactor > 1.0");
        }
        if ((double)metallicFactor.floatValue() < 0.0) {
            throw new IllegalArgumentException("metallicFactor < 0.0");
        }
        this.metallicFactor = metallicFactor;
    }

    public Float getMetallicFactor() {
        return this.metallicFactor;
    }

    public Float defaultMetallicFactor() {
        return Float.valueOf(1.0f);
    }

    public void setRoughnessFactor(Float roughnessFactor) {
        if (roughnessFactor == null) {
            this.roughnessFactor = roughnessFactor;
            return;
        }
        if ((double)roughnessFactor.floatValue() > 1.0) {
            throw new IllegalArgumentException("roughnessFactor > 1.0");
        }
        if ((double)roughnessFactor.floatValue() < 0.0) {
            throw new IllegalArgumentException("roughnessFactor < 0.0");
        }
        this.roughnessFactor = roughnessFactor;
    }

    public Float getRoughnessFactor() {
        return this.roughnessFactor;
    }

    public Float defaultRoughnessFactor() {
        return Float.valueOf(1.0f);
    }

    public void setMetallicRoughnessTexture(TextureInfo metallicRoughnessTexture) {
        if (metallicRoughnessTexture == null) {
            this.metallicRoughnessTexture = metallicRoughnessTexture;
            return;
        }
        this.metallicRoughnessTexture = metallicRoughnessTexture;
    }

    public TextureInfo getMetallicRoughnessTexture() {
        return this.metallicRoughnessTexture;
    }
}

