/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.impl.v2;

import com.voxelbridge.shadow.jgltf.impl.v2.GlTFChildOfRootProperty;
import java.util.ArrayList;
import java.util.List;

public class Node
extends GlTFChildOfRootProperty {
    private Integer camera;
    private List<Integer> children;
    private Integer skin;
    private float[] matrix;
    private Integer mesh;
    private float[] rotation;
    private float[] scale;
    private float[] translation;
    private List<Float> weights;

    public void setCamera(Integer camera) {
        if (camera == null) {
            this.camera = camera;
            return;
        }
        this.camera = camera;
    }

    public Integer getCamera() {
        return this.camera;
    }

    public void setChildren(List<Integer> children) {
        if (children == null) {
            this.children = children;
            return;
        }
        if (children.size() < 1) {
            throw new IllegalArgumentException("Number of children elements is < 1");
        }
        for (Integer childrenElement : children) {
            if (childrenElement >= 0) continue;
            throw new IllegalArgumentException("childrenElement < 0");
        }
        this.children = children;
    }

    public List<Integer> getChildren() {
        return this.children;
    }

    public void addChildren(Integer element) {
        if (element == null) {
            throw new NullPointerException("The element may not be null");
        }
        List<Integer> oldList = this.children;
        ArrayList<Integer> newList = new ArrayList<Integer>();
        if (oldList != null) {
            newList.addAll(oldList);
        }
        newList.add(element);
        this.children = newList;
    }

    public void removeChildren(Integer element) {
        if (element == null) {
            throw new NullPointerException("The element may not be null");
        }
        List<Integer> oldList = this.children;
        ArrayList<Integer> newList = new ArrayList<Integer>();
        if (oldList != null) {
            newList.addAll(oldList);
        }
        newList.remove(element);
        this.children = newList.isEmpty() ? null : newList;
    }

    public void setSkin(Integer skin) {
        if (skin == null) {
            this.skin = skin;
            return;
        }
        this.skin = skin;
    }

    public Integer getSkin() {
        return this.skin;
    }

    public void setMatrix(float[] matrix) {
        if (matrix == null) {
            this.matrix = matrix;
            return;
        }
        if (matrix.length < 16) {
            throw new IllegalArgumentException("Number of matrix elements is < 16");
        }
        if (matrix.length > 16) {
            throw new IllegalArgumentException("Number of matrix elements is > 16");
        }
        this.matrix = matrix;
    }

    public float[] getMatrix() {
        return this.matrix;
    }

    public float[] defaultMatrix() {
        return new float[]{1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f};
    }

    public void setMesh(Integer mesh) {
        if (mesh == null) {
            this.mesh = mesh;
            return;
        }
        this.mesh = mesh;
    }

    public Integer getMesh() {
        return this.mesh;
    }

    public void setRotation(float[] rotation) {
        if (rotation == null) {
            this.rotation = rotation;
            return;
        }
        if (rotation.length < 4) {
            throw new IllegalArgumentException("Number of rotation elements is < 4");
        }
        if (rotation.length > 4) {
            throw new IllegalArgumentException("Number of rotation elements is > 4");
        }
        for (float rotationElement : rotation) {
            if ((double)rotationElement > 1.0) {
                throw new IllegalArgumentException("rotationElement > 1.0");
            }
            if (!((double)rotationElement < -1.0)) continue;
            throw new IllegalArgumentException("rotationElement < -1.0");
        }
        this.rotation = rotation;
    }

    public float[] getRotation() {
        return this.rotation;
    }

    public float[] defaultRotation() {
        return new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    }

    public void setScale(float[] scale) {
        if (scale == null) {
            this.scale = scale;
            return;
        }
        if (scale.length < 3) {
            throw new IllegalArgumentException("Number of scale elements is < 3");
        }
        if (scale.length > 3) {
            throw new IllegalArgumentException("Number of scale elements is > 3");
        }
        this.scale = scale;
    }

    public float[] getScale() {
        return this.scale;
    }

    public float[] defaultScale() {
        return new float[]{1.0f, 1.0f, 1.0f};
    }

    public void setTranslation(float[] translation) {
        if (translation == null) {
            this.translation = translation;
            return;
        }
        if (translation.length < 3) {
            throw new IllegalArgumentException("Number of translation elements is < 3");
        }
        if (translation.length > 3) {
            throw new IllegalArgumentException("Number of translation elements is > 3");
        }
        this.translation = translation;
    }

    public float[] getTranslation() {
        return this.translation;
    }

    public float[] defaultTranslation() {
        return new float[]{0.0f, 0.0f, 0.0f};
    }

    public void setWeights(List<Float> weights) {
        if (weights == null) {
            this.weights = weights;
            return;
        }
        if (weights.size() < 1) {
            throw new IllegalArgumentException("Number of weights elements is < 1");
        }
        this.weights = weights;
    }

    public List<Float> getWeights() {
        return this.weights;
    }

    public void addWeights(Float element) {
        if (element == null) {
            throw new NullPointerException("The element may not be null");
        }
        List<Float> oldList = this.weights;
        ArrayList<Float> newList = new ArrayList<Float>();
        if (oldList != null) {
            newList.addAll(oldList);
        }
        newList.add(element);
        this.weights = newList;
    }

    public void removeWeights(Float element) {
        if (element == null) {
            throw new NullPointerException("The element may not be null");
        }
        List<Float> oldList = this.weights;
        ArrayList<Float> newList = new ArrayList<Float>();
        if (oldList != null) {
            newList.addAll(oldList);
        }
        newList.remove(element);
        this.weights = newList.isEmpty() ? null : newList;
    }
}

