/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model;

import com.voxelbridge.shadow.jgltf.model.AccessorData;
import com.voxelbridge.shadow.jgltf.model.AccessorFloatData;
import com.voxelbridge.shadow.jgltf.model.AccessorModel;
import com.voxelbridge.shadow.jgltf.model.AnimationModel;
import com.voxelbridge.shadow.jgltf.model.NodeModel;
import com.voxelbridge.shadow.jgltf.model.animation.Animation;
import com.voxelbridge.shadow.jgltf.model.animation.AnimationListener;
import com.voxelbridge.shadow.jgltf.model.animation.AnimationManager;
import com.voxelbridge.shadow.jgltf.model.animation.InterpolatorType;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.logging.Logger;

public class GltfAnimations {
    private static final Logger logger = Logger.getLogger(GltfAnimations.class.getName());

    public static AnimationManager createAnimationManager(AnimationManager.AnimationPolicy animationPolicy) {
        AnimationManager animationManager = new AnimationManager(animationPolicy);
        return animationManager;
    }

    public static List<Animation> createModelAnimations(Iterable<? extends AnimationModel> animationModels) {
        Objects.requireNonNull(animationModels, "The animationModels may not be null");
        ArrayList<Animation> allModelAnimations = new ArrayList<Animation>();
        for (AnimationModel animationModel : animationModels) {
            List<AnimationModel.Channel> channels = animationModel.getChannels();
            List<Animation> modelAnimations = GltfAnimations.createModelAnimationsForChannels(channels);
            allModelAnimations.addAll(modelAnimations);
        }
        return allModelAnimations;
    }

    private static List<Animation> createModelAnimationsForChannels(Iterable<? extends AnimationModel.Channel> channels) {
        ArrayList<Animation> modelAnimations = new ArrayList<Animation>();
        for (AnimationModel.Channel channel : channels) {
            Animation modelAnimation = GltfAnimations.createModelAnimation(channel);
            if (modelAnimation == null) continue;
            modelAnimations.add(modelAnimation);
        }
        return modelAnimations;
    }

    private static Animation createModelAnimation(AnimationModel.Channel channel) {
        String path;
        AnimationModel.Sampler sampler = channel.getSampler();
        AnimationModel.Interpolation interpolation = sampler.getInterpolation();
        NodeModel nodeModel = channel.getNodeModel();
        AnimationListener animationListener = GltfAnimations.createAnimationListener(nodeModel, path = channel.getPath());
        if (animationListener == null) {
            return null;
        }
        InterpolatorType interpolatorType = GltfAnimations.typeForInterpolation(interpolation, path);
        AccessorModel input = sampler.getInput();
        AccessorData inputData = input.getAccessorData();
        if (!(inputData instanceof AccessorFloatData)) {
            logger.warning("Input data is not an AccessorFloatData, but " + inputData.getClass());
            return null;
        }
        AccessorFloatData inputFloatData = (AccessorFloatData)inputData;
        AccessorModel output = sampler.getOutput();
        AccessorData outputData = output.getAccessorData();
        if (!(outputData instanceof AccessorFloatData)) {
            logger.warning("Output data is not an AccessorFloatData, but " + outputData.getClass());
            return null;
        }
        AccessorFloatData outputFloatData = (AccessorFloatData)outputData;
        Animation modelAnimation = GltfAnimations.createAnimation(inputFloatData, outputFloatData, interpolatorType);
        modelAnimation.addAnimationListener(animationListener);
        return modelAnimation;
    }

    private static InterpolatorType typeForInterpolation(AnimationModel.Interpolation interpolation, String path) {
        switch (interpolation) {
            case LINEAR: {
                if (path.equals("rotation")) {
                    return InterpolatorType.SLERP;
                }
                return InterpolatorType.LINEAR;
            }
            case STEP: {
                return InterpolatorType.STEP;
            }
        }
        logger.warning("This interpolation type is not supported yet");
        logger.warning("Interpolation type not supported: " + (Object)((Object)interpolation));
        return InterpolatorType.LINEAR;
    }

    static Animation createAnimation(AccessorFloatData timeData, AccessorFloatData outputData, InterpolatorType interpolatorType) {
        int numKeyElements = timeData.getNumElements();
        float[] keys = new float[numKeyElements];
        for (int e = 0; e < numKeyElements; ++e) {
            keys[e] = timeData.get(e);
        }
        int totalNumValueComponents = outputData.getTotalNumComponents();
        int numComponentsPerElement = totalNumValueComponents / numKeyElements;
        float[][] values = new float[numKeyElements][numComponentsPerElement];
        for (int c = 0; c < numComponentsPerElement; ++c) {
            for (int e = 0; e < numKeyElements; ++e) {
                int globalIndex = e * numComponentsPerElement + c;
                values[e][c] = outputData.get(globalIndex);
            }
        }
        return new Animation(keys, values, interpolatorType);
    }

    private static AnimationListener createAnimationListener(NodeModel nodeModel, String path) {
        switch (path) {
            case "translation": {
                return GltfAnimations.createTranslationAnimationListener(nodeModel);
            }
            case "rotation": {
                return GltfAnimations.createRotationAnimationListener(nodeModel);
            }
            case "scale": {
                return GltfAnimations.createScaleAnimationListener(nodeModel);
            }
            case "weights": {
                return GltfAnimations.createWeightsAnimationListener(nodeModel);
            }
        }
        logger.warning("Animation channel target path must be \"translation\", \"rotation\", \"scale\" or  \"weights\", but is " + path);
        return null;
    }

    private static AnimationListener createTranslationAnimationListener(NodeModel nodeModel) {
        return (animation, timeS, values) -> {
            float[] translation = nodeModel.getTranslation();
            if (translation == null) {
                translation = (float[])values.clone();
                nodeModel.setTranslation(translation);
            } else {
                System.arraycopy(values, 0, translation, 0, values.length);
            }
        };
    }

    private static AnimationListener createRotationAnimationListener(NodeModel nodeModel) {
        return (animation, timeS, values) -> {
            float[] rotation = nodeModel.getRotation();
            if (rotation == null) {
                rotation = (float[])values.clone();
                nodeModel.setRotation(rotation);
            } else {
                System.arraycopy(values, 0, rotation, 0, values.length);
            }
        };
    }

    private static AnimationListener createScaleAnimationListener(NodeModel nodeModel) {
        return (animation, timeS, values) -> {
            float[] scale = nodeModel.getScale();
            if (scale == null) {
                scale = (float[])values.clone();
                nodeModel.setScale(scale);
            } else {
                System.arraycopy(values, 0, scale, 0, values.length);
            }
        };
    }

    private static AnimationListener createWeightsAnimationListener(NodeModel nodeModel) {
        return (animation, timeS, values) -> {
            float[] weights = nodeModel.getWeights();
            if (weights == null) {
                weights = (float[])values.clone();
                nodeModel.setWeights(weights);
            } else {
                System.arraycopy(values, 0, weights, 0, values.length);
            }
        };
    }

    private GltfAnimations() {
    }
}

