/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model;

import java.util.Arrays;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;

public class MathUtils {
    private static final Logger logger = Logger.getLogger(MathUtils.class.getName());
    private static final float FLOAT_EPSILON = 1.0E-8f;

    public static float[] createIdentity4x4() {
        float[] m = new float[16];
        MathUtils.setIdentity4x4(m);
        return m;
    }

    public static void setIdentity4x4(float[] m) {
        Arrays.fill(m, 0.0f);
        m[0] = 1.0f;
        m[5] = 1.0f;
        m[10] = 1.0f;
        m[15] = 1.0f;
    }

    static void setIdentity3x3(float[] m) {
        Arrays.fill(m, 0.0f);
        m[0] = 1.0f;
        m[4] = 1.0f;
        m[8] = 1.0f;
    }

    static void set(float[] source, float[] target) {
        System.arraycopy(source, 0, target, 0, Math.min(source.length, target.length));
    }

    public static void getRotationScale(float[] sourceMatrix4x4, float[] targetMatrix3x3) {
        targetMatrix3x3[0] = sourceMatrix4x4[0];
        targetMatrix3x3[1] = sourceMatrix4x4[1];
        targetMatrix3x3[2] = sourceMatrix4x4[2];
        targetMatrix3x3[3] = sourceMatrix4x4[4];
        targetMatrix3x3[4] = sourceMatrix4x4[5];
        targetMatrix3x3[5] = sourceMatrix4x4[6];
        targetMatrix3x3[6] = sourceMatrix4x4[8];
        targetMatrix3x3[7] = sourceMatrix4x4[9];
        targetMatrix3x3[8] = sourceMatrix4x4[10];
    }

    static void transpose3x3(float[] m, float[] t) {
        float m0 = m[0];
        float m1 = m[1];
        float m2 = m[2];
        float m3 = m[3];
        float m4 = m[4];
        float m5 = m[5];
        float m6 = m[6];
        float m7 = m[7];
        float m8 = m[8];
        t[0] = m0;
        t[1] = m3;
        t[2] = m6;
        t[3] = m1;
        t[4] = m4;
        t[5] = m7;
        t[6] = m2;
        t[7] = m5;
        t[8] = m8;
    }

    public static void transpose4x4(float[] m, float[] t) {
        float m0 = m[0];
        float m1 = m[1];
        float m2 = m[2];
        float m3 = m[3];
        float m4 = m[4];
        float m5 = m[5];
        float m6 = m[6];
        float m7 = m[7];
        float m8 = m[8];
        float m9 = m[9];
        float mA = m[10];
        float mB = m[11];
        float mC = m[12];
        float mD = m[13];
        float mE = m[14];
        float mF = m[15];
        t[0] = m0;
        t[1] = m4;
        t[2] = m8;
        t[3] = mC;
        t[4] = m1;
        t[5] = m5;
        t[6] = m9;
        t[7] = mD;
        t[8] = m2;
        t[9] = m6;
        t[10] = mA;
        t[11] = mE;
        t[12] = m3;
        t[13] = m7;
        t[14] = mB;
        t[15] = mF;
    }

    public static void mul4x4(float[] a, float[] b, float[] m) {
        float a00 = a[0];
        float a10 = a[1];
        float a20 = a[2];
        float a30 = a[3];
        float a01 = a[4];
        float a11 = a[5];
        float a21 = a[6];
        float a31 = a[7];
        float a02 = a[8];
        float a12 = a[9];
        float a22 = a[10];
        float a32 = a[11];
        float a03 = a[12];
        float a13 = a[13];
        float a23 = a[14];
        float a33 = a[15];
        float b00 = b[0];
        float b10 = b[1];
        float b20 = b[2];
        float b30 = b[3];
        float b01 = b[4];
        float b11 = b[5];
        float b21 = b[6];
        float b31 = b[7];
        float b02 = b[8];
        float b12 = b[9];
        float b22 = b[10];
        float b32 = b[11];
        float b03 = b[12];
        float b13 = b[13];
        float b23 = b[14];
        float b33 = b[15];
        float m00 = a00 * b00 + a01 * b10 + a02 * b20 + a03 * b30;
        float m01 = a00 * b01 + a01 * b11 + a02 * b21 + a03 * b31;
        float m02 = a00 * b02 + a01 * b12 + a02 * b22 + a03 * b32;
        float m03 = a00 * b03 + a01 * b13 + a02 * b23 + a03 * b33;
        float m10 = a10 * b00 + a11 * b10 + a12 * b20 + a13 * b30;
        float m11 = a10 * b01 + a11 * b11 + a12 * b21 + a13 * b31;
        float m12 = a10 * b02 + a11 * b12 + a12 * b22 + a13 * b32;
        float m13 = a10 * b03 + a11 * b13 + a12 * b23 + a13 * b33;
        float m20 = a20 * b00 + a21 * b10 + a22 * b20 + a23 * b30;
        float m21 = a20 * b01 + a21 * b11 + a22 * b21 + a23 * b31;
        float m22 = a20 * b02 + a21 * b12 + a22 * b22 + a23 * b32;
        float m23 = a20 * b03 + a21 * b13 + a22 * b23 + a23 * b33;
        float m30 = a30 * b00 + a31 * b10 + a32 * b20 + a33 * b30;
        float m31 = a30 * b01 + a31 * b11 + a32 * b21 + a33 * b31;
        float m32 = a30 * b02 + a31 * b12 + a32 * b22 + a33 * b32;
        float m33 = a30 * b03 + a31 * b13 + a32 * b23 + a33 * b33;
        m[0] = m00;
        m[1] = m10;
        m[2] = m20;
        m[3] = m30;
        m[4] = m01;
        m[5] = m11;
        m[6] = m21;
        m[7] = m31;
        m[8] = m02;
        m[9] = m12;
        m[10] = m22;
        m[11] = m32;
        m[12] = m03;
        m[13] = m13;
        m[14] = m23;
        m[15] = m33;
    }

    public static void quaternionToMatrix4x4(float[] q, float[] m) {
        float invLength = 1.0f / (float)Math.sqrt(MathUtils.dot(q, q));
        float qx = q[0] * invLength;
        float qy = q[1] * invLength;
        float qz = q[2] * invLength;
        float qw = q[3] * invLength;
        m[0] = 1.0f - 2.0f * qy * qy - 2.0f * qz * qz;
        m[1] = 2.0f * (qx * qy + qw * qz);
        m[2] = 2.0f * (qx * qz - qw * qy);
        m[3] = 0.0f;
        m[4] = 2.0f * (qx * qy - qw * qz);
        m[5] = 1.0f - 2.0f * qx * qx - 2.0f * qz * qz;
        m[6] = 2.0f * (qy * qz + qw * qx);
        m[7] = 0.0f;
        m[8] = 2.0f * (qx * qz + qw * qy);
        m[9] = 2.0f * (qy * qz - qw * qx);
        m[10] = 1.0f - 2.0f * qx * qx - 2.0f * qy * qy;
        m[11] = 0.0f;
        m[12] = 0.0f;
        m[13] = 0.0f;
        m[14] = 0.0f;
        m[15] = 1.0f;
    }

    public static void invert4x4(float[] m, float[] inv) {
        float m0 = m[0];
        float m1 = m[1];
        float m2 = m[2];
        float m3 = m[3];
        float m4 = m[4];
        float m5 = m[5];
        float m6 = m[6];
        float m7 = m[7];
        float m8 = m[8];
        float m9 = m[9];
        float mA = m[10];
        float mB = m[11];
        float mC = m[12];
        float mD = m[13];
        float mE = m[14];
        float mF = m[15];
        inv[0] = m5 * mA * mF - m5 * mB * mE - m9 * m6 * mF + m9 * m7 * mE + mD * m6 * mB - mD * m7 * mA;
        inv[4] = -m4 * mA * mF + m4 * mB * mE + m8 * m6 * mF - m8 * m7 * mE - mC * m6 * mB + mC * m7 * mA;
        inv[8] = m4 * m9 * mF - m4 * mB * mD - m8 * m5 * mF + m8 * m7 * mD + mC * m5 * mB - mC * m7 * m9;
        inv[12] = -m4 * m9 * mE + m4 * mA * mD + m8 * m5 * mE - m8 * m6 * mD - mC * m5 * mA + mC * m6 * m9;
        inv[1] = -m1 * mA * mF + m1 * mB * mE + m9 * m2 * mF - m9 * m3 * mE - mD * m2 * mB + mD * m3 * mA;
        inv[5] = m0 * mA * mF - m0 * mB * mE - m8 * m2 * mF + m8 * m3 * mE + mC * m2 * mB - mC * m3 * mA;
        inv[9] = -m0 * m9 * mF + m0 * mB * mD + m8 * m1 * mF - m8 * m3 * mD - mC * m1 * mB + mC * m3 * m9;
        inv[13] = m0 * m9 * mE - m0 * mA * mD - m8 * m1 * mE + m8 * m2 * mD + mC * m1 * mA - mC * m2 * m9;
        inv[2] = m1 * m6 * mF - m1 * m7 * mE - m5 * m2 * mF + m5 * m3 * mE + mD * m2 * m7 - mD * m3 * m6;
        inv[6] = -m0 * m6 * mF + m0 * m7 * mE + m4 * m2 * mF - m4 * m3 * mE - mC * m2 * m7 + mC * m3 * m6;
        inv[10] = m0 * m5 * mF - m0 * m7 * mD - m4 * m1 * mF + m4 * m3 * mD + mC * m1 * m7 - mC * m3 * m5;
        inv[14] = -m0 * m5 * mE + m0 * m6 * mD + m4 * m1 * mE - m4 * m2 * mD - mC * m1 * m6 + mC * m2 * m5;
        inv[3] = -m1 * m6 * mB + m1 * m7 * mA + m5 * m2 * mB - m5 * m3 * mA - m9 * m2 * m7 + m9 * m3 * m6;
        inv[7] = m0 * m6 * mB - m0 * m7 * mA - m4 * m2 * mB + m4 * m3 * mA + m8 * m2 * m7 - m8 * m3 * m6;
        inv[11] = -m0 * m5 * mB + m0 * m7 * m9 + m4 * m1 * mB - m4 * m3 * m9 - m8 * m1 * m7 + m8 * m3 * m5;
        inv[15] = m0 * m5 * mA - m0 * m6 * m9 - m4 * m1 * mA + m4 * m2 * m9 + m8 * m1 * m6 - m8 * m2 * m5;
        float det = m0 * inv[0] + m1 * inv[4] + m2 * inv[8] + m3 * inv[12];
        if (Math.abs(det) <= 1.0E-8f) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Matrix is not invertible, determinant is " + det + ", returning identity");
            }
            MathUtils.setIdentity4x4(inv);
            return;
        }
        float invDet = 1.0f / det;
        int i = 0;
        while (i < 16) {
            int n = i++;
            inv[n] = inv[n] * invDet;
        }
    }

    public static void invert3x3(float[] m, float[] inv) {
        float m0 = m[0];
        float m4 = m[4];
        float m8 = m[8];
        float m5 = m[5];
        float m7 = m[7];
        float m3 = m[3];
        float m1 = m[1];
        float m2 = m[2];
        float m6 = m[6];
        float det = m0 * (m4 * m8 - m5 * m7) - m3 * (m1 * m8 - m7 * m2) + m6 * (m1 * m5 - m4 * m2);
        if (Math.abs(det) <= 1.0E-8f) {
            if (logger.isLoggable(Level.FINE)) {
                logger.fine("Matrix is not invertible, determinant is " + det + ", returning identity");
            }
            MathUtils.setIdentity3x3(inv);
            return;
        }
        float invDet = 1.0f / det;
        inv[0] = (m4 * m8 - m5 * m7) * invDet;
        inv[3] = (m6 * m5 - m3 * m8) * invDet;
        inv[6] = (m3 * m7 - m6 * m4) * invDet;
        inv[1] = (m7 * m2 - m1 * m8) * invDet;
        inv[4] = (m0 * m8 - m6 * m2) * invDet;
        inv[7] = (m1 * m6 - m0 * m7) * invDet;
        inv[2] = (m1 * m5 - m2 * m4) * invDet;
        inv[5] = (m2 * m3 - m0 * m5) * invDet;
        inv[8] = (m0 * m4 - m1 * m3) * invDet;
    }

    public static void translate(float[] m, float x, float y, float z, float[] result) {
        MathUtils.set(m, result);
        result[12] = result[12] + x;
        result[13] = result[13] + y;
        result[14] = result[14] + z;
    }

    public static void infinitePerspective4x4(float fovyDeg, float aspect, float zNear, float[] m) {
        MathUtils.setIdentity4x4(m);
        float fovyRad = (float)Math.toRadians(fovyDeg);
        float t = (float)Math.tan(0.5 * (double)fovyRad);
        m[0] = 1.0f / (aspect * t);
        m[5] = 1.0f / t;
        m[10] = -1.0f;
        m[11] = -1.0f;
        m[14] = 2.0f * zNear;
        m[15] = 0.0f;
    }

    public static void perspective4x4(float fovyDeg, float aspect, float zNear, float zFar, float[] m) {
        MathUtils.setIdentity4x4(m);
        float fovyRad = (float)Math.toRadians(fovyDeg);
        float t = (float)Math.tan(0.5 * (double)fovyRad);
        m[0] = 1.0f / (aspect * t);
        m[5] = 1.0f / t;
        m[10] = (zFar + zNear) / (zNear - zFar);
        m[11] = -1.0f;
        m[14] = 2.0f * zFar * zNear / (zNear - zFar);
        m[15] = 0.0f;
    }

    private static float dot(float[] a, float[] b) {
        float sum = 0.0f;
        for (int i = 0; i < a.length; ++i) {
            sum += a[i] * b[i];
        }
        return sum;
    }

    public static void transformPoint3D(float[] matrix4x4, float[] point3D, float[] result3D) {
        Arrays.fill(result3D, 0.0f);
        int r = 0;
        while (r < 3) {
            for (int c = 0; c < 3; ++c) {
                int index = c * 4 + r;
                float m = matrix4x4[index];
                int n = r;
                result3D[n] = result3D[n] + m * point3D[c];
            }
            int index = 12 + r;
            float m = matrix4x4[index];
            int n = r++;
            result3D[n] = result3D[n] + m;
        }
    }

    public static String createMatrixString(float[] array) {
        if (array == null) {
            return "null";
        }
        if (array.length == 9) {
            return MathUtils.createMatrixString(array, 3, 3);
        }
        if (array.length == 16) {
            return MathUtils.createMatrixString(array, 4, 4);
        }
        return "WARNING: Not a matrix: " + Arrays.toString(array);
    }

    private static String createMatrixString(float[] array, int rows, int cols) {
        StringBuilder sb = new StringBuilder();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                sb.append(array[r + c * cols]);
                sb.append(", ");
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    public static String createFormattedMatrixString(float[] array) {
        if (array == null) {
            return "null";
        }
        String format = "%10.5f ";
        if (array.length == 9) {
            return MathUtils.createFormattedMatrixString(array, 3, 3, format);
        }
        if (array.length == 16) {
            return MathUtils.createFormattedMatrixString(array, 4, 4, format);
        }
        return "WARNING: Not a matrix: " + Arrays.toString(array);
    }

    private static String createFormattedMatrixString(float[] array, int rows, int cols, String format) {
        StringBuilder sb = new StringBuilder();
        for (int r = 0; r < rows; ++r) {
            for (int c = 0; c < cols; ++c) {
                sb.append(String.format(Locale.ENGLISH, format, Float.valueOf(array[r + c * cols])));
            }
            sb.append("\n");
        }
        return sb.toString();
    }

    private MathUtils() {
    }
}

