/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.animation;

import com.voxelbridge.shadow.jgltf.model.animation.Interpolator;

class SlerpQuaternionInterpolator
implements Interpolator {
    SlerpQuaternionInterpolator() {
    }

    @Override
    public void interpolate(float[] a, float[] b, float alpha, float[] result) {
        float s1;
        float s0;
        float epsilon;
        float ax = a[0];
        float bx = b[0];
        float ay = a[1];
        float by = b[1];
        float az = a[2];
        float bz = b[2];
        float aw = a[3];
        float bw = b[3];
        float dot = ax * bx + ay * by + az * bz + aw * bw;
        if (dot < 0.0f) {
            bx = -bx;
            by = -by;
            bz = -bz;
            bw = -bw;
            dot = -dot;
        }
        if (1.0 - (double)dot > (double)(epsilon = 1.0E-6f)) {
            float omega = (float)Math.acos(dot);
            float invSinOmega = 1.0f / (float)Math.sin(omega);
            s0 = (float)Math.sin((1.0 - (double)alpha) * (double)omega) * invSinOmega;
            s1 = (float)Math.sin(alpha * omega) * invSinOmega;
        } else {
            s0 = 1.0f - alpha;
            s1 = alpha;
        }
        float rx = s0 * ax + s1 * bx;
        float ry = s0 * ay + s1 * by;
        float rz = s0 * az + s1 * bz;
        float rw = s0 * aw + s1 * bw;
        result[0] = rx;
        result[1] = ry;
        result[2] = rz;
        result[3] = rw;
    }
}

