/*
 * Decompiled with CFR 0.152.
 */
package com.voxelbridge.shadow.jgltf.model.extensions;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.voxelbridge.shadow.jgltf.impl.v1.GlTFProperty;
import com.voxelbridge.shadow.jgltf.model.io.JacksonUtils;
import java.util.Map;

public class GltfExtensions {
    public static <T> T obtain(Object gltfProperty, String extensionName, Class<T> extensionType) {
        if (gltfProperty instanceof GlTFProperty) {
            GlTFProperty gltfPropertyV1 = (GlTFProperty)gltfProperty;
            Map<String, Object> extensions = gltfPropertyV1.getExtensions();
            return GltfExtensions.obtainInternal(extensions, extensionName, extensionType);
        }
        if (gltfProperty instanceof com.voxelbridge.shadow.jgltf.impl.v2.GlTFProperty) {
            com.voxelbridge.shadow.jgltf.impl.v2.GlTFProperty gltfPropertyV2 = (com.voxelbridge.shadow.jgltf.impl.v2.GlTFProperty)gltfProperty;
            Map<String, Object> extensions = gltfPropertyV2.getExtensions();
            return GltfExtensions.obtainInternal(extensions, extensionName, extensionType);
        }
        throw new IllegalArgumentException("Not a valid glTF property: " + gltfProperty);
    }

    private static <T> T obtainInternal(Map<String, Object> extensions, String extensionName, Class<T> extensionType) {
        if (extensions == null) {
            return null;
        }
        Object object = extensions.get(extensionName);
        if (object == null) {
            return null;
        }
        return GltfExtensions.convertValueOptional(object, extensionType);
    }

    private static <T> T convertValue(Object object, Class<T> type) throws IllegalArgumentException {
        ObjectMapper objectMapper = JacksonUtils.createObjectMapper();
        return objectMapper.convertValue(object, type);
    }

    private static <T> T convertValueOptional(Object object, Class<T> type) {
        try {
            return GltfExtensions.convertValue(object, type);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private GltfExtensions() {
    }
}

